/*
 * Decompiled with CFR 0.152.
 */
package hudson;

import com.thoughtworks.xstream.converters.reflection.PureJavaReflectionProvider;
import com.thoughtworks.xstream.core.JVM;
import hudson.EnvVars;
import hudson.ExpressionFactory2;
import hudson.Functions;
import hudson.Main;
import hudson.Util;
import hudson.model.Hudson;
import hudson.security.ACL;
import hudson.security.ACLContext;
import hudson.util.AWTProblem;
import hudson.util.BootFailure;
import hudson.util.ChartUtil;
import hudson.util.HudsonFailedToLoad;
import hudson.util.HudsonIsLoading;
import hudson.util.IncompatibleAntVersionDetected;
import hudson.util.IncompatibleServletVersionDetected;
import hudson.util.IncompatibleVMDetected;
import hudson.util.InsufficientPermissionDetected;
import hudson.util.NoHomeDir;
import hudson.util.NoTempDir;
import hudson.util.RingBufferLogHandler;
import io.jenkins.servlet.ServletContextEventWrapper;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletContextEvent;
import jakarta.servlet.ServletContextListener;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.SessionTrackingMode;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.security.Security;
import java.util.Date;
import java.util.EnumSet;
import java.util.Locale;
import java.util.logging.ConsoleHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jenkins.util.JenkinsJVM;
import jenkins.util.SystemProperties;
import org.apache.commons.jelly.expression.ExpressionFactory;
import org.apache.tools.ant.types.FileSet;
import org.jvnet.localizer.LocaleProvider;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.jelly.JellyFacet;

public class WebAppMain
implements ServletContextListener {
    @Restricted(value={NoExternalUse.class})
    public static final String FORCE_SESSION_TRACKING_BY_COOKIE_PROP = WebAppMain.class.getName() + ".forceSessionTrackingByCookie";
    private final RingBufferLogHandler handler = new RingBufferLogHandler(WebAppMain.getDefaultRingBufferSize()){

        @Override
        public synchronized void publish(LogRecord record) {
            if (record.getLevel().intValue() >= Level.INFO.intValue()) {
                super.publish(record);
            }
        }
    };
    private static final String APP = "app";
    private boolean terminated;
    private Thread initThread;
    private static final Logger LOGGER = Logger.getLogger(WebAppMain.class.getName());
    private static final String[] HOME_NAMES = new String[]{"JENKINS_HOME", "HUDSON_HOME"};

    public static int getDefaultRingBufferSize() {
        return RingBufferLogHandler.getDefaultRingBufferSize();
    }

    public void contextInitialized(ServletContextEvent event) {
        if (Main.isDevelopmentMode && System.getProperty("java.util.logging.config.file") == null) {
            try {
                Formatter formatter = (Formatter)Class.forName("io.jenkins.lib.support_log_formatter.SupportLogFormatter").getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                for (Handler h : Logger.getLogger("").getHandlers()) {
                    if (!(h instanceof ConsoleHandler)) continue;
                    h.setFormatter(formatter);
                }
            }
            catch (ClassNotFoundException formatter) {
            }
            catch (Exception x) {
                LOGGER.log(Level.WARNING, null, x);
            }
        }
        JenkinsJVMAccess._setJenkinsJVM(true);
        final ServletContext context = event.getServletContext();
        File home = null;
        try {
            JVM jvm;
            LocaleProvider.setProvider((LocaleProvider)new LocaleProvider(){

                public Locale get() {
                    return Functions.getCurrentLocale();
                }
            });
            try {
                jvm = new JVM();
                new URLClassLoader(new URL[0], this.getClass().getClassLoader());
            }
            catch (SecurityException e) {
                throw new InsufficientPermissionDetected(e);
            }
            try {
                Security.removeProvider("SunPKCS11-Solaris");
            }
            catch (SecurityException e) {
                // empty catch block
            }
            this.installLogger();
            FileAndDescription describedHomeDir = this.getHomeDir(event);
            home = describedHomeDir.file.getAbsoluteFile();
            try {
                Util.createDirectories(home.toPath(), new FileAttribute[0]);
            }
            catch (IOException | InvalidPathException e) {
                throw (NoHomeDir)new NoHomeDir(home).initCause(e);
            }
            LOGGER.info("Jenkins home directory: " + home + " found at: " + describedHomeDir.description);
            this.recordBootAttempt(home);
            if (jvm.bestReflectionProvider().getClass() == PureJavaReflectionProvider.class) {
                throw new IncompatibleVMDetected();
            }
            try {
                ServletResponse.class.getMethod("setCharacterEncoding", String.class);
            }
            catch (NoSuchMethodException e) {
                throw (IncompatibleServletVersionDetected)new IncompatibleServletVersionDetected(ServletResponse.class).initCause(e);
            }
            try {
                FileSet.class.getMethod("getDirectoryScanner", new Class[0]);
            }
            catch (NoSuchMethodException e) {
                throw (IncompatibleAntVersionDetected)new IncompatibleAntVersionDetected(FileSet.class).initCause(e);
            }
            if (ChartUtil.awtProblemCause != null) {
                throw new AWTProblem(ChartUtil.awtProblemCause);
            }
            try {
                File f = File.createTempFile("test", "test");
                boolean result = f.delete();
                if (!result) {
                    LOGGER.log(Level.FINE, "Temp file test.test could not be deleted.");
                }
            }
            catch (IOException e) {
                throw new NoTempDir(e);
            }
            WebAppMain.installExpressionFactory(event);
            context.setAttribute(APP, (Object)new HudsonIsLoading());
            if (SystemProperties.getBoolean(FORCE_SESSION_TRACKING_BY_COOKIE_PROP, true)) {
                context.setSessionTrackingModes(EnumSet.of(SessionTrackingMode.COOKIE));
            }
            final File _home = home;
            this.initThread = new Thread("Jenkins initialization thread"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    boolean success = false;
                    try {
                        Jenkins instance = new Hudson(_home, context);
                        if (Thread.interrupted()) {
                            throw new InterruptedException();
                        }
                        context.setAttribute(WebAppMain.APP, (Object)instance);
                        Files.deleteIfExists(BootFailure.getBootFailureFile(_home).toPath());
                        Jenkins.get().getLifecycle().onReady();
                        success = true;
                    }
                    catch (Error e) {
                        new HudsonFailedToLoad(e).publish(context, _home);
                        throw e;
                    }
                    catch (Exception e) {
                        Throwable error = this.unwrapException(e);
                        if (error instanceof InvocationTargetException) {
                            Throwable targetException = ((InvocationTargetException)error).getTargetException();
                            if (targetException instanceof BootFailure) {
                                ((BootFailure)targetException).publish(context, _home);
                            } else {
                                new HudsonFailedToLoad(e).publish(context, _home);
                            }
                        } else {
                            new HudsonFailedToLoad(e).publish(context, _home);
                        }
                    }
                    finally {
                        Jenkins instance = Jenkins.getInstanceOrNull();
                        if (!success && instance != null) {
                            instance.cleanUp();
                        }
                    }
                }

                private Throwable unwrapException(Exception e) {
                    Throwable error = e;
                    while (error.getCause() != null) {
                        if (error.getCause() instanceof InvocationTargetException) {
                            return error.getCause();
                        }
                        error = error.getCause();
                    }
                    return error;
                }
            };
            this.initThread.start();
        }
        catch (BootFailure e) {
            e.publish(context, home);
        }
        catch (Error | RuntimeException e) {
            LOGGER.log(Level.SEVERE, "Failed to initialize Jenkins", e);
            throw e;
        }
    }

    public void joinInit() throws InterruptedException {
        this.initThread.join();
    }

    private void recordBootAttempt(File home) {
        try (OutputStream o = Files.newOutputStream(BootFailure.getBootFailureFile(home).toPath(), StandardOpenOption.CREATE, StandardOpenOption.APPEND);){
            o.write((new Date() + System.getProperty("line.separator", "\n")).getBytes(Charset.defaultCharset()));
        }
        catch (IOException | InvalidPathException e) {
            LOGGER.log(Level.WARNING, "Failed to record boot attempts", e);
        }
    }

    public static void installExpressionFactory(ServletContextEvent event) {
        JellyFacet.setExpressionFactory((ServletContextEvent)event, (ExpressionFactory)new ExpressionFactory2());
    }

    @Deprecated
    public static void installExpressionFactory(javax.servlet.ServletContextEvent event) {
        WebAppMain.installExpressionFactory(ServletContextEventWrapper.toJakartaServletContextEvent((javax.servlet.ServletContextEvent)event));
    }

    private void installLogger() {
        Jenkins.logRecords = this.handler.getView();
        Logger.getLogger("").addHandler(this.handler);
    }

    public FileAndDescription getHomeDir(ServletContextEvent event) {
        File ws;
        for (String name : HOME_NAMES) {
            String sysProp = SystemProperties.getString(name);
            if (sysProp == null) continue;
            return new FileAndDescription(new File(sysProp.trim()), "SystemProperties.getProperty(\"" + name + "\")");
        }
        for (String name : HOME_NAMES) {
            String env = EnvVars.masterEnvVars.get(name);
            if (env == null) continue;
            return new FileAndDescription(new File(env.trim()).getAbsoluteFile(), "EnvVars.masterEnvVars.get(\"" + name + "\")");
        }
        String root = event.getServletContext().getRealPath("/WEB-INF/workspace");
        if (root != null && (ws = new File(root.trim())).exists()) {
            return new FileAndDescription(ws, "getServletContext().getRealPath(\"/WEB-INF/workspace\")");
        }
        File legacyHome = new File(new File(System.getProperty("user.home")), ".hudson");
        if (legacyHome.exists()) {
            return new FileAndDescription(legacyHome, "$user.home/.hudson");
        }
        File newHome = new File(new File(System.getProperty("user.home")), ".jenkins");
        return new FileAndDescription(newHome, "$user.home/.jenkins");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void contextDestroyed(ServletContextEvent event) {
        try (ACLContext old = ACL.as2(ACL.SYSTEM2);){
            Jenkins instance = Jenkins.getInstanceOrNull();
            try {
                if (instance != null) {
                    instance.cleanUp();
                }
            }
            catch (Throwable e) {
                LOGGER.log(Level.SEVERE, "Failed to clean up. Restart will continue.", e);
            }
            this.terminated = true;
            Thread t = this.initThread;
            if (t != null && t.isAlive()) {
                LOGGER.log(Level.INFO, "Shutting down a Jenkins instance that was still starting up", new Throwable("reason"));
                t.interrupt();
            }
            Logger.getLogger("").removeHandler(this.handler);
        }
        finally {
            JenkinsJVMAccess._setJenkinsJVM(false);
        }
    }

    private static final class JenkinsJVMAccess
    extends JenkinsJVM {
        private JenkinsJVMAccess() {
        }

        private static void _setJenkinsJVM(boolean jenkinsJVM) {
            JenkinsJVM.setJenkinsJVM(jenkinsJVM);
        }
    }

    public static class FileAndDescription {
        public final File file;
        public final String description;

        public FileAndDescription(File file, String description) {
            this.file = file;
            this.description = description;
        }
    }
}

