/*
 * Decompiled with CFR 0.152.
 */
package hudson.console;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.MarkupText;
import hudson.Util;
import hudson.console.ConsoleAnnotationDescriptor;
import hudson.console.ConsoleAnnotator;
import hudson.console.ConsoleNote;
import java.io.IOException;
import java.util.function.BiFunction;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.jenkinsci.Symbol;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest2;

public class HyperlinkNote
extends ConsoleNote {
    private final String url;
    private final int length;
    private static final Logger LOGGER = Logger.getLogger(HyperlinkNote.class.getName());
    private static final long serialVersionUID = 3908468829358026949L;

    public HyperlinkNote(String url, int length) {
        this.url = url;
        this.length = length;
    }

    public ConsoleAnnotator annotate(Object context, MarkupText text, int charPos) {
        Object url = this.url;
        if (((String)url).startsWith("/")) {
            StaplerRequest2 req = Stapler.getCurrentRequest2();
            url = req != null ? req.getContextPath() + (String)url : Jenkins.get().getRootUrl() + ((String)url).substring(1);
        }
        text.addMarkup(charPos, charPos + this.length, "<a href='" + Util.escape((String)url) + "'" + this.extraAttributes() + ">", "</a>");
        return null;
    }

    protected String extraAttributes() {
        return "";
    }

    public static String encodeTo(String url, String text) {
        return HyperlinkNote.encodeTo(url, text, HyperlinkNote::new);
    }

    @Restricted(value={NoExternalUse.class})
    static String encodeTo(String url, String text, BiFunction<String, Integer, ConsoleNote> constructor) {
        text = text.replace('\n', ' ').replace('\r', ' ');
        try {
            return constructor.apply(url, text.length()).encode() + text;
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Failed to serialize " + HyperlinkNote.class, e);
            return text;
        }
    }

    @Extension
    @Symbol(value={"hyperlink"})
    public static class DescriptorImpl
    extends ConsoleAnnotationDescriptor {
        @Override
        @NonNull
        public String getDisplayName() {
            return "Hyperlinks";
        }
    }
}

