/*
 * Decompiled with CFR 0.152.
 */
package hudson.model;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.FilePath;
import hudson.Util;
import hudson.model.ModelObject;
import io.jenkins.servlet.ServletExceptionWrapper;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.GregorianCalendar;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import jenkins.security.MasterToSlaveCallable;
import jenkins.security.ResourceDomainConfiguration;
import jenkins.security.ResourceDomainRootAction;
import jenkins.util.SystemProperties;
import jenkins.util.VirtualFile;
import org.apache.commons.io.IOUtils;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipOutputStream;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.StaplerResponse2;

public final class DirectoryBrowserSupport
implements HttpResponse {
    @SuppressFBWarnings(value={"MS_SHOULD_BE_FINAL"}, justification="Accessible via System Groovy Scripts")
    public static boolean ALLOW_SYMLINK_ESCAPE = SystemProperties.getBoolean(DirectoryBrowserSupport.class.getName() + ".allowSymlinkEscape");
    @SuppressFBWarnings(value={"MS_SHOULD_BE_FINAL"}, justification="Accessible via System Groovy Scripts")
    public static boolean ALLOW_TMP_DISPLAY = SystemProperties.getBoolean(DirectoryBrowserSupport.class.getName() + ".allowTmpEscape");
    private static final Pattern TMPDIR_PATTERN = Pattern.compile(".+@tmp/.*");
    public final ModelObject owner;
    public final String title;
    private final VirtualFile base;
    private final String icon;
    private final boolean serveDirIndex;
    private String indexFileName = "index.html";
    @Restricted(value={NoExternalUse.class})
    public static final String CSP_PROPERTY_NAME = DirectoryBrowserSupport.class.getName() + ".CSP";
    private ResourceDomainRootAction.Token resourceToken;
    private static final Logger LOGGER = Logger.getLogger(DirectoryBrowserSupport.class.getName());
    @Restricted(value={NoExternalUse.class})
    public static final String DEFAULT_CSP_VALUE = "sandbox allow-same-origin; default-src 'none'; img-src 'self'; style-src 'self';";

    @Deprecated
    public DirectoryBrowserSupport(ModelObject owner, String title) {
        this(owner, (VirtualFile)null, title, null, false);
    }

    public DirectoryBrowserSupport(ModelObject owner, FilePath base, String title, String icon, boolean serveDirIndex) {
        this(owner, base.toVirtualFile(), title, icon, serveDirIndex);
    }

    public DirectoryBrowserSupport(ModelObject owner, VirtualFile base, String title, String icon, boolean serveDirIndex) {
        this.owner = owner;
        this.base = base;
        this.title = title;
        this.icon = icon;
        this.serveDirIndex = serveDirIndex;
    }

    public void generateResponse(StaplerRequest2 req, StaplerResponse2 rsp, Object node) throws IOException, jakarta.servlet.ServletException {
        if (!ResourceDomainConfiguration.isResourceRequest((HttpServletRequest)req) && ResourceDomainConfiguration.isResourceDomainConfigured()) {
            this.resourceToken = ResourceDomainRootAction.get().getToken(this, req);
        }
        try {
            this.serveFile(req, rsp, this.base, this.icon, this.serveDirIndex);
        }
        catch (InterruptedException e) {
            throw new IOException("interrupted", e);
        }
    }

    public void setIndexFileName(String fileName) {
        this.indexFileName = fileName;
    }

    @Deprecated
    public void serveFile(StaplerRequest req, StaplerResponse rsp, FilePath root, String icon, boolean serveDirIndex) throws IOException, ServletException, InterruptedException {
        try {
            this.serveFile(StaplerRequest.toStaplerRequest2((StaplerRequest)req), StaplerResponse.toStaplerResponse2((StaplerResponse)rsp), root.toVirtualFile(), icon, serveDirIndex);
        }
        catch (jakarta.servlet.ServletException e) {
            throw ServletExceptionWrapper.fromJakartaServletException((jakarta.servlet.ServletException)e);
        }
    }

    private void serveFile(StaplerRequest2 req, StaplerResponse2 rsp, VirtualFile root, String icon, boolean serveDirIndex) throws IOException, jakarta.servlet.ServletException, InterruptedException {
        VirtualFile baseFile;
        String pattern = req.getParameter("pattern");
        if (pattern == null) {
            pattern = req.getParameter("path");
        }
        if (pattern != null && Util.isSafeToRedirectTo(pattern)) {
            rsp.sendRedirect2(pattern);
            return;
        }
        String path = this.getPath(req);
        if (path.replace('\\', '/').contains("/../")) {
            rsp.sendError(400);
            return;
        }
        StringBuilder _base = new StringBuilder();
        StringBuilder _rest = new StringBuilder();
        int restSize = -1;
        boolean zip = false;
        boolean plain = false;
        boolean inBase = true;
        StringTokenizer pathTokens = new StringTokenizer(path, "/");
        while (pathTokens.hasMoreTokens()) {
            StringBuilder sb;
            String pathElement = pathTokens.nextToken();
            if ((pathElement.contains("?") || pathElement.contains("*")) && inBase && !root.child((String)(!_base.isEmpty() ? _base + "/" : "") + pathElement).exists()) {
                inBase = false;
            }
            if (pathElement.equals("*zip*")) {
                zip = true;
                break;
            }
            if (pathElement.equals("*plain*")) {
                plain = true;
                break;
            }
            StringBuilder stringBuilder = sb = inBase ? _base : _rest;
            if (!sb.isEmpty()) {
                sb.append('/');
            }
            sb.append(pathElement);
            if (inBase) continue;
            ++restSize;
        }
        restSize = Math.max(restSize, 0);
        String base = _base.toString();
        String rest = _rest.toString();
        if (base.isEmpty()) {
            baseFile = root;
        } else {
            boolean isAbsolute = root.run(new IsAbsolute(base));
            if (isAbsolute) {
                LOGGER.info(() -> "SECURITY-2481 The path provided in the URL (" + base + ") is absolute and thus is refused.");
                rsp.sendError(404);
                return;
            }
            baseFile = root.child(base);
        }
        if (baseFile.hasSymlink(DirectoryBrowserSupport.getOpenOptions()) || this.hasTmpDir(baseFile, base, DirectoryBrowserSupport.getOpenOptions())) {
            rsp.sendError(404);
            return;
        }
        if (baseFile.isDirectory()) {
            StringBuffer reqUrl;
            if (zip) {
                String prefix;
                String includes;
                rsp.setContentType("application/zip");
                if (rest == null || rest.isBlank()) {
                    includes = "**";
                    prefix = baseFile.getName();
                } else {
                    includes = rest;
                    prefix = "";
                }
                baseFile.zip((OutputStream)rsp.getOutputStream(), includes, null, true, prefix, DirectoryBrowserSupport.getOpenOptions());
                return;
            }
            if (plain) {
                rsp.setContentType("text/plain;charset=UTF-8");
                try (ServletOutputStream os = rsp.getOutputStream();){
                    for (VirtualFile kid : baseFile.list(DirectoryBrowserSupport.getOpenOptions())) {
                        os.write(kid.getName().getBytes(StandardCharsets.UTF_8));
                        if (kid.isDirectory()) {
                            os.write(47);
                        }
                        os.write(10);
                    }
                    os.flush();
                }
                return;
            }
            if (rest.isEmpty() && (reqUrl = req.getRequestURL()).charAt(reqUrl.length() - 1) != '/') {
                rsp.sendRedirect2(reqUrl.append('/').toString());
                return;
            }
            List<List<Path>> glob = null;
            boolean patternUsed = !rest.isEmpty();
            boolean containsSymlink = false;
            boolean containsTmpDir = false;
            if (patternUsed) {
                glob = DirectoryBrowserSupport.patternScan(baseFile, rest, DirectoryBrowserSupport.createBackRef(restSize));
            } else if (serveDirIndex) {
                BuildChildPathsResult result = baseFile.run(new BuildChildPaths(baseFile, req.getLocale(), DirectoryBrowserSupport.getOpenOptions()));
                glob = result.glob;
                containsSymlink = result.containsSymLink;
                containsTmpDir = result.containsTmpDir;
            }
            if (glob != null) {
                req.setAttribute("it", (Object)this);
                List<Path> parentPaths = this.buildParentPath(base, restSize);
                req.setAttribute("parentPath", parentPaths);
                req.setAttribute("backPath", (Object)DirectoryBrowserSupport.createBackRef(restSize));
                req.setAttribute("topPath", (Object)DirectoryBrowserSupport.createBackRef(parentPaths.size() + restSize));
                req.setAttribute("files", glob);
                req.setAttribute("icon", (Object)icon);
                req.setAttribute("path", (Object)path);
                req.setAttribute("pattern", (Object)rest);
                req.setAttribute("dir", (Object)baseFile);
                req.setAttribute("showSymlinkWarning", (Object)containsSymlink);
                req.setAttribute("showTmpDirWarning", (Object)containsTmpDir);
                if (ResourceDomainConfiguration.isResourceRequest((HttpServletRequest)req)) {
                    req.getView((Object)this, "plaindir.jelly").forward((ServletRequest)req, (ServletResponse)rsp);
                } else {
                    req.getView((Object)this, "dir.jelly").forward((ServletRequest)req, (ServletResponse)rsp);
                }
                return;
            }
            baseFile = baseFile.child(this.indexFileName);
        }
        if (!baseFile.exists()) {
            rsp.sendError(404);
            return;
        }
        boolean view = rest.equals("*view*");
        if (rest.equals("*fingerprint*")) {
            try (InputStream fingerprintInput = baseFile.open();){
                rsp.forward(Jenkins.get().getFingerprint(Util.getDigestOf(fingerprintInput)), "/", req);
            }
            return;
        }
        URL external = baseFile.toExternalURL();
        if (external != null) {
            rsp.sendRedirect2(external.toExternalForm());
            return;
        }
        long lastModified = baseFile.lastModified();
        long length = baseFile.length();
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Serving " + baseFile + " with lastModified=" + lastModified + ", length=" + length);
        }
        if (view) {
            InputStream in;
            try {
                in = baseFile.open(DirectoryBrowserSupport.getOpenOptions());
            }
            catch (IOException ioe) {
                rsp.sendError(404);
                return;
            }
            rsp.setHeader("Content-Disposition", "inline; filename=" + baseFile.getName());
            rsp.serveFile(req, in, lastModified, -1L, length, "plain.txt");
        } else if (this.resourceToken != null) {
            rsp.sendRedirect(302, ResourceDomainRootAction.get().getRedirectUrl(this.resourceToken, req.getRestOfPath()));
        } else {
            InputStream in;
            String csp;
            if (!ResourceDomainConfiguration.isResourceRequest((HttpServletRequest)req) && !(csp = SystemProperties.getString(CSP_PROPERTY_NAME, DEFAULT_CSP_VALUE)).trim().isEmpty()) {
                for (String header : new String[]{"Content-Security-Policy", "X-WebKit-CSP", "X-Content-Security-Policy"}) {
                    rsp.setHeader(header, csp);
                }
            }
            try {
                in = baseFile.open(DirectoryBrowserSupport.getOpenOptions());
            }
            catch (IOException ioe) {
                rsp.sendError(404);
                return;
            }
            rsp.serveFile(req, in, lastModified, -1L, length, baseFile.getName());
        }
    }

    private boolean hasTmpDir(VirtualFile baseFile, String base, OpenOption[] openOptions) {
        if (FilePath.isTmpDir(baseFile.getName(), openOptions)) {
            return true;
        }
        return FilePath.isIgnoreTmpDirs(openOptions) && TMPDIR_PATTERN.matcher(base).matches();
    }

    private List<List<Path>> keepReadabilityOnlyOnDescendants(VirtualFile root, boolean patternUsed, List<List<Path>> pathFragmentsList) {
        Stream<List> pathFragmentsStream = pathFragmentsList.stream().map(pathFragments -> {
            ArrayList<Path> mappedFragments = new ArrayList<Path>(pathFragments.size());
            Object relativePath = "";
            for (int i = 0; i < pathFragments.size(); ++i) {
                Path current = (Path)pathFragments.get(i);
                relativePath = i == 0 ? current.title : (String)relativePath + "/" + current.title;
                if (!current.isReadable) {
                    if (patternUsed) {
                        return null;
                    }
                    mappedFragments.add(current);
                    return mappedFragments;
                }
                if (!this.isDescendant(root, (String)relativePath)) {
                    if (patternUsed) {
                        return null;
                    }
                    mappedFragments.add(Path.createNotReadableVersionOf(current));
                    return mappedFragments;
                }
                mappedFragments.add(current);
            }
            return mappedFragments;
        });
        if (patternUsed) {
            pathFragmentsStream = pathFragmentsStream.filter(Objects::nonNull);
        }
        return pathFragmentsStream.collect(Collectors.toList());
    }

    private boolean isDescendant(VirtualFile root, String relativePath) {
        try {
            return ALLOW_SYMLINK_ESCAPE || !root.supportIsDescendant() || root.isDescendant(relativePath);
        }
        catch (IOException e) {
            return false;
        }
    }

    private String getPath(StaplerRequest2 req) {
        String path = req.getRestOfPath();
        if (path.isEmpty()) {
            path = "/";
        }
        return path;
    }

    private List<Path> buildParentPath(String pathList, int restSize) {
        ArrayList<Path> r = new ArrayList<Path>();
        StringTokenizer tokens = new StringTokenizer(pathList, "/");
        int total = tokens.countTokens();
        int current = 1;
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken();
            r.add(new Path(DirectoryBrowserSupport.createBackRef(total - current + restSize), token, true, 0L, true, 0L));
            ++current;
        }
        return r;
    }

    private static String createBackRef(int times) {
        if (times == 0) {
            return "./";
        }
        return "../".repeat(times);
    }

    private static void zip(StaplerResponse2 rsp, VirtualFile root, VirtualFile dir, String glob) throws IOException, InterruptedException {
        ServletOutputStream outputStream = rsp.getOutputStream();
        try (ZipOutputStream zos = new ZipOutputStream((OutputStream)outputStream);){
            zos.setEncoding(Charset.defaultCharset().displayName());
            if (glob.isEmpty() && !root.supportsQuickRecursiveListing()) {
                glob = "**";
            }
            if (glob.isEmpty()) {
                Map<String, VirtualFile> nameToVirtualFiles = DirectoryBrowserSupport.collectRecursivelyAllLegalChildren(dir);
                DirectoryBrowserSupport.sendZipUsingMap(zos, dir, nameToVirtualFiles);
            } else {
                Collection<String> listOfFile = dir.list(glob, null, true);
                DirectoryBrowserSupport.sendZipUsingListOfNames(zos, dir, listOfFile);
            }
        }
    }

    private static void sendZipUsingMap(ZipOutputStream zos, VirtualFile dir, Map<String, VirtualFile> nameToVirtualFiles) throws IOException {
        for (Map.Entry<String, VirtualFile> entry : nameToVirtualFiles.entrySet()) {
            String n = entry.getKey();
            String relativePath = dir.getName() + "/" + n;
            VirtualFile f = entry.getValue();
            DirectoryBrowserSupport.sendOneZipEntry(zos, f, relativePath);
        }
    }

    private static void sendZipUsingListOfNames(ZipOutputStream zos, VirtualFile dir, Collection<String> listOfFileNames) throws IOException {
        for (String relativePath : listOfFileNames) {
            VirtualFile f = dir.child(relativePath);
            DirectoryBrowserSupport.sendOneZipEntry(zos, f, relativePath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void sendOneZipEntry(ZipOutputStream zos, VirtualFile vf, String relativePath) throws IOException {
        ZipEntry e = new ZipEntry(relativePath.replace('\\', '/'));
        e.setTime(vf.lastModified());
        zos.putNextEntry(e);
        try (InputStream in = vf.open();){
            IOUtils.copy((InputStream)in, (OutputStream)zos);
        }
        finally {
            zos.closeEntry();
        }
    }

    private static Map<String, VirtualFile> collectRecursivelyAllLegalChildren(VirtualFile dir) throws IOException {
        LinkedHashMap<String, VirtualFile> nameToFiles = new LinkedHashMap<String, VirtualFile>();
        DirectoryBrowserSupport.collectRecursivelyAllLegalChildren(dir, "", nameToFiles);
        return nameToFiles;
    }

    private static void collectRecursivelyAllLegalChildren(VirtualFile currentDir, String currentPrefix, Map<String, VirtualFile> nameToFiles) throws IOException {
        if (currentDir.isFile()) {
            if (currentDir.isDescendant("")) {
                nameToFiles.put((String)currentPrefix, currentDir);
            }
        } else {
            if (!((String)currentPrefix).isEmpty()) {
                currentPrefix = (String)currentPrefix + "/";
            }
            List<VirtualFile> children = currentDir.listOnlyDescendants();
            for (VirtualFile child : children) {
                DirectoryBrowserSupport.collectRecursivelyAllLegalChildren(child, (String)currentPrefix + child.getName(), nameToFiles);
            }
        }
    }

    @SuppressFBWarnings(value={"SBSC_USE_STRINGBUFFER_CONCATENATION"}, justification="no big deal")
    private static List<List<Path>> buildChildPaths(VirtualFile cur, Locale locale) throws IOException {
        ArrayList<List<Path>> r = new ArrayList<List<Path>>();
        VirtualFile[] files = cur.list(DirectoryBrowserSupport.getOpenOptions());
        Arrays.sort(files, new FileComparator(locale));
        for (VirtualFile f : files) {
            Path p = new Path(Util.rawEncode(f.getName()), f.getName(), f.isDirectory(), f.length(), f.canRead(), f.lastModified());
            if (!f.isDirectory()) {
                r.add(List.of(p));
                continue;
            }
            ArrayList<Path> l = new ArrayList<Path>();
            l.add(p);
            Object relPath = Util.rawEncode(f.getName());
            while (true) {
                ArrayList<VirtualFile> sub = new ArrayList<VirtualFile>();
                for (VirtualFile vf : f.list(DirectoryBrowserSupport.getOpenOptions())) {
                    String name = vf.getName();
                    if (name.startsWith(".") || name.equals("CVS") || name.equals(".svn")) continue;
                    sub.add(vf);
                }
                if (sub.size() != 1 || !((VirtualFile)sub.get(0)).isDirectory()) break;
                f = (VirtualFile)sub.get(0);
                relPath = (String)relPath + "/" + Util.rawEncode(f.getName());
                l.add(new Path((String)relPath, f.getName(), true, f.length(), f.canRead(), f.lastModified()));
            }
            r.add(l);
        }
        return r;
    }

    private static List<List<Path>> patternScan(VirtualFile baseDir, String pattern, String baseRef) throws IOException {
        Collection<String> files = baseDir.list(pattern, null, true, DirectoryBrowserSupport.getOpenOptions());
        if (!files.isEmpty()) {
            ArrayList<List<Path>> r = new ArrayList<List<Path>>(files.size());
            for (String match : files) {
                List<Path> file = DirectoryBrowserSupport.buildPathList(baseDir, baseDir.child(match), baseRef);
                r.add(file);
            }
            return r;
        }
        return null;
    }

    private static List<Path> buildPathList(VirtualFile baseDir, VirtualFile filePath, String baseRef) throws IOException {
        ArrayList<Path> pathList = new ArrayList<Path>();
        StringBuilder href = new StringBuilder(baseRef);
        DirectoryBrowserSupport.buildPathList(baseDir, filePath, pathList, href);
        return pathList;
    }

    private static void buildPathList(VirtualFile baseDir, VirtualFile filePath, List<Path> pathList, StringBuilder href) throws IOException {
        VirtualFile parent = filePath.getParent();
        if (!baseDir.equals(parent)) {
            DirectoryBrowserSupport.buildPathList(baseDir, parent, pathList, href);
        }
        href.append(Util.rawEncode(filePath.getName()));
        if (filePath.isDirectory()) {
            href.append("/");
        }
        Path path = new Path(href.toString(), filePath.getName(), filePath.isDirectory(), filePath.length(), filePath.canRead(), filePath.lastModified());
        pathList.add(path);
    }

    private static OpenOption[] getOpenOptions() {
        ArrayList<Enum> options = new ArrayList<Enum>();
        if (!ALLOW_SYMLINK_ESCAPE) {
            options.add(LinkOption.NOFOLLOW_LINKS);
        }
        if (!ALLOW_TMP_DISPLAY) {
            options.add(FilePath.DisplayOption.IGNORE_TMP_DIRS);
        }
        return options.toArray(new OpenOption[0]);
    }

    private static final class IsAbsolute
    extends MasterToSlaveCallable<Boolean, IOException> {
        private final String fragment;

        IsAbsolute(String fragment) {
            this.fragment = fragment;
        }

        public Boolean call() throws IOException {
            return new File(this.fragment).isAbsolute();
        }
    }

    private static final class BuildChildPaths
    extends MasterToSlaveCallable<BuildChildPathsResult, IOException> {
        private final VirtualFile cur;
        private final Locale locale;
        private final OpenOption[] openOptions;

        BuildChildPaths(VirtualFile cur, Locale locale, OpenOption[] openOptions) {
            this.cur = cur;
            this.locale = locale;
            this.openOptions = openOptions;
        }

        public BuildChildPathsResult call() throws IOException {
            return new BuildChildPathsResult(DirectoryBrowserSupport.buildChildPaths(this.cur, this.locale), this.cur.containsSymLinkChild(this.openOptions), this.cur.containsTmpDirChild(this.openOptions));
        }
    }

    private static final class BuildChildPathsResult
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final List<List<Path>> glob;
        private final boolean containsSymLink;
        private final boolean containsTmpDir;

        BuildChildPathsResult(List<List<Path>> glob, boolean containsSymLink, boolean containsTmpDir) {
            this.glob = glob;
            this.containsSymLink = containsSymLink;
            this.containsTmpDir = containsTmpDir;
        }
    }

    public static final class Path
    implements Serializable {
        private final String href;
        private final String title;
        private final boolean isFolder;
        private final long size;
        private final boolean isReadable;
        private final long lastModified;
        private static final long serialVersionUID = 1L;

        @Deprecated
        public Path(String href, String title, boolean isFolder, long size, boolean isReadable) {
            this(href, title, isFolder, size, isReadable, 0L);
        }

        public Path(String href, String title, boolean isFolder, long size, boolean isReadable, long lastModified) {
            this.href = href;
            this.title = title;
            this.isFolder = isFolder;
            this.size = size;
            this.isReadable = isReadable;
            this.lastModified = lastModified;
        }

        public boolean isFolder() {
            return this.isFolder;
        }

        public boolean isReadable() {
            return this.isReadable;
        }

        public String getHref() {
            return this.href;
        }

        public String getTitle() {
            return this.title;
        }

        public String getIconName() {
            if (this.isReadable) {
                return this.isFolder ? "folder.svg" : "document.svg";
            }
            return this.isFolder ? "folder-delete.svg" : "document-delete.svg";
        }

        public String getIconClassName() {
            if (this.isReadable) {
                return this.isFolder ? "icon-folder" : "icon-document";
            }
            return this.isFolder ? "icon-folder-delete" : "icon-document-delete";
        }

        public long getSize() {
            return this.size;
        }

        public long getLastModified() {
            return this.lastModified;
        }

        @Restricted(value={NoExternalUse.class})
        public Calendar getLastModifiedAsCalendar() {
            GregorianCalendar cal = new GregorianCalendar();
            cal.setTimeInMillis(this.lastModified);
            return cal;
        }

        public static Path createNotReadableVersionOf(Path that) {
            return new Path(that.href, that.title, that.isFolder, that.size, false);
        }
    }

    private static final class FileComparator
    implements Comparator<VirtualFile> {
        private Collator collator;

        FileComparator(Locale locale) {
            this.collator = Collator.getInstance(locale);
        }

        @Override
        public int compare(VirtualFile lhs, VirtualFile rhs) {
            int r = this.dirRank(lhs) - this.dirRank(rhs);
            if (r != 0) {
                return r;
            }
            return this.collator.compare(lhs.getName(), rhs.getName());
        }

        private int dirRank(VirtualFile f) {
            try {
                if (f.isDirectory()) {
                    return 0;
                }
                return 1;
            }
            catch (IOException ex) {
                return 0;
            }
        }
    }
}

