/*
 * Decompiled with CFR 0.152.
 */
package hudson.model;

import com.google.common.annotations.VisibleForTesting;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.BulkChange;
import hudson.Extension;
import hudson.ExtensionPoint;
import hudson.Functions;
import hudson.PluginManager;
import hudson.PluginWrapper;
import hudson.ProxyConfiguration;
import hudson.Util;
import hudson.XmlFile;
import hudson.init.InitMilestone;
import hudson.init.Initializer;
import hudson.lifecycle.Lifecycle;
import hudson.lifecycle.RestartNotSupportedException;
import hudson.model.AbstractModelObject;
import hudson.model.AdministrativeMonitor;
import hudson.model.Api;
import hudson.model.Messages;
import hudson.model.Saveable;
import hudson.model.UpdateSite;
import hudson.model.User;
import hudson.model.listeners.SaveableListener;
import hudson.remoting.AtmostOneThreadExecutor;
import hudson.security.ACL;
import hudson.security.ACLContext;
import hudson.security.Permission;
import hudson.util.DaemonThreadFactory;
import hudson.util.FormValidation;
import hudson.util.HttpResponses;
import hudson.util.NamingThreadFactory;
import hudson.util.PersistedList;
import hudson.util.VersionNumber;
import hudson.util.XStream2;
import jakarta.servlet.ServletException;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.lang.reflect.Constructor;
import java.net.HttpRetryException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.StandardCopyOption;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLHandshakeException;
import jenkins.MissingDependencyException;
import jenkins.RestartRequiredException;
import jenkins.install.InstallUtil;
import jenkins.management.Badge;
import jenkins.model.Jenkins;
import jenkins.model.Loadable;
import jenkins.security.stapler.StaplerDispatchable;
import jenkins.security.stapler.StaplerNotDispatchable;
import jenkins.util.SystemProperties;
import jenkins.util.Timer;
import jenkins.util.io.OnMaster;
import net.sf.json.JSONObject;
import org.acegisecurity.Authentication;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.CountingInputStream;
import org.jenkinsci.Symbol;
import org.jvnet.localizer.Localizable;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.StaplerProxy;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse2;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;
import org.kohsuke.stapler.interceptor.RequirePOST;

@ExportedBean
public class UpdateCenter
extends AbstractModelObject
implements Loadable,
Saveable,
OnMaster,
StaplerProxy {
    private static final Logger LOGGER;
    private static final String UPDATE_CENTER_URL;
    private static final int PLUGIN_DOWNLOAD_READ_TIMEOUT;
    public static final String PREDEFINED_UPDATE_SITE_ID = "default";
    public static final String ID_DEFAULT;
    @Restricted(value={NoExternalUse.class})
    public static final String ID_UPLOAD = "_upload";
    private final ExecutorService installerService = new AtmostOneThreadExecutor((ThreadFactory)new NamingThreadFactory(new DaemonThreadFactory(), "Update center installer thread"));
    protected final ExecutorService updateService = Executors.newCachedThreadPool(new NamingThreadFactory(new DaemonThreadFactory(), "Update site data downloader"));
    private final Vector<UpdateCenterJob> jobs = new Vector();
    private final Set<UpdateSite> sourcesUsed = new HashSet<UpdateSite>();
    private final PersistedList<UpdateSite> sites = new PersistedList(this);
    private UpdateCenterConfiguration config;
    private boolean requiresRestart;
    private volatile transient boolean siteDataLoading;
    @Restricted(value={NoExternalUse.class})
    @SuppressFBWarnings(value={"MS_SHOULD_BE_FINAL"}, justification="for script console")
    public static boolean SKIP_PERMISSION_CHECK;
    private static final AtomicInteger iota;
    @Deprecated
    public static boolean neverUpdate;
    public static final XStream2 XSTREAM;

    public UpdateCenter() {
        this.configure(new UpdateCenterConfiguration());
    }

    UpdateCenter(@NonNull UpdateCenterConfiguration configuration) {
        this.configure(configuration);
    }

    @NonNull
    public static UpdateCenter createUpdateCenter(@CheckForNull UpdateCenterConfiguration config) {
        String requiredClassName = SystemProperties.getString(UpdateCenter.class.getName() + ".className", null);
        if (requiredClassName == null) {
            LOGGER.log(Level.FINE, "Using the default Update Center implementation");
            return UpdateCenter.createDefaultUpdateCenter(config);
        }
        LOGGER.log(Level.FINE, "Using the custom update center: {0}", requiredClassName);
        try {
            Class<UpdateCenter> clazz = Class.forName(requiredClassName).asSubclass(UpdateCenter.class);
            if (!UpdateCenter.class.isAssignableFrom(clazz)) {
                LOGGER.log(Level.SEVERE, "The specified custom Update Center {0} is not an instance of {1}. Falling back to default.", new Object[]{requiredClassName, UpdateCenter.class.getName()});
                return UpdateCenter.createDefaultUpdateCenter(config);
            }
            Class<UpdateCenter> ucClazz = clazz.asSubclass(UpdateCenter.class);
            Constructor<UpdateCenter> defaultConstructor = ucClazz.getConstructor(new Class[0]);
            Constructor<UpdateCenter> configConstructor = ucClazz.getConstructor(UpdateCenterConfiguration.class);
            LOGGER.log(Level.FINE, "Using the constructor {0} Update Center configuration for {1}", new Object[]{config != null ? "with" : "without", requiredClassName});
            return config != null ? configConstructor.newInstance(config) : defaultConstructor.newInstance(new Object[0]);
        }
        catch (ClassCastException e) {
            LOGGER.log(Level.WARNING, "UpdateCenter class {0} does not extend hudson.model.UpdateCenter. Using default.", requiredClassName);
        }
        catch (NoSuchMethodException e) {
            LOGGER.log(Level.WARNING, String.format("UpdateCenter class %s does not define one of the required constructors. Using default", requiredClassName), e);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, String.format("Unable to instantiate custom plugin manager [%s]. Using default.", requiredClassName), e);
        }
        return UpdateCenter.createDefaultUpdateCenter(config);
    }

    @NonNull
    private static UpdateCenter createDefaultUpdateCenter(@CheckForNull UpdateCenterConfiguration config) {
        return config != null ? new UpdateCenter(config) : new UpdateCenter();
    }

    public Api getApi() {
        return new Api(this);
    }

    public void configure(UpdateCenterConfiguration config) {
        if (config != null) {
            this.config = config;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Exported
    @StaplerDispatchable
    public List<UpdateCenterJob> getJobs() {
        Vector<UpdateCenterJob> vector = this.jobs;
        synchronized (vector) {
            return new ArrayList<UpdateCenterJob>(this.jobs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UpdateCenterJob getJob(int id) {
        Vector<UpdateCenterJob> vector = this.jobs;
        synchronized (vector) {
            for (UpdateCenterJob job : this.jobs) {
                if (job.id != id) continue;
                return job;
            }
        }
        return null;
    }

    public InstallationJob getJob(UpdateSite.Plugin plugin) {
        List<UpdateCenterJob> jobList = this.getJobs();
        Collections.reverse(jobList);
        for (UpdateCenterJob job : jobList) {
            if (!(job instanceof InstallationJob)) continue;
            InstallationJob ij = (InstallationJob)job;
            if (!ij.plugin.name.equals(plugin.name) || !ij.plugin.sourceId.equals(plugin.sourceId)) continue;
            return ij;
        }
        return null;
    }

    @Restricted(value={NoExternalUse.class})
    public Badge getBadge() {
        if (!this.isSiteDataReady()) {
            return null;
        }
        List<UpdateSite.Plugin> plugins = this.getUpdates();
        int size = plugins.size();
        if (size > 0) {
            StringBuilder tooltip = new StringBuilder();
            Badge.Severity severity = Badge.Severity.WARNING;
            int securityFixSize = (int)plugins.stream().filter(UpdateSite.Plugin::fixesSecurityVulnerabilities).count();
            int incompatibleSize = (int)plugins.stream().filter(plugin -> !plugin.isCompatibleWithInstalledVersion()).count();
            if (size > 1) {
                tooltip.append(jenkins.management.Messages.PluginsLink_updatesAvailable(size));
            } else {
                tooltip.append(jenkins.management.Messages.PluginsLink_updateAvailable());
            }
            switch (incompatibleSize) {
                case 0: {
                    break;
                }
                case 1: {
                    tooltip.append("\n").append(jenkins.management.Messages.PluginsLink_incompatibleUpdateAvailable());
                    break;
                }
                default: {
                    tooltip.append("\n").append(jenkins.management.Messages.PluginsLink_incompatibleUpdatesAvailable(incompatibleSize));
                }
            }
            switch (securityFixSize) {
                case 0: {
                    break;
                }
                case 1: {
                    tooltip.append("\n").append(jenkins.management.Messages.PluginsLink_securityUpdateAvailable());
                    severity = Badge.Severity.DANGER;
                    break;
                }
                default: {
                    tooltip.append("\n").append(jenkins.management.Messages.PluginsLink_securityUpdatesAvailable(securityFixSize));
                    severity = Badge.Severity.DANGER;
                }
            }
            return new Badge(Integer.toString(size), tooltip.toString(), severity);
        }
        return null;
    }

    @Restricted(value={DoNotUse.class})
    public HttpResponse doConnectionStatus(StaplerRequest2 request) {
        if (Util.isOverridden(UpdateCenter.class, this.getClass(), "doConnectionStatus", StaplerRequest.class)) {
            return this.doConnectionStatus(StaplerRequest.fromStaplerRequest2((StaplerRequest2)request));
        }
        return this.doConnectionStatusImpl(request);
    }

    @Deprecated
    @StaplerNotDispatchable
    @Restricted(value={DoNotUse.class})
    public HttpResponse doConnectionStatus(StaplerRequest request) {
        return this.doConnectionStatusImpl(StaplerRequest.toStaplerRequest2((StaplerRequest)request));
    }

    private HttpResponse doConnectionStatusImpl(StaplerRequest2 request) {
        Jenkins.get().checkPermission(Jenkins.SYSTEM_READ);
        try {
            UpdateSite site;
            String siteId = request.getParameter("siteId");
            if (siteId == null) {
                siteId = ID_DEFAULT;
            } else if (siteId.equals(PREDEFINED_UPDATE_SITE_ID)) {
                siteId = ID_DEFAULT;
            }
            ConnectionCheckJob checkJob = this.getConnectionCheckJob(siteId);
            if (checkJob == null && (site = this.getSite(siteId)) != null) {
                checkJob = this.addConnectionCheckJob(site);
            }
            if (checkJob != null) {
                boolean isOffline = false;
                for (ConnectionStatus status : checkJob.connectionStates.values()) {
                    if (!ConnectionStatus.FAILED.equals((Object)status)) continue;
                    isOffline = true;
                    break;
                }
                if (isOffline) {
                    checkJob.run();
                    isOffline = false;
                    for (ConnectionStatus status : checkJob.connectionStates.values()) {
                        if (!ConnectionStatus.FAILED.equals((Object)status)) continue;
                        isOffline = true;
                        break;
                    }
                    if (!isOffline) {
                        this.updateAllSites();
                    }
                }
                return HttpResponses.okJSON(checkJob.connectionStates);
            }
            return HttpResponses.errorJSON(String.format("Cannot check connection status of the update site with ID='%s'. This update center cannot be resolved", siteId));
        }
        catch (Exception e) {
            return HttpResponses.errorJSON(String.format("ERROR: %s", e.getMessage()));
        }
    }

    @Restricted(value={DoNotUse.class})
    public HttpResponse doIncompleteInstallStatus() {
        try {
            Map<String, String> jobs = InstallUtil.getPersistedInstallStatus();
            if (jobs == null) {
                jobs = Collections.emptyMap();
            }
            return HttpResponses.okJSON(jobs);
        }
        catch (RuntimeException e) {
            return HttpResponses.errorJSON(String.format("ERROR: %s", e.getMessage()));
        }
    }

    @Restricted(value={NoExternalUse.class})
    public synchronized void persistInstallStatus() {
        List<UpdateCenterJob> jobs = this.getJobs();
        boolean activeInstalls = false;
        for (UpdateCenterJob job : jobs) {
            if (!(job instanceof InstallationJob)) continue;
            InstallationJob installationJob = (InstallationJob)job;
            if (installationJob.status.isSuccess()) continue;
            activeInstalls = true;
        }
        if (activeInstalls) {
            InstallUtil.persistInstallStatus(jobs);
        } else {
            InstallUtil.clearInstallStatus();
        }
    }

    @Restricted(value={DoNotUse.class})
    public HttpResponse doInstallStatus(StaplerRequest2 request) {
        try {
            String correlationId = request.getParameter("correlationId");
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("state", Jenkins.get().getInstallState().name());
            ArrayList installStates = new ArrayList();
            response.put("jobs", installStates);
            List<UpdateCenterJob> jobCopy = this.getJobs();
            for (UpdateCenterJob job : jobCopy) {
                if (!(job instanceof InstallationJob)) continue;
                UUID jobCorrelationId = job.getCorrelationId();
                if (correlationId != null && (jobCorrelationId == null || !correlationId.equals(jobCorrelationId.toString()))) continue;
                InstallationJob installationJob = (InstallationJob)job;
                LinkedHashMap<String, String> pluginInfo = new LinkedHashMap<String, String>();
                pluginInfo.put("name", installationJob.plugin.name);
                pluginInfo.put("version", installationJob.plugin.version);
                pluginInfo.put("title", installationJob.plugin.title);
                pluginInfo.put("installStatus", installationJob.status.getType());
                pluginInfo.put("requiresRestart", Boolean.toString(installationJob.status.requiresRestart()));
                if (jobCorrelationId != null) {
                    pluginInfo.put("correlationId", jobCorrelationId.toString());
                }
                installStates.add(pluginInfo);
            }
            return HttpResponses.okJSON(JSONObject.fromObject(response));
        }
        catch (RuntimeException e) {
            return HttpResponses.errorJSON(String.format("ERROR: %s", e.getMessage()));
        }
    }

    public HudsonUpgradeJob getHudsonJob() {
        List<UpdateCenterJob> jobList = this.getJobs();
        Collections.reverse(jobList);
        for (UpdateCenterJob job : jobList) {
            if (!(job instanceof HudsonUpgradeJob)) continue;
            return (HudsonUpgradeJob)job;
        }
        return null;
    }

    @StaplerDispatchable
    public PersistedList<UpdateSite> getSites() {
        return this.sites;
    }

    @Restricted(value={NoExternalUse.class})
    public boolean isSiteDataReady() {
        if (this.sites.stream().anyMatch(UpdateSite::hasUnparsedData)) {
            if (!this.siteDataLoading) {
                this.siteDataLoading = true;
                Timer.get().submit(() -> {
                    this.sites.forEach(UpdateSite::getData);
                    this.siteDataLoading = false;
                });
            }
            return false;
        }
        return true;
    }

    @Exported(name="sites")
    public List<UpdateSite> getSiteList() {
        return this.sites.toList();
    }

    @CheckForNull
    public UpdateSite getSite(String id) {
        return this.getById(id);
    }

    public String getLastUpdatedString() {
        long newestTs = 0L;
        for (UpdateSite s : this.sites) {
            if (s.getDataTimestamp() <= newestTs) continue;
            newestTs = s.getDataTimestamp();
        }
        if (newestTs == 0L) {
            return Messages.UpdateCenter_n_a();
        }
        return Util.getTimeSpanString(System.currentTimeMillis() - newestTs);
    }

    @CheckForNull
    public UpdateSite getById(String id) {
        for (UpdateSite s : this.sites) {
            if (!s.getId().equals(id)) continue;
            return s;
        }
        return null;
    }

    @CheckForNull
    public UpdateSite getCoreSource() {
        for (UpdateSite s : this.sites) {
            UpdateSite.Data data = s.getData();
            if (data == null || data.core == null) continue;
            return s;
        }
        return null;
    }

    @Deprecated
    public String getDefaultBaseUrl() {
        return this.config.getUpdateCenterUrl();
    }

    @CheckForNull
    public UpdateSite.Plugin getPlugin(String artifactId) {
        for (UpdateSite s : this.sites) {
            UpdateSite.Plugin p = s.getPlugin(artifactId);
            if (p == null) continue;
            return p;
        }
        return null;
    }

    @CheckForNull
    public UpdateSite.Plugin getPlugin(String artifactId, @CheckForNull VersionNumber minVersion) {
        if (minVersion == null) {
            return this.getPlugin(artifactId);
        }
        for (UpdateSite s : this.sites) {
            UpdateSite.Plugin p = s.getPlugin(artifactId);
            if (!this.checkMinVersion(p, minVersion)) continue;
            return p;
        }
        return null;
    }

    @Restricted(value={NoExternalUse.class})
    @NonNull
    public List<UpdateSite.Plugin> getPluginFromAllSites(String artifactId, @CheckForNull VersionNumber minVersion) {
        ArrayList<UpdateSite.Plugin> result = new ArrayList<UpdateSite.Plugin>();
        for (UpdateSite s : this.sites) {
            UpdateSite.Plugin p = s.getPlugin(artifactId);
            if (!this.checkMinVersion(p, minVersion)) continue;
            result.add(p);
        }
        return result;
    }

    private boolean checkMinVersion(@CheckForNull UpdateSite.Plugin p, @CheckForNull VersionNumber minVersion) {
        return p != null && (minVersion == null || !minVersion.isNewerThan(new VersionNumber(p.version)));
    }

    @RequirePOST
    public void doUpgrade(StaplerResponse2 rsp) throws IOException, ServletException {
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        HudsonUpgradeJob job = new HudsonUpgradeJob(this.getCoreSource(), Jenkins.getAuthentication2());
        if (!Lifecycle.get().canRewriteHudsonWar()) {
            this.sendError("Jenkins upgrade not supported in this running mode");
            return;
        }
        LOGGER.info("Scheduling the core upgrade");
        this.addJob(job);
        rsp.sendRedirect2(".");
    }

    @RequirePOST
    public HttpResponse doInvalidateData() {
        for (UpdateSite site : this.sites) {
            site.doInvalidateData();
        }
        return HttpResponses.ok();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequirePOST
    public void doSafeRestart(StaplerRequest2 request, StaplerResponse2 response) throws IOException, ServletException {
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        Vector<UpdateCenterJob> vector = this.jobs;
        synchronized (vector) {
            if (!this.isRestartScheduled()) {
                this.addJob(new RestartJenkinsJob(this.getCoreSource()));
                LOGGER.info("Scheduling Jenkins reboot");
            }
        }
        response.sendRedirect2(".");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequirePOST
    public void doCancelRestart(StaplerResponse2 response) throws IOException, ServletException {
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        Vector<UpdateCenterJob> vector = this.jobs;
        synchronized (vector) {
            for (UpdateCenterJob job : this.jobs) {
                if (!(job instanceof RestartJenkinsJob) || !((RestartJenkinsJob)job).cancel()) continue;
                LOGGER.info("Scheduled Jenkins reboot unscheduled");
            }
        }
        response.sendRedirect2(".");
    }

    @Exported
    public boolean isRestartRequiredForCompletion() {
        return this.requiresRestart;
    }

    public boolean isRestartScheduled() {
        for (UpdateCenterJob job : this.getJobs()) {
            RestartJenkinsJob.RestartJenkinsJobStatus status;
            if (!(job instanceof RestartJenkinsJob) || !((status = ((RestartJenkinsJob)job).status) instanceof RestartJenkinsJob.Pending) && !(status instanceof RestartJenkinsJob.Running)) continue;
            return true;
        }
        return false;
    }

    public boolean isDowngradable() {
        return new File(Lifecycle.get().getHudsonWar() + ".bak").exists();
    }

    @RequirePOST
    public void doDowngrade(StaplerResponse2 rsp) throws IOException, ServletException {
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        if (!this.isDowngradable()) {
            this.sendError("Jenkins downgrade is not possible, probably backup does not exist");
            return;
        }
        HudsonDowngradeJob job = new HudsonDowngradeJob(this.getCoreSource(), Jenkins.getAuthentication2());
        LOGGER.info("Scheduling the core downgrade");
        this.addJob(job);
        rsp.sendRedirect2(".");
    }

    @RequirePOST
    public void doRestart(StaplerResponse2 rsp) throws IOException, ServletException {
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        HudsonDowngradeJob job = new HudsonDowngradeJob(this.getCoreSource(), Jenkins.getAuthentication2());
        LOGGER.info("Scheduling the core downgrade");
        this.addJob(job);
        rsp.sendRedirect2(".");
    }

    public String getBackupVersion() {
        String string;
        JarFile backupWar = new JarFile(new File(Lifecycle.get().getHudsonWar() + ".bak"));
        try {
            Attributes attrs = backupWar.getManifest().getMainAttributes();
            String v = attrs.getValue("Jenkins-Version");
            if (v == null) {
                v = attrs.getValue("Hudson-Version");
            }
            string = v;
        }
        catch (Throwable throwable) {
            try {
                try {
                    backupWar.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Failed to read backup version ", e);
                return null;
            }
        }
        backupWar.close();
        return string;
    }

    @Restricted(value={NoExternalUse.class})
    public synchronized Future<UpdateCenterJob> addJob(UpdateCenterJob job) {
        if (job.site != null) {
            this.addConnectionCheckJob(job.site);
        }
        return job.submit();
    }

    @NonNull
    private ConnectionCheckJob addConnectionCheckJob(@NonNull UpdateSite site) {
        if (this.sourcesUsed.add(site)) {
            ConnectionCheckJob connectionCheckJob = this.newConnectionCheckJob(site);
            connectionCheckJob.submit();
            return connectionCheckJob;
        }
        ConnectionCheckJob connectionCheckJob = this.getConnectionCheckJob(site);
        if (connectionCheckJob != null) {
            return connectionCheckJob;
        }
        throw new IllegalStateException("Illegal addition of an UpdateCenter job without calling UpdateCenter.addJob. No ConnectionCheckJob found for the site.");
    }

    @Restricted(value={NoExternalUse.class})
    ConnectionCheckJob newConnectionCheckJob(UpdateSite site) {
        return new ConnectionCheckJob(site);
    }

    @CheckForNull
    private ConnectionCheckJob getConnectionCheckJob(@NonNull String siteId) {
        UpdateSite site = this.getSite(siteId);
        if (site == null) {
            return null;
        }
        return this.getConnectionCheckJob(site);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CheckForNull
    private ConnectionCheckJob getConnectionCheckJob(@NonNull UpdateSite site) {
        Vector<UpdateCenterJob> vector = this.jobs;
        synchronized (vector) {
            for (UpdateCenterJob job : this.jobs) {
                if (!(job instanceof ConnectionCheckJob) || job.site == null || !job.site.getId().equals(site.getId())) continue;
                return (ConnectionCheckJob)job;
            }
        }
        return null;
    }

    @Override
    public String getDisplayName() {
        return Messages.UpdateCenter_DisplayName();
    }

    @Override
    public String getSearchUrl() {
        return "updateCenter";
    }

    @Override
    public synchronized void save() {
        if (BulkChange.contains(this)) {
            return;
        }
        try {
            this.getConfigFile().write(this.sites);
            SaveableListener.fireOnChange(this, this.getConfigFile());
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Failed to save " + this.getConfigFile(), e);
        }
    }

    @Override
    public synchronized void load() throws IOException {
        XmlFile file = this.getConfigFile();
        if (file.exists()) {
            try {
                this.sites.replaceBy(((PersistedList)file.unmarshal(this.sites)).toList());
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Failed to load " + file, e);
            }
            boolean defaultSiteExists = false;
            for (UpdateSite site : this.sites) {
                if (site.isLegacyDefault()) {
                    this.sites.remove(site);
                    continue;
                }
                if (!ID_DEFAULT.equals(site.getId())) continue;
                defaultSiteExists = true;
            }
            if (!defaultSiteExists) {
                this.sites.add(this.createDefaultUpdateSite());
            }
        } else if (this.sites.isEmpty()) {
            this.sites.add(this.createDefaultUpdateSite());
        }
        this.siteDataLoading = false;
    }

    protected UpdateSite createDefaultUpdateSite() {
        return new UpdateSite(PREDEFINED_UPDATE_SITE_ID, this.config.getUpdateCenterUrl() + "update-center.json");
    }

    private XmlFile getConfigFile() {
        return new XmlFile(XSTREAM, new File(Jenkins.get().root, UpdateCenter.class.getName() + ".xml"));
    }

    @Exported
    public List<UpdateSite.Plugin> getAvailables() {
        LinkedHashMap<Object, UpdateSite.Plugin> pluginMap = new LinkedHashMap<Object, UpdateSite.Plugin>();
        for (UpdateSite site : this.sites) {
            for (UpdateSite.Plugin plugin : site.getAvailables()) {
                String altKey;
                UpdateSite.Plugin existing = (UpdateSite.Plugin)pluginMap.get(plugin.name);
                if (existing == null) {
                    pluginMap.put(plugin.name, plugin);
                    continue;
                }
                if (existing.version.equals(plugin.version) || pluginMap.containsKey(altKey = plugin.name + ":" + plugin.version)) continue;
                pluginMap.put(altKey, plugin);
            }
        }
        return new ArrayList<UpdateSite.Plugin>(pluginMap.values());
    }

    @Deprecated
    public PluginEntry[] getCategorizedAvailables() {
        TreeSet<PluginEntry> entries = new TreeSet<PluginEntry>();
        for (UpdateSite.Plugin p : this.getAvailables()) {
            if (p.categories == null || p.categories.length == 0) {
                entries.add(new PluginEntry(p, UpdateCenter.getCategoryDisplayName(null)));
                continue;
            }
            for (String c : p.categories) {
                entries.add(new PluginEntry(p, UpdateCenter.getCategoryDisplayName(c)));
            }
        }
        return entries.toArray(new PluginEntry[0]);
    }

    @Restricted(value={NoExternalUse.class})
    public static String getCategoryDisplayName(String category) {
        if (category == null) {
            return Messages.UpdateCenter_PluginCategory_misc();
        }
        try {
            return (String)Messages.class.getMethod("UpdateCenter_PluginCategory_" + category.replace('-', '_'), new Class[0]).invoke(null, new Object[0]);
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            return category;
        }
    }

    public List<UpdateSite.Plugin> getUpdates() {
        LinkedHashMap<Object, UpdateSite.Plugin> pluginMap = new LinkedHashMap<Object, UpdateSite.Plugin>();
        LinkedHashMap<String, Set> incompatiblePluginMap = new LinkedHashMap<String, Set>();
        PluginManager.MetadataCache cache = new PluginManager.MetadataCache();
        for (UpdateSite site : this.sites) {
            for (UpdateSite.Plugin plugin : site.getUpdates()) {
                String altKey;
                UpdateSite.Plugin existing = (UpdateSite.Plugin)pluginMap.get(plugin.name);
                if (existing == null) {
                    pluginMap.put(plugin.name, plugin);
                    if (plugin.isNeededDependenciesCompatibleWithInstalledVersion()) continue;
                    for (UpdateSite.Plugin incompatiblePlugin : plugin.getDependenciesIncompatibleWithInstalledVersion(cache)) {
                        incompatiblePluginMap.computeIfAbsent(incompatiblePlugin.name, _ignored -> new HashSet()).add(plugin);
                    }
                    continue;
                }
                if (existing.version.equals(plugin.version) || pluginMap.containsKey(altKey = plugin.name + ":" + plugin.version)) continue;
                pluginMap.put(altKey, plugin);
            }
        }
        incompatiblePluginMap.forEach((key, incompatiblePlugins) -> pluginMap.computeIfPresent(key, (_ignored, plugin) -> {
            plugin.setIncompatibleParentPlugins((Set<UpdateSite.Plugin>)incompatiblePlugins);
            return plugin;
        }));
        return new ArrayList<UpdateSite.Plugin>(pluginMap.values());
    }

    @Restricted(value={NoExternalUse.class})
    public boolean hasIncompatibleUpdates(PluginManager.MetadataCache cache) {
        return this.getUpdates().stream().anyMatch(plugin -> !plugin.isCompatible(cache));
    }

    public List<FormValidation> updateAllSites() throws InterruptedException, ExecutionException {
        ArrayList<Future<FormValidation>> futures = new ArrayList<Future<FormValidation>>();
        for (UpdateSite site : this.getSites()) {
            Future<FormValidation> future = site.updateDirectly();
            if (future == null) continue;
            futures.add(future);
        }
        ArrayList<FormValidation> results = new ArrayList<FormValidation>();
        for (Future future : futures) {
            results.add((FormValidation)future.get());
        }
        return results;
    }

    private static VerificationResult verifyChecksums(String expectedDigest, String actualDigest, boolean caseSensitive) {
        if (expectedDigest == null) {
            return VerificationResult.NOT_PROVIDED;
        }
        if (actualDigest == null) {
            return VerificationResult.NOT_COMPUTED;
        }
        if (caseSensitive ? MessageDigest.isEqual(expectedDigest.getBytes(StandardCharsets.US_ASCII), actualDigest.getBytes(StandardCharsets.US_ASCII)) : MessageDigest.isEqual(expectedDigest.toLowerCase().getBytes(StandardCharsets.US_ASCII), actualDigest.toLowerCase().getBytes(StandardCharsets.US_ASCII))) {
            return VerificationResult.PASS;
        }
        return VerificationResult.FAIL;
    }

    private static void throwVerificationFailure(String expected, String actual, File file, String algorithm) throws IOException {
        throw new IOException("Downloaded file " + file.getAbsolutePath() + " does not match expected " + algorithm + ", expected '" + expected + "', actual '" + actual + "'");
    }

    @Restricted(value={NoExternalUse.class})
    @VisibleForTesting
    static void verifyChecksums(WithComputedChecksums job, UpdateSite.Entry entry, File file) throws IOException {
        VerificationResult result512 = UpdateCenter.verifyChecksums(entry.getSha512(), job.getComputedSHA512(), false);
        switch (result512) {
            case PASS: {
                return;
            }
            case FAIL: {
                UpdateCenter.throwVerificationFailure(entry.getSha512(), job.getComputedSHA512(), file, "SHA-512");
                break;
            }
            case NOT_COMPUTED: {
                LOGGER.log(Level.WARNING, "Attempt to verify a downloaded file (" + file.getName() + ") using SHA-512 failed since it could not be computed. Falling back to weaker algorithms. Update your JRE.");
                break;
            }
            case NOT_PROVIDED: {
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + result512);
            }
        }
        VerificationResult result256 = UpdateCenter.verifyChecksums(entry.getSha256(), job.getComputedSHA256(), false);
        switch (result256) {
            case PASS: {
                return;
            }
            case FAIL: {
                UpdateCenter.throwVerificationFailure(entry.getSha256(), job.getComputedSHA256(), file, "SHA-256");
                break;
            }
            case NOT_COMPUTED: 
            case NOT_PROVIDED: {
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + result256);
            }
        }
        if (result512 == VerificationResult.NOT_PROVIDED && result256 == VerificationResult.NOT_PROVIDED) {
            LOGGER.log(Level.INFO, "Attempt to verify a downloaded file (" + file.getName() + ") using SHA-512 or SHA-256 failed since your configured update site does not provide either of those checksums. Falling back to SHA-1.");
        }
        VerificationResult result1 = UpdateCenter.verifyChecksums(entry.getSha1(), job.getComputedSHA1(), true);
        switch (result1) {
            case PASS: {
                return;
            }
            case FAIL: {
                UpdateCenter.throwVerificationFailure(entry.getSha1(), job.getComputedSHA1(), file, "SHA-1");
                break;
            }
            case NOT_COMPUTED: {
                throw new IOException("Failed to compute SHA-1 of downloaded file, refusing installation");
            }
            case NOT_PROVIDED: {
                throw new IOException("Unable to confirm integrity of downloaded file, refusing installation");
            }
            default: {
                throw new AssertionError((Object)("Unknown verification result: " + result1));
            }
        }
    }

    @Initializer(after=InitMilestone.PLUGINS_STARTED, fatal=false)
    public static void init(Jenkins h) throws IOException {
        h.getUpdateCenter().load();
    }

    @Restricted(value={NoExternalUse.class})
    public static void updateAllSitesNow() {
        for (UpdateSite site : Jenkins.get().getUpdateCenter().getSites()) {
            try {
                site.updateDirectlyNow();
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, MessageFormat.format("Failed to update the update site ''{0}''. Plugin upgrades may fail.", site.getId()), e);
            }
        }
    }

    @Restricted(value={NoExternalUse.class})
    public static void updateDefaultSite() {
        UpdateSite site = Jenkins.get().getUpdateCenter().getSite(ID_DEFAULT);
        if (site == null) {
            LOGGER.log(Level.SEVERE, "Upgrading Jenkins. Cannot retrieve the default Update Site ''{0}''. Plugin installation may fail.", ID_DEFAULT);
            return;
        }
        try {
            site.updateDirectlyNow();
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Upgrading Jenkins. Failed to update the default Update Site '" + ID_DEFAULT + "'. Plugin upgrades may fail.", e);
        }
    }

    @Restricted(value={NoExternalUse.class})
    public Object getTarget() {
        if (!SKIP_PERMISSION_CHECK) {
            Jenkins.get().checkPermission(Jenkins.SYSTEM_READ);
        }
        return this;
    }

    private static void moveAtomically(File src, File target) throws IOException {
        try {
            Files.move(Util.fileToPath(src), Util.fileToPath(target), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
        }
        catch (AtomicMoveNotSupportedException e) {
            LOGGER.log(Level.WARNING, "Atomic move not supported. Falling back to non-atomic move.", e);
            try {
                Files.move(Util.fileToPath(src), Util.fileToPath(target), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e2) {
                e2.addSuppressed(e);
                throw e2;
            }
        }
    }

    static {
        Logger logger;
        PLUGIN_DOWNLOAD_READ_TIMEOUT = (int)TimeUnit.SECONDS.toMillis(SystemProperties.getInteger(UpdateCenter.class.getName() + ".pluginDownloadReadTimeoutSeconds", 60).intValue());
        ID_DEFAULT = SystemProperties.getString(UpdateCenter.class.getName() + ".defaultUpdateSiteId", PREDEFINED_UPDATE_SITE_ID);
        LOGGER = logger = Logger.getLogger(UpdateCenter.class.getName());
        String ucOverride = SystemProperties.getString(UpdateCenter.class.getName() + ".updateCenterUrl");
        if (ucOverride != null) {
            logger.log(Level.INFO, "Using a custom update center defined by the system property: {0}", ucOverride);
            UPDATE_CENTER_URL = ucOverride;
        } else {
            UPDATE_CENTER_URL = "https://updates.jenkins.io/";
        }
        SKIP_PERMISSION_CHECK = SystemProperties.getBoolean(UpdateCenter.class.getName() + ".skipPermissionCheck");
        iota = new AtomicInteger();
        neverUpdate = SystemProperties.getBoolean(UpdateCenter.class.getName() + ".never");
        XSTREAM = new XStream2();
        XSTREAM.alias("site", UpdateSite.class);
        XSTREAM.alias("sites", PersistedList.class);
    }

    public static class UpdateCenterConfiguration
    implements ExtensionPoint {
        public void checkConnection(ConnectionCheckJob job, String connectionCheckUrl) throws IOException {
            this.testConnection(new URL(connectionCheckUrl));
        }

        public void checkUpdateCenter(ConnectionCheckJob job, String updateCenterUrl) throws IOException {
            this.testConnection(UpdateCenterConfiguration.toUpdateCenterCheckUrl(updateCenterUrl));
        }

        static URL toUpdateCenterCheckUrl(String updateCenterUrl) throws MalformedURLException {
            URL url = updateCenterUrl.startsWith("http://") || updateCenterUrl.startsWith("https://") ? new URL(updateCenterUrl + (updateCenterUrl.indexOf(63) == -1 ? "?uctest" : "&uctest")) : new URL(updateCenterUrl);
            return url;
        }

        public void preValidate(DownloadJob job, URL src) throws IOException {
        }

        public void postValidate(DownloadJob job, File src) throws IOException {
        }

        @SuppressFBWarnings(value={"WEAK_MESSAGE_DIGEST_SHA1"}, justification="SHA-1 is only used as a fallback if SHA-256/SHA-512 are not available")
        public File download(DownloadJob job, URL src) throws IOException {
            MessageDigest sha1 = null;
            MessageDigest sha256 = null;
            MessageDigest sha512 = null;
            try {
                sha1 = MessageDigest.getInstance("SHA-1");
                sha256 = MessageDigest.getInstance("SHA-256");
                sha512 = MessageDigest.getInstance("SHA-512");
            }
            catch (NoSuchAlgorithmException nsa) {
                LOGGER.log(Level.WARNING, "Failed to instantiate message digest algorithm, may only have weak or no verification of downloaded file", nsa);
            }
            URLConnection con = null;
            try {
                byte[] digest;
                con = this.connect(job, src);
                con.setReadTimeout(PLUGIN_DOWNLOAD_READ_TIMEOUT);
                long sizeFromMetadata = job.getContentLength();
                long total = sizeFromMetadata == -1L ? (long)con.getContentLength() : sizeFromMetadata;
                byte[] buf = new byte[8192];
                File dst = job.getDestination();
                File tmp = new File(dst.getPath() + ".tmp");
                LOGGER.info("Downloading " + job.getName());
                Thread t = Thread.currentThread();
                String oldName = t.getName();
                t.setName(oldName + ": " + src);
                try (OutputStream _out = Files.newOutputStream(tmp.toPath(), new OpenOption[0]);
                     OutputStream out = sha1 != null ? new DigestOutputStream(sha256 != null ? new DigestOutputStream(sha512 != null ? new DigestOutputStream(_out, sha512) : _out, sha256) : _out, sha1) : _out;
                     InputStream in = con.getInputStream();
                     CountingInputStream cin = new CountingInputStream(in);){
                    int len;
                    if (LOGGER.isLoggable(Level.FINE)) {
                        String sourceUrlString = UpdateCenterConfiguration.getSourceUrl(src, con);
                        LOGGER.fine(() -> "Downloading " + job.getName() + " from " + sourceUrlString);
                    }
                    while ((len = cin.read(buf)) >= 0) {
                        out.write(buf, 0, len);
                        int count = cin.getCount();
                        DownloadJob downloadJob = job;
                        Objects.requireNonNull(downloadJob);
                        job.status = downloadJob.new DownloadJob.Installing(total == -1L ? -1 : (int)((long)(count * 100) / total));
                        if (total == -1L || total >= (long)count) continue;
                        throw new IOException("Received more data than expected. Expected " + total + " bytes but got " + count + " bytes (so far), aborting download.");
                    }
                }
                catch (IOException | InvalidPathException e) {
                    throw new IOException("Failed to load " + src + " to " + tmp, e);
                }
                finally {
                    t.setName(oldName);
                }
                if (total != -1L && total != tmp.length()) {
                    throw new IOException("Inconsistent file length: expected " + total + " but only got " + tmp.length());
                }
                if (sha1 != null) {
                    digest = sha1.digest();
                    job.computedSHA1 = Base64.getEncoder().encodeToString(digest);
                }
                if (sha256 != null) {
                    digest = sha256.digest();
                    job.computedSHA256 = Base64.getEncoder().encodeToString(digest);
                }
                if (sha512 != null) {
                    digest = sha512.digest();
                    job.computedSHA512 = Base64.getEncoder().encodeToString(digest);
                }
                return tmp;
            }
            catch (IOException e) {
                throw new IOException("Failed to download from " + UpdateCenterConfiguration.getSourceUrl(src, con), e);
            }
        }

        private static String getSourceUrl(@NonNull URL src, @CheckForNull URLConnection connection) {
            String finalUrlString;
            URL connectionURL;
            String sourceUrlString = src.toExternalForm();
            if (connection != null && (connectionURL = connection.getURL()) != null && !sourceUrlString.equals(finalUrlString = connectionURL.toExternalForm())) {
                return sourceUrlString + " \u2192 " + finalUrlString;
            }
            return sourceUrlString;
        }

        protected URLConnection connect(DownloadJob job, URL src) throws IOException {
            return ProxyConfiguration.open(src);
        }

        public void install(DownloadJob job, File src, File dst) throws IOException {
            job.replace(dst, src);
        }

        public void upgrade(DownloadJob job, File src, File dst) throws IOException {
            job.replace(dst, src);
        }

        @Deprecated
        public String getConnectionCheckUrl() {
            return "http://www.google.com";
        }

        @Deprecated
        public String getUpdateCenterUrl() {
            return UPDATE_CENTER_URL;
        }

        @Deprecated
        public String getPluginRepositoryBaseUrl() {
            return "http://jenkins-ci.org/";
        }

        private void testConnection(URL url) throws IOException {
            block16: {
                try {
                    URLConnection connection = ProxyConfiguration.open(url);
                    if (connection instanceof HttpURLConnection) {
                        int responseCode = ((HttpURLConnection)connection).getResponseCode();
                        if (200 != responseCode) {
                            throw new HttpRetryException("Invalid response code (" + responseCode + ") from URL: " + url, responseCode);
                        }
                        break block16;
                    }
                    try (InputStream is = connection.getInputStream();
                         OutputStream os = OutputStream.nullOutputStream();){
                        IOUtils.copy((InputStream)is, (OutputStream)os);
                    }
                }
                catch (SSLHandshakeException e) {
                    if (!e.getMessage().contains("PKIX path building failed")) break block16;
                    throw new IOException("Failed to validate the SSL certificate of " + url, e);
                }
            }
        }
    }

    @ExportedBean
    public abstract class UpdateCenterJob
    implements Runnable {
        @Exported
        public final int id = iota.incrementAndGet();
        @CheckForNull
        public final UpdateSite site;
        private UUID correlationId = null;
        protected Throwable error;

        protected UpdateCenterJob(UpdateSite site) {
            this.site = site;
        }

        public Api getApi() {
            return new Api(this);
        }

        public UUID getCorrelationId() {
            return this.correlationId;
        }

        public void setCorrelationId(UUID correlationId) {
            if (this.correlationId != null) {
                throw new IllegalStateException("Illegal call to set the 'correlationId'. Already set.");
            }
            this.correlationId = correlationId;
        }

        @Deprecated
        public void schedule() {
            this.submit();
        }

        @Exported
        public String getType() {
            return this.getClass().getSimpleName();
        }

        public Future<UpdateCenterJob> submit() {
            LOGGER.fine("Scheduling " + this + " to installerService");
            UpdateCenter.this.jobs.add(this);
            return UpdateCenter.this.installerService.submit(this, this);
        }

        @Exported
        public String getErrorMessage() {
            return this.error != null ? this.error.getMessage() : null;
        }

        public Throwable getError() {
            return this.error;
        }
    }

    public class InstallationJob
    extends DownloadJob {
        @Exported
        public final UpdateSite.Plugin plugin;
        protected final PluginManager pm;
        protected final boolean dynamicLoad;
        @CheckForNull
        List<PluginWrapper> batch;

        @Deprecated
        public InstallationJob(UpdateSite.Plugin plugin, UpdateSite site, org.springframework.security.core.Authentication auth) {
            this(plugin, site, auth, false);
        }

        @Deprecated
        public InstallationJob(UpdateSite.Plugin plugin, UpdateSite site, Authentication auth, boolean dynamicLoad) {
            this(plugin, site, auth.toSpring(), dynamicLoad);
        }

        public InstallationJob(UpdateSite.Plugin plugin, UpdateSite site, org.springframework.security.core.Authentication auth, boolean dynamicLoad) {
            super(site, auth);
            this.pm = Jenkins.get().getPluginManager();
            this.plugin = plugin;
            this.dynamicLoad = dynamicLoad;
        }

        @Override
        protected URL getURL() throws MalformedURLException {
            return new URL(this.plugin.url);
        }

        @Override
        protected File getDestination() {
            File baseDir = this.pm.rootDir;
            return new File(baseDir, this.plugin.name + ".jpi");
        }

        private File getLegacyDestination() {
            File baseDir = this.pm.rootDir;
            return new File(baseDir, this.plugin.name + ".hpi");
        }

        @Override
        public String getName() {
            return this.plugin.name;
        }

        @Override
        public String getDisplayName() {
            return this.plugin.getDisplayName();
        }

        @Override
        public long getContentLength() {
            Long size = this.plugin.getFileSize();
            return size == null ? -1L : size;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void _run() throws IOException, DownloadJob.InstallationStatus {
            block24: {
                if (this.wasInstalled()) {
                    LOGGER.info("Skipping duplicate install of: " + this.plugin.getDisplayName() + "@" + this.plugin.version);
                    return;
                }
                try {
                    File cached = this.getCached(this);
                    if (cached != null) {
                        File dst = this.getDestination();
                        File tmp = new File(dst.getPath() + ".tmp");
                        Files.copy(cached.toPath(), tmp.toPath(), StandardCopyOption.REPLACE_EXISTING);
                        UpdateCenter.this.config.postValidate(this, tmp);
                        UpdateCenter.this.config.install(this, tmp, dst);
                    } else {
                        super._run();
                    }
                    PluginWrapper pw = this.plugin.getInstalled();
                    if (pw != null && pw.isBundled()) {
                        try (ACLContext ctx = ACL.as2(ACL.SYSTEM2);){
                            pw.doPin();
                        }
                    }
                    if (this.dynamicLoad) {
                        try {
                            this.pm.dynamicLoad(this.getDestination(), false, this.batch);
                            break block24;
                        }
                        catch (RestartRequiredException e) {
                            throw new DownloadJob.SuccessButRequiresRestart(e.message);
                        }
                        catch (Exception e) {
                            throw new IOException("Failed to dynamically deploy this plugin", e);
                        }
                    }
                    throw new DownloadJob.SuccessButRequiresRestart(Messages._UpdateCenter_DownloadButNotActivated());
                }
                finally {
                    InstallationJob installationJob = this;
                    synchronized (installationJob) {
                        LOGGER.fine("Install complete for: " + this.plugin.getDisplayName() + "@" + this.plugin.version);
                        this.status = new DownloadJob.Skipped();
                        this.notifyAll();
                    }
                }
            }
        }

        @CheckForNull
        private File getCached(DownloadJob job) {
            File cached;
            URL src;
            try {
                src = Jenkins.get().getServletContext().getResource(String.format("/WEB-INF/detached-plugins/%s.hpi", this.plugin.name));
            }
            catch (MalformedURLException e) {
                return null;
            }
            if (src == null || !"file".equals(src.getProtocol())) {
                return null;
            }
            try {
                UpdateCenter.this.config.preValidate(this, src);
            }
            catch (IOException e) {
                return null;
            }
            try {
                cached = new File(src.toURI());
            }
            catch (URISyntaxException e) {
                return null;
            }
            if (!cached.isFile()) {
                return null;
            }
            FileWithComputedChecksums withComputedChecksums = new FileWithComputedChecksums(cached);
            try {
                UpdateCenter.verifyChecksums(withComputedChecksums, this.plugin, cached);
            }
            catch (IOException | UncheckedIOException | UnsupportedOperationException e) {
                return null;
            }
            job.computedSHA1 = withComputedChecksums.getComputedSHA1();
            job.computedSHA256 = withComputedChecksums.getComputedSHA256();
            job.computedSHA512 = withComputedChecksums.getComputedSHA512();
            return cached;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean wasInstalled() {
            UpdateCenter updateCenter = UpdateCenter.this;
            synchronized (updateCenter) {
                for (UpdateCenterJob job : UpdateCenter.this.getJobs()) {
                    if (job == this) {
                        return false;
                    }
                    if (!(job instanceof InstallationJob)) continue;
                    InstallationJob ij = (InstallationJob)job;
                    if (!ij.plugin.equals(this.plugin) || !ij.plugin.version.equals(this.plugin.version)) continue;
                    InstallationJob installationJob = ij;
                    synchronized (installationJob) {
                        if (ij.status instanceof DownloadJob.Installing || ij.status instanceof DownloadJob.Pending) {
                            try {
                                LOGGER.fine("Waiting for other plugin install of: " + this.plugin.getDisplayName() + "@" + this.plugin.version);
                                ij.wait();
                            }
                            catch (InterruptedException e) {
                                throw new RuntimeException(e);
                            }
                        }
                        if (ij.status instanceof DownloadJob.Success) {
                            return true;
                        }
                    }
                }
                return false;
            }
        }

        @Override
        protected void onSuccess() {
            this.pm.pluginUploaded = true;
        }

        public String toString() {
            return super.toString() + "[plugin=" + this.plugin.title + "]";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void replace(File dst, File src) throws IOException {
            if (this.site == null || !this.site.getId().equals(UpdateCenter.ID_UPLOAD)) {
                UpdateCenter.verifyChecksums(this, this.plugin, src);
            }
            InstallationJob installationJob = this;
            synchronized (installationJob) {
                File bak = Util.changeExtension(dst, ".bak");
                File legacy = this.getLegacyDestination();
                if (Files.exists(Util.fileToPath(legacy), new LinkOption[0])) {
                    UpdateCenter.moveAtomically(legacy, bak);
                }
                if (Files.exists(Util.fileToPath(dst), new LinkOption[0])) {
                    UpdateCenter.moveAtomically(dst, bak);
                }
                UpdateCenter.moveAtomically(src, dst);
            }
        }

        void setBatch(List<PluginWrapper> batch) {
            this.batch = batch;
        }
    }

    public final class ConnectionCheckJob
    extends UpdateCenterJob {
        private final Vector<String> statuses;
        final Map<String, ConnectionStatus> connectionStates;

        public ConnectionCheckJob(UpdateSite site) {
            super(site);
            this.statuses = new Vector();
            this.connectionStates = new ConcurrentHashMap<String, ConnectionStatus>();
            this.connectionStates.put("internet", ConnectionStatus.PRECHECK);
            this.connectionStates.put("updatesite", ConnectionStatus.PRECHECK);
        }

        @Override
        public void run() {
            this.connectionStates.put("internet", ConnectionStatus.UNCHECKED);
            this.connectionStates.put("updatesite", ConnectionStatus.UNCHECKED);
            if (this.site == null || UpdateCenter.ID_UPLOAD.equals(this.site.getId())) {
                return;
            }
            LOGGER.fine("Doing a connectivity check");
            Future<?> internetCheck = null;
            try {
                final String connectionCheckUrl = this.site.getConnectionCheckUrl();
                if (connectionCheckUrl != null) {
                    this.connectionStates.put("internet", ConnectionStatus.CHECKING);
                    this.statuses.add(Messages.UpdateCenter_Status_CheckingInternet());
                    internetCheck = UpdateCenter.this.updateService.submit(new Runnable(){

                        @Override
                        public void run() {
                            block2: {
                                try {
                                    UpdateCenter.this.config.checkConnection(ConnectionCheckJob.this, connectionCheckUrl);
                                }
                                catch (Exception e) {
                                    if (!e.getMessage().contains("Connection timed out")) break block2;
                                    ConnectionCheckJob.this.connectionStates.put("internet", ConnectionStatus.FAILED);
                                    ConnectionCheckJob.this.statuses.add(Messages.UpdateCenter_Status_ConnectionFailed(Functions.xmlEscape(connectionCheckUrl), Jenkins.get().getRootUrl()));
                                    return;
                                }
                            }
                            ConnectionCheckJob.this.connectionStates.put("internet", ConnectionStatus.OK);
                        }
                    });
                } else {
                    LOGGER.log(Level.WARNING, "Update site ''{0}'' does not declare the connection check URL. Skipping the network availability check.", this.site.getId());
                    this.connectionStates.put("internet", ConnectionStatus.SKIPPED);
                }
                this.connectionStates.put("updatesite", ConnectionStatus.CHECKING);
                this.statuses.add(Messages.UpdateCenter_Status_CheckingJavaNet());
                UpdateCenter.this.config.checkUpdateCenter(this, this.site.getUrl());
                this.connectionStates.put("updatesite", ConnectionStatus.OK);
                this.statuses.add(Messages.UpdateCenter_Status_Success());
            }
            catch (UnknownHostException e) {
                this.connectionStates.put("updatesite", ConnectionStatus.FAILED);
                this.statuses.add(Messages.UpdateCenter_Status_UnknownHostException(Functions.xmlEscape(e.getMessage()), Jenkins.get().getRootUrl()));
                this.addStatus(e);
                this.error = e;
            }
            catch (Exception e) {
                this.connectionStates.put("updatesite", ConnectionStatus.FAILED);
                this.addStatus(e);
                this.error = e;
            }
            if (internetCheck != null) {
                try {
                    internetCheck.get();
                }
                catch (Exception e) {
                    LOGGER.log(Level.WARNING, "Error completing internet connectivity check: " + e.getMessage(), e);
                }
            }
        }

        private void addStatus(Throwable e) {
            this.statuses.add("<pre>" + Functions.xmlEscape(Functions.printThrowable(e)) + "</pre>");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String[] getStatuses() {
            Vector<String> vector = this.statuses;
            synchronized (vector) {
                return this.statuses.toArray(new String[0]);
            }
        }
    }

    @Restricted(value={NoExternalUse.class})
    static enum ConnectionStatus {
        PRECHECK,
        SKIPPED,
        CHECKING,
        UNCHECKED,
        OK,
        FAILED;

        static final String INTERNET = "internet";
        static final String UPDATE_SITE = "updatesite";
    }

    public abstract class DownloadJob
    extends UpdateCenterJob
    implements WithComputedChecksums {
        @Exported(inline=true)
        public volatile InstallationStatus status;
        private String computedSHA1;
        private String computedSHA256;
        private String computedSHA512;
        private org.springframework.security.core.Authentication authentication;

        protected abstract URL getURL() throws MalformedURLException;

        protected abstract File getDestination();

        @Exported
        public abstract String getName();

        public String getDisplayName() {
            return this.getName();
        }

        protected abstract void onSuccess();

        @Override
        @CheckForNull
        public String getComputedSHA1() {
            return this.computedSHA1;
        }

        @Override
        @CheckForNull
        public String getComputedSHA256() {
            return this.computedSHA256;
        }

        @Override
        @CheckForNull
        public String getComputedSHA512() {
            return this.computedSHA512;
        }

        public org.springframework.security.core.Authentication getUser() {
            return this.authentication;
        }

        protected DownloadJob(UpdateSite site, org.springframework.security.core.Authentication authentication) {
            super(site);
            this.status = new Pending();
            this.authentication = authentication;
        }

        @Override
        public void run() {
            try {
                LOGGER.info("Starting the installation of " + this.getName() + " on behalf of " + this.getUser().getName());
                this._run();
                LOGGER.info("Installation successful: " + this.getName());
                this.status = new Success();
                this.onSuccess();
            }
            catch (InstallationStatus e) {
                this.status = e;
                if (this.status.isSuccess()) {
                    this.onSuccess();
                }
                UpdateCenter.this.requiresRestart |= this.status.requiresRestart();
            }
            catch (MissingDependencyException e) {
                LOGGER.log(Level.SEVERE, "Failed to install {0}: {1}", new Object[]{this.getName(), e.getMessage()});
                this.status = new Failure((Throwable)e);
                this.error = e;
            }
            catch (Throwable e) {
                LOGGER.log(Level.SEVERE, "Failed to install " + this.getName(), e);
                this.status = new Failure(e);
                this.error = e;
            }
        }

        protected void _run() throws IOException, InstallationStatus {
            URL src = this.getURL();
            UpdateCenter.this.config.preValidate(this, src);
            File dst = this.getDestination();
            File tmp = UpdateCenter.this.config.download(this, src);
            UpdateCenter.this.config.postValidate(this, tmp);
            UpdateCenter.this.config.install(this, tmp, dst);
        }

        protected synchronized void replace(File dst, File src) throws IOException {
            File bak = Util.changeExtension(dst, ".bak");
            UpdateCenter.moveAtomically(dst, bak);
            UpdateCenter.moveAtomically(src, dst);
        }

        public long getContentLength() {
            return -1L;
        }

        public class Pending
        extends InstallationStatus {
        }

        @ExportedBean
        public abstract class InstallationStatus
        extends Throwable {
            public final int id = iota.incrementAndGet();

            @Exported
            public boolean isSuccess() {
                return false;
            }

            @Exported
            public final String getType() {
                return this.getClass().getSimpleName();
            }

            public boolean requiresRestart() {
                return false;
            }
        }

        public class Success
        extends InstallationStatus {
            @Override
            public boolean isSuccess() {
                return true;
            }
        }

        public class Failure
        extends InstallationStatus {
            public final Throwable problem;

            public Failure(Throwable problem) {
                this.problem = problem;
            }

            public String getProblemStackTrace() {
                return Functions.printThrowable(this.problem);
            }
        }

        public class Installing
        extends InstallationStatus {
            public final int percentage;

            public Installing(int percentage) {
                this.percentage = percentage;
            }
        }

        public class Skipped
        extends InstallationStatus {
            @Override
            public boolean isSuccess() {
                return true;
            }
        }

        public class SuccessButRequiresRestart
        extends Success {
            private final Localizable message;

            public SuccessButRequiresRestart(Localizable message) {
                this.message = message;
            }

            @Override
            public String getMessage() {
                return this.message.toString();
            }

            @Override
            public boolean requiresRestart() {
                return true;
            }
        }
    }

    public final class HudsonUpgradeJob
    extends DownloadJob {
        @Deprecated
        public HudsonUpgradeJob(UpdateSite site, Authentication auth) {
            super(site, auth.toSpring());
        }

        public HudsonUpgradeJob(UpdateSite site, org.springframework.security.core.Authentication auth) {
            super(site, auth);
        }

        @Override
        protected URL getURL() throws MalformedURLException {
            if (this.site == null) {
                throw new MalformedURLException("no update site defined");
            }
            return new URL(this.site.getData().core.url);
        }

        @Override
        protected File getDestination() {
            return Lifecycle.get().getHudsonWar();
        }

        @Override
        public String getName() {
            return "jenkins.war";
        }

        @Override
        protected void onSuccess() {
            this.status = new DownloadJob.Success();
        }

        @Override
        protected void replace(File dst, File src) throws IOException {
            if (this.site == null) {
                throw new IOException("no update site defined");
            }
            UpdateCenter.verifyChecksums(this, this.site.getData().core, src);
            Lifecycle.get().rewriteHudsonWar(src);
        }
    }

    public class RestartJenkinsJob
    extends UpdateCenterJob {
        @Exported(inline=true)
        public volatile RestartJenkinsJobStatus status;
        private String authentication;

        public synchronized boolean cancel() {
            if (this.status instanceof Pending) {
                this.status = new Canceled();
                return true;
            }
            return false;
        }

        public RestartJenkinsJob(UpdateSite site) {
            super(site);
            this.status = new Pending();
            this.authentication = Jenkins.getAuthentication2().getName();
        }

        @Override
        public synchronized void run() {
            if (!(this.status instanceof Pending)) {
                return;
            }
            this.status = new Running();
            try (ACLContext acl = ACL.as(User.get(this.authentication, false, Collections.emptyMap()));){
                Jenkins.get().safeRestart();
            }
            catch (RestartNotSupportedException exception) {
                this.status = new Failure();
                this.error = exception;
            }
        }

        @ExportedBean
        public abstract class RestartJenkinsJobStatus {
            @Exported
            public final int id = iota.incrementAndGet();
        }

        public class Pending
        extends RestartJenkinsJobStatus {
            @Exported
            public String getType() {
                return this.getClass().getSimpleName();
            }
        }

        public class Canceled
        extends RestartJenkinsJobStatus {
        }

        public class Running
        extends RestartJenkinsJobStatus {
        }

        public class Failure
        extends RestartJenkinsJobStatus {
        }
    }

    public final class HudsonDowngradeJob
    extends DownloadJob {
        @Deprecated
        public HudsonDowngradeJob(UpdateSite site, Authentication auth) {
            super(site, auth.toSpring());
        }

        public HudsonDowngradeJob(UpdateSite site, org.springframework.security.core.Authentication auth) {
            super(site, auth);
        }

        @Override
        protected URL getURL() throws MalformedURLException {
            if (this.site == null) {
                throw new MalformedURLException("no update site defined");
            }
            return new URL(this.site.getData().core.url);
        }

        @Override
        protected File getDestination() {
            return Lifecycle.get().getHudsonWar();
        }

        @Override
        public String getName() {
            return "jenkins.war";
        }

        @Override
        protected void onSuccess() {
            this.status = new DownloadJob.Success();
        }

        @Override
        public void run() {
            try {
                LOGGER.info("Starting the downgrade of " + this.getName() + " on behalf of " + this.getUser().getName());
                this._run();
                LOGGER.info("Downgrading successful: " + this.getName());
                this.status = new DownloadJob.Success();
                this.onSuccess();
            }
            catch (Throwable e) {
                LOGGER.log(Level.SEVERE, "Failed to downgrade " + this.getName(), e);
                this.status = new DownloadJob.Failure(e);
                this.error = e;
            }
        }

        @Override
        protected void _run() throws IOException {
            File backup = new File(Lifecycle.get().getHudsonWar() + ".bak");
            File dst = this.getDestination();
            UpdateCenter.this.config.install(this, backup, dst);
        }

        @Override
        protected void replace(File dst, File src) throws IOException {
            Lifecycle.get().rewriteHudsonWar(src);
        }
    }

    @Deprecated
    public static final class PluginEntry
    implements Comparable<PluginEntry> {
        public UpdateSite.Plugin plugin;
        public String category;

        private PluginEntry(UpdateSite.Plugin p, String c) {
            this.plugin = p;
            this.category = c;
        }

        @Override
        public int compareTo(PluginEntry o) {
            int r = this.category.compareTo(o.category);
            if (r == 0) {
                r = this.plugin.name.compareToIgnoreCase(o.plugin.name);
            }
            if (r == 0) {
                r = new VersionNumber(this.plugin.version).compareTo(new VersionNumber(o.plugin.version));
            }
            return r;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PluginEntry that = (PluginEntry)o;
            if (!this.category.equals(that.category)) {
                return false;
            }
            if (!this.plugin.name.equals(that.plugin.name)) {
                return false;
            }
            return this.plugin.version.equals(that.plugin.version);
        }

        public int hashCode() {
            int result = this.category.hashCode();
            result = 31 * result + this.plugin.name.hashCode();
            result = 31 * result + this.plugin.version.hashCode();
            return result;
        }
    }

    private static enum VerificationResult {
        PASS,
        NOT_PROVIDED,
        NOT_COMPUTED,
        FAIL;

    }

    @Restricted(value={NoExternalUse.class})
    static interface WithComputedChecksums {
        public String getComputedSHA1();

        public String getComputedSHA256();

        public String getComputedSHA512();
    }

    public final class PluginDowngradeJob
    extends DownloadJob {
        public final UpdateSite.Plugin plugin;
        private final PluginManager pm;

        @Deprecated
        public PluginDowngradeJob(UpdateSite.Plugin plugin, UpdateSite site, Authentication auth) {
            this(plugin, site, auth.toSpring());
        }

        public PluginDowngradeJob(UpdateSite.Plugin plugin, UpdateSite site, org.springframework.security.core.Authentication auth) {
            super(site, auth);
            this.pm = Jenkins.get().getPluginManager();
            this.plugin = plugin;
        }

        @Override
        protected URL getURL() throws MalformedURLException {
            return new URL(this.plugin.url);
        }

        @Override
        protected File getDestination() {
            File baseDir = this.pm.rootDir;
            File legacy = new File(baseDir, this.plugin.name + ".hpi");
            if (legacy.exists()) {
                return legacy;
            }
            return new File(baseDir, this.plugin.name + ".jpi");
        }

        protected File getBackup() {
            File baseDir = this.pm.rootDir;
            return new File(baseDir, this.plugin.name + ".bak");
        }

        @Override
        public String getName() {
            return this.plugin.name;
        }

        @Override
        public String getDisplayName() {
            return this.plugin.getDisplayName();
        }

        @Override
        public void run() {
            try {
                LOGGER.info("Starting the downgrade of " + this.getName() + " on behalf of " + this.getUser().getName());
                this._run();
                LOGGER.info("Downgrade successful: " + this.getName());
                this.status = new DownloadJob.Success();
                this.onSuccess();
            }
            catch (Throwable e) {
                LOGGER.log(Level.SEVERE, "Failed to downgrade " + this.getName(), e);
                this.status = new DownloadJob.Failure(e);
                this.error = e;
            }
        }

        @Override
        protected void _run() throws IOException {
            File dst = this.getDestination();
            File backup = this.getBackup();
            UpdateCenter.this.config.install(this, backup, dst);
        }

        @Override
        protected synchronized void replace(File dst, File backup) throws IOException {
            UpdateCenter.moveAtomically(backup, dst);
        }

        @Override
        protected void onSuccess() {
            this.pm.pluginUploaded = true;
        }

        public String toString() {
            return super.toString() + "[plugin=" + this.plugin.title + "]";
        }
    }

    @Restricted(value={NoExternalUse.class})
    public final class CompleteBatchJob
    extends UpdateCenterJob {
        private final List<PluginWrapper> batch;
        private final long start;
        @Exported(inline=true)
        @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"}, justification="read by Stapler")
        public volatile CompleteBatchJobStatus status;

        public CompleteBatchJob(List<PluginWrapper> batch, long start, UUID correlationId) {
            super(UpdateCenter.this.getCoreSource());
            this.status = new Pending();
            this.batch = batch;
            this.start = start;
            this.setCorrelationId(correlationId);
        }

        @Override
        public void run() {
            LOGGER.info("Completing installing of plugin batch\u2026");
            this.status = new Running();
            try {
                Jenkins.get().getPluginManager().start(this.batch);
                this.status = new Success();
            }
            catch (Exception x) {
                this.status = new Failure(x);
                LOGGER.log(Level.WARNING, "Failed to start some plugins", x);
            }
            LOGGER.log(Level.INFO, "Completed installation of {0} plugins in {1}", new Object[]{this.batch.size(), Util.getTimeSpanString((System.nanoTime() - this.start) / 1000000L)});
        }

        public class Pending
        extends CompleteBatchJobStatus {
        }

        @ExportedBean
        public abstract class CompleteBatchJobStatus {
            @Exported
            public final int id = iota.incrementAndGet();
        }

        public class Running
        extends CompleteBatchJobStatus {
        }

        public class Success
        extends CompleteBatchJobStatus {
        }

        public class Failure
        extends CompleteBatchJobStatus {
            public final Throwable problemStackTrace;

            Failure(Throwable problemStackTrace) {
                this.problemStackTrace = problemStackTrace;
            }
        }
    }

    @SuppressFBWarnings(value={"WEAK_MESSAGE_DIGEST_SHA1"}, justification="SHA-1 is only used as a fallback if SHA-256/SHA-512 are not available")
    private static class FileWithComputedChecksums
    implements WithComputedChecksums {
        private final File file;
        private String computedSHA1;
        private String computedSHA256;
        private String computedSHA512;

        FileWithComputedChecksums(File file) {
            this.file = Objects.requireNonNull(file);
        }

        @Override
        public synchronized String getComputedSHA1() {
            MessageDigest messageDigest;
            if (this.computedSHA1 != null) {
                return this.computedSHA1;
            }
            try {
                messageDigest = MessageDigest.getInstance("SHA-1");
            }
            catch (NoSuchAlgorithmException e) {
                throw new UnsupportedOperationException(e);
            }
            this.computedSHA1 = this.computeDigest(messageDigest);
            return this.computedSHA1;
        }

        @Override
        public synchronized String getComputedSHA256() {
            MessageDigest messageDigest;
            if (this.computedSHA256 != null) {
                return this.computedSHA256;
            }
            try {
                messageDigest = MessageDigest.getInstance("SHA-256");
            }
            catch (NoSuchAlgorithmException e) {
                throw new UnsupportedOperationException(e);
            }
            this.computedSHA256 = this.computeDigest(messageDigest);
            return this.computedSHA256;
        }

        @Override
        public synchronized String getComputedSHA512() {
            MessageDigest messageDigest;
            if (this.computedSHA512 != null) {
                return this.computedSHA512;
            }
            try {
                messageDigest = MessageDigest.getInstance("SHA-512");
            }
            catch (NoSuchAlgorithmException e) {
                throw new UnsupportedOperationException(e);
            }
            this.computedSHA512 = this.computeDigest(messageDigest);
            return this.computedSHA512;
        }

        /*
         * Enabled aggressive exception aggregation
         */
        private String computeDigest(MessageDigest digest) {
            try (FileInputStream is = new FileInputStream(this.file);){
                String string;
                try (BufferedInputStream bis = new BufferedInputStream(is);){
                    byte[] buffer = new byte[1024];
                    int read = bis.read(buffer, 0, buffer.length);
                    while (read > -1) {
                        digest.update(buffer, 0, read);
                        read = bis.read(buffer, 0, buffer.length);
                    }
                    string = Base64.getEncoder().encodeToString(digest.digest());
                }
                return string;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    public class NoOpJob
    extends EnableJob {
        public NoOpJob(UpdateSite site, @NonNull org.springframework.security.core.Authentication auth, UpdateSite.Plugin plugin) {
            super(site, auth, plugin, false);
        }

        @Override
        public void run() {
            this.status = new DownloadJob.Success();
        }
    }

    public class EnableJob
    extends InstallationJob {
        public EnableJob(UpdateSite site, @NonNull org.springframework.security.core.Authentication auth, UpdateSite.Plugin plugin, boolean dynamicLoad) {
            super(plugin, site, auth, dynamicLoad);
        }

        public UpdateSite.Plugin getPlugin() {
            return this.plugin;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                PluginWrapper installed;
                PluginWrapper pluginWrapper = installed = this.plugin.getInstalled();
                synchronized (pluginWrapper) {
                    if (!installed.isEnabled()) {
                        try {
                            installed.enable();
                        }
                        catch (IOException e) {
                            LOGGER.log(Level.SEVERE, "Failed to enable " + this.plugin.getDisplayName(), e);
                            this.error = e;
                            this.status = new DownloadJob.Failure((Throwable)e);
                        }
                        if (this.dynamicLoad) {
                            try {
                                this.pm.dynamicLoad(this.getDestination(), true, null);
                            }
                            catch (Exception e) {
                                LOGGER.log(Level.SEVERE, "Failed to dynamically load " + this.plugin.getDisplayName(), e);
                                this.error = e;
                                UpdateCenter.this.requiresRestart = true;
                                this.status = new DownloadJob.Failure((Throwable)e);
                            }
                        } else {
                            UpdateCenter.this.requiresRestart = true;
                        }
                    }
                }
            }
            catch (Throwable e) {
                LOGGER.log(Level.SEVERE, "An unexpected error occurred while attempting to enable " + this.plugin.getDisplayName(), e);
                this.error = e;
                UpdateCenter.this.requiresRestart = true;
                this.status = new DownloadJob.Failure(e);
            }
            if (this.status instanceof DownloadJob.Pending) {
                this.status = new DownloadJob.Success();
            }
        }
    }

    @Extension
    @Symbol(value={"coreUpdate"})
    public static final class CoreUpdateMonitor
    extends AdministrativeMonitor {
        @Override
        public String getDisplayName() {
            return Messages.UpdateCenter_CoreUpdateMonitor_DisplayName();
        }

        @Override
        public boolean isActivated() {
            if (!Jenkins.get().getUpdateCenter().isSiteDataReady()) {
                return false;
            }
            UpdateSite.Data data = this.getData();
            return data != null && data.hasCoreUpdates();
        }

        public UpdateSite.Data getData() {
            UpdateSite cs = Jenkins.get().getUpdateCenter().getCoreSource();
            if (cs != null) {
                return cs.getData();
            }
            return null;
        }

        @Override
        public Permission getRequiredPermission() {
            return Jenkins.SYSTEM_READ;
        }
    }
}

