/*
 * Decompiled with CFR 0.152.
 */
package hudson.util;

import hudson.Util;
import hudson.util.DaemonThreadFactory;
import hudson.util.ExceptionCatchingThreadFactory;
import hudson.util.NamingThreadFactory;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.io.IOUtils;

public class CompressedFile {
    private final File file;
    private final File gz;
    private static final ExecutorService compressionThread = new ThreadPoolExecutor(0, 1, 5L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ExceptionCatchingThreadFactory(new NamingThreadFactory(new DaemonThreadFactory(), "CompressedFile")));
    private static final Logger LOGGER = Logger.getLogger(CompressedFile.class.getName());

    public CompressedFile(File file) {
        this.file = file;
        this.gz = new File(file.getParentFile(), file.getName() + ".gz");
    }

    public OutputStream write() throws IOException {
        Files.deleteIfExists(Util.fileToPath(this.gz));
        return Files.newOutputStream(Util.fileToPath(this.file), new OpenOption[0]);
    }

    public InputStream read() throws IOException {
        if (Files.exists(Util.fileToPath(this.file), new LinkOption[0])) {
            return Files.newInputStream(Util.fileToPath(this.file), new OpenOption[0]);
        }
        if (Files.exists(Util.fileToPath(this.gz), new LinkOption[0])) {
            return new GZIPInputStream(Files.newInputStream(Util.fileToPath(this.gz), new OpenOption[0]));
        }
        throw new FileNotFoundException(this.file.getName());
    }

    @Deprecated
    public String loadAsString() throws IOException {
        long sizeGuess;
        if (this.file.exists()) {
            sizeGuess = this.file.length();
        } else if (this.gz.exists()) {
            sizeGuess = this.gz.length() * 2L;
        } else {
            return "";
        }
        StringBuilder str = new StringBuilder((int)sizeGuess);
        try (InputStream is = this.read();
             InputStreamReader r = new InputStreamReader(is, Charset.defaultCharset());){
            int len;
            char[] buf = new char[8192];
            while ((len = ((Reader)r).read(buf, 0, buf.length)) > 0) {
                str.append(buf, 0, len);
            }
        }
        return str.toString();
    }

    public void compress() {
        compressionThread.submit(new Runnable(){

            @Override
            public void run() {
                boolean success;
                try (InputStream in = CompressedFile.this.read();
                     OutputStream os = Files.newOutputStream(CompressedFile.this.gz.toPath(), new OpenOption[0]);
                     GZIPOutputStream out = new GZIPOutputStream(os);){
                    IOUtils.copy((InputStream)in, (OutputStream)out);
                    ((OutputStream)out).flush();
                    success = true;
                }
                catch (IOException | InvalidPathException e) {
                    LOGGER.log(Level.WARNING, "Failed to compress " + CompressedFile.this.file, e);
                    success = false;
                }
                File fileToDelete = success ? CompressedFile.this.file : CompressedFile.this.gz;
                try {
                    Files.deleteIfExists(fileToDelete.toPath());
                }
                catch (IOException | InvalidPathException e) {
                    LOGGER.log(Level.WARNING, "Failed to delete " + fileToDelete, e);
                }
            }
        });
    }
}

