/*
 * Decompiled with CFR 0.152.
 */
package hudson.util.io;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.FilePath;
import hudson.util.io.Archiver;
import hudson.util.io.TarArchiver;
import hudson.util.io.ZipArchiver;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.file.OpenOption;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

public abstract class ArchiverFactory
implements Serializable {
    @SuppressFBWarnings(value={"MS_SHOULD_BE_FINAL"}, justification="used in plugin")
    public static ArchiverFactory TAR = new TarArchiverFactory(FilePath.TarCompression.NONE);
    @SuppressFBWarnings(value={"MS_SHOULD_BE_FINAL"}, justification="used in plugin")
    public static ArchiverFactory TARGZ = new TarArchiverFactory(FilePath.TarCompression.GZIP);
    @SuppressFBWarnings(value={"MS_SHOULD_BE_FINAL"}, justification="used in plugin")
    public static ArchiverFactory ZIP = new ZipArchiverFactory();
    private static final long serialVersionUID = 1L;

    @NonNull
    public Archiver create(OutputStream out) throws IOException {
        return this.create(out, Charset.defaultCharset());
    }

    @NonNull
    public abstract Archiver create(OutputStream var1, Charset var2) throws IOException;

    @Restricted(value={NoExternalUse.class})
    public static ArchiverFactory createZipWithPrefix(String prefix, OpenOption ... openOptions) {
        return new ZipArchiverFactory(prefix, openOptions);
    }

    private static final class ZipArchiverFactory
    extends ArchiverFactory {
        private final String prefix;
        private final OpenOption[] openOptions;
        private static final long serialVersionUID = 1L;

        ZipArchiverFactory() {
            this(null, new OpenOption[0]);
        }

        ZipArchiverFactory(String prefix, OpenOption ... openOptions) {
            this.prefix = prefix;
            this.openOptions = openOptions;
        }

        @Override
        @NonNull
        public Archiver create(OutputStream out, Charset filenamesEncoding) {
            return new ZipArchiver(out, this.prefix, filenamesEncoding, this.openOptions);
        }
    }

    private static final class TarArchiverFactory
    extends ArchiverFactory {
        private final FilePath.TarCompression method;
        private static final long serialVersionUID = 1L;

        private TarArchiverFactory(FilePath.TarCompression method) {
            this.method = method;
        }

        @Override
        @NonNull
        public Archiver create(OutputStream out, Charset filenamesEncoding) throws IOException {
            return new TarArchiver(this.method.compress(out), filenamesEncoding);
        }
    }
}

