/*
 * Decompiled with CFR 0.152.
 */
package jenkins.widgets;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.widgets.Widget;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.security.stapler.StaplerAccessibleType;
import jenkins.security.stapler.StaplerDispatchable;
import jenkins.widgets.WidgetFactory;

@StaplerAccessibleType
public interface HasWidgets {
    public static final Logger LOGGER = Logger.getLogger(HasWidgets.class.getName());

    default public List<Widget> getWidgets() {
        ArrayList result = new ArrayList();
        WidgetFactory.factoriesFor(this.getClass(), Widget.class).forEach(wf -> {
            try {
                Collection wfResult = wf.createFor((HasWidgets)wf.type().cast(this));
                for (Widget w : wfResult) {
                    if (wf.widgetType().isInstance(w)) {
                        result.add(w);
                        continue;
                    }
                    LOGGER.log(Level.WARNING, "Widget from {0} for {1} included {2} not assignable to {3}", new Object[]{wf, this, w, wf.widgetType()});
                }
            }
            catch (RuntimeException e) {
                LOGGER.log(Level.WARNING, "Could not load all widgets from " + wf + " for " + this, e);
            }
        });
        return Collections.unmodifiableList(result);
    }

    @StaplerDispatchable
    @CheckForNull
    default public Widget getWidget(String name) {
        if (name == null) {
            return null;
        }
        return this.getWidgets().stream().filter(w -> name.equals(w.getUrlName())).findFirst().orElse(null);
    }
}

