/*
 * Decompiled with CFR 0.152.
 */
package hudson.search;

import hudson.search.SearchIndex;
import hudson.search.SearchItem;
import hudson.search.UserSearchProperty;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;

public class FixedSet
implements SearchIndex {
    private final Collection<? extends SearchItem> items;

    public FixedSet(Collection<? extends SearchItem> items) {
        this.items = items;
    }

    public FixedSet(SearchItem ... items) {
        this(Arrays.asList(items));
    }

    @Override
    public void find(String token, List<SearchItem> result) {
        boolean caseInsensitive = UserSearchProperty.isCaseInsensitive();
        for (SearchItem searchItem : this.items) {
            String name = searchItem.getSearchName();
            if (name == null || !name.equals(token) && (!caseInsensitive || !name.equalsIgnoreCase(token))) continue;
            result.add(searchItem);
        }
    }

    @Override
    public void suggest(String token, List<SearchItem> result) {
        boolean caseInsensitive = UserSearchProperty.isCaseInsensitive();
        for (SearchItem searchItem : this.items) {
            String name = searchItem.getSearchName();
            if (name == null || !name.contains(token) && (!caseInsensitive || !name.toLowerCase(Locale.ROOT).contains(token.toLowerCase(Locale.ROOT)))) continue;
            result.add(searchItem);
        }
    }
}

