/*
 * Decompiled with CFR 0.152.
 */
package jenkins.model.item_category;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.ExtensionPoint;
import hudson.RestrictedSince;
import hudson.model.TopLevelItemDescriptor;
import jenkins.model.item_category.Messages;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

public abstract class ItemCategory
implements ExtensionPoint {
    @Restricted(value={NoExternalUse.class})
    @RestrictedSince(value="2.14")
    public static final int MIN_TOSHOW = 1;
    private int order = 1;

    public abstract String getId();

    public abstract String getDescription();

    public abstract String getDisplayName();

    public abstract int getMinToShow();

    private void setOrder(int order) {
        this.order = order;
    }

    public int getOrder() {
        return this.order;
    }

    @NonNull
    public static ItemCategory getCategory(TopLevelItemDescriptor descriptor) {
        int order = 0;
        ExtensionList<ItemCategory> categories = ExtensionList.lookup(ItemCategory.class);
        for (ItemCategory category : categories) {
            if (category.getId().equals(descriptor.getCategoryId())) {
                category.setOrder(++order);
                return category;
            }
            ++order;
        }
        return new UncategorizedCategory();
    }

    @Extension(ordinal=-2.147483648E9)
    public static final class UncategorizedCategory
    extends ItemCategory {
        public static final String ID = "uncategorized";

        @Override
        public String getId() {
            return ID;
        }

        @Override
        public String getDescription() {
            return Messages.Uncategorized_Description();
        }

        @Override
        public String getDisplayName() {
            return Messages.Uncategorized_DisplayName();
        }

        @Override
        public int getMinToShow() {
            return 1;
        }
    }
}

