/*
 * Decompiled with CFR 0.152.
 */
package hudson;

import com.thoughtworks.xstream.core.util.Base64Encoder;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.EnvVars;
import hudson.Proc;
import hudson.Util;
import hudson.util.DualOutputStream;
import hudson.util.EncodingStream;
import hudson.util.IOUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.HttpRetryException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import jenkins.util.SystemProperties;

public class Main {
    @SuppressFBWarnings(value={"MS_SHOULD_BE_FINAL"}, justification="for debugging")
    public static boolean isUnitTest = false;
    @SuppressFBWarnings(value={"MS_SHOULD_BE_FINAL"}, justification="for debugging")
    public static boolean isDevelopmentMode = SystemProperties.getBoolean(Main.class.getName() + ".development");
    public static final int TIMEOUT = SystemProperties.getInteger(Main.class.getName() + ".timeout", 15000);

    public static void main(String[] args) {
        try {
            System.exit(Main.run(args));
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }

    public static int run(String[] args) throws Exception {
        String home = Main.getHudsonHome();
        if (home == null) {
            System.err.println("JENKINS_HOME is not set.");
            return -1;
        }
        if (args.length < 2) {
            System.err.println("Usage: <job-name> <command> <args..>");
            return -1;
        }
        return Main.remotePost(args);
    }

    private static String getHudsonHome() {
        String home = EnvVars.masterEnvVars.get("JENKINS_HOME");
        if (home != null) {
            return home;
        }
        return EnvVars.masterEnvVars.get("HUDSON_HOME");
    }

    public static int remotePost(String[] args) throws Exception {
        Object auth;
        String projectName = args[0];
        Object home = Main.getHudsonHome();
        if (!((String)home).endsWith("/")) {
            home = (String)home + "/";
        }
        if ((auth = new URL((String)home).getUserInfo()) != null) {
            auth = "Basic " + new Base64Encoder().encode(((String)auth).getBytes(StandardCharsets.UTF_8));
        }
        HttpURLConnection con = Main.open(new URL((String)home));
        if (auth != null) {
            con.setRequestProperty("Authorization", (String)auth);
        }
        con.connect();
        if (con.getResponseCode() != 200 || con.getHeaderField("X-Hudson") == null) {
            System.err.println((String)home + " is not Hudson (" + con.getResponseMessage() + ")");
            return -1;
        }
        URL jobURL = new URL((String)home + "job/" + Util.encode(projectName).replace("/", "/job/") + "/");
        HttpURLConnection con2 = Main.open(new URL(jobURL, "acceptBuildResult"));
        if (auth != null) {
            con2.setRequestProperty("Authorization", (String)auth);
        }
        con2.connect();
        if (con2.getResponseCode() != 200) {
            System.err.println(String.valueOf(jobURL) + " is not a valid external job (" + con2.getResponseCode() + " " + con2.getResponseMessage() + ")");
            return -1;
        }
        String crumbField = null;
        String crumbValue = null;
        String sessionCookies = null;
        try {
            String line;
            String[] components;
            HttpURLConnection con3 = Main.open(new URL((String)home + "crumbIssuer/api/xml?xpath=concat(//crumbRequestField,\":\",//crumb)"));
            if (auth != null) {
                con3.setRequestProperty("Authorization", (String)auth);
            }
            if ((components = (line = IOUtils.readFirstLine(con3.getInputStream(), "UTF-8")).split(":")).length == 2) {
                crumbField = components[0];
                crumbValue = components[1];
            }
            sessionCookies = con3.getHeaderField("Set-Cookie");
        }
        catch (IOException con3) {
            // empty catch block
        }
        File tmpFile = File.createTempFile("jenkins", "log");
        try {
            int ret;
            try (OutputStream os = Files.newOutputStream(tmpFile.toPath(), new OpenOption[0]);
                 OutputStreamWriter w = new OutputStreamWriter(os, StandardCharsets.UTF_8);){
                w.write("<?xml version='1.1' encoding='UTF-8'?>");
                w.write("<run><log encoding='hexBinary' content-encoding='" + Charset.defaultCharset().name() + "'>");
                ((Writer)w).flush();
                long start = System.currentTimeMillis();
                ArrayList<String> cmd = new ArrayList<String>(Arrays.asList(args).subList(1, args.length));
                Proc.LocalProc proc = new Proc.LocalProc(cmd.toArray(new String[0]), (String[])null, System.in, (OutputStream)new DualOutputStream(System.out, new EncodingStream(os)));
                ret = ((Proc)proc).join();
                w.write("</log><result>" + ret + "</result><duration>" + (System.currentTimeMillis() - start) + "</duration></run>");
            }
            catch (InvalidPathException e) {
                throw new IOException(e);
            }
            URL location = new URL(jobURL, "postBuildResult");
            while (true) {
                try {
                    HttpURLConnection con4 = Main.open(location);
                    if (auth != null) {
                        con4.setRequestProperty("Authorization", (String)auth);
                    }
                    if (crumbField != null && crumbValue != null) {
                        con4.setRequestProperty(crumbField, crumbValue);
                        con4.setRequestProperty("Cookie", sessionCookies);
                    }
                    con4.setDoOutput(true);
                    con4.setFixedLengthStreamingMode((int)tmpFile.length());
                    con4.setRequestProperty("Content-Type", "application/xml");
                    con4.connect();
                    try (InputStream in = Files.newInputStream(tmpFile.toPath(), new OpenOption[0]);){
                        org.apache.commons.io.IOUtils.copy((InputStream)in, (OutputStream)con4.getOutputStream());
                    }
                    catch (InvalidPathException e) {
                        throw new IOException(e);
                    }
                    if (con4.getResponseCode() != 200) {
                        org.apache.commons.io.IOUtils.copy((InputStream)con4.getErrorStream(), (OutputStream)System.err);
                    }
                    int n = ret;
                    return n;
                }
                catch (HttpRetryException e) {
                    if (e.getLocation() != null) {
                        location = new URL(e.getLocation());
                        continue;
                    }
                    throw e;
                }
                break;
            }
        }
        finally {
            Files.delete(Util.fileToPath(tmpFile));
        }
    }

    private static HttpURLConnection open(URL url) throws IOException {
        HttpURLConnection c = (HttpURLConnection)url.openConnection();
        c.setReadTimeout(TIMEOUT);
        c.setConnectTimeout(TIMEOUT);
        return c;
    }
}

