/*
 * Decompiled with CFR 0.152.
 */
package hudson.cli;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.AbortException;
import hudson.ExtensionList;
import hudson.ExtensionPoint;
import hudson.Functions;
import hudson.cli.HelpCommand;
import hudson.cli.WhoAmICommand;
import hudson.cli.declarative.OptionHandlerExtension;
import hudson.remoting.Channel;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UncheckedIOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Locale;
import jenkins.cli.listeners.CLIContext;
import jenkins.cli.listeners.CLIListener;
import jenkins.model.Jenkins;
import jenkins.util.Listeners;
import jenkins.util.SystemProperties;
import org.jvnet.hudson.annotation_indexer.Index;
import org.jvnet.tiger_types.Types;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.ParserProperties;
import org.kohsuke.args4j.spi.OptionHandler;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;

@ExtensionPoint.LegacyInstancesAreScopedToHudson
public abstract class CLICommand
implements ExtensionPoint,
Cloneable {
    @Restricted(value={NoExternalUse.class})
    @SuppressFBWarnings(value={"MS_SHOULD_BE_FINAL"}, justification="Accessible via System Groovy Scripts")
    public static boolean ALLOW_AT_SYNTAX = SystemProperties.getBoolean(CLICommand.class.getName() + ".allowAtSyntax");
    @SuppressFBWarnings(value={"PA_PUBLIC_PRIMITIVE_ATTRIBUTE"}, justification="Preserve API compatibility")
    public transient PrintStream stdout;
    @SuppressFBWarnings(value={"PA_PUBLIC_PRIMITIVE_ATTRIBUTE"}, justification="Preserve API compatibility")
    public transient PrintStream stderr;
    static final String CLI_LISTPARAM_SUMMARY_ERROR_TEXT = "Error occurred while performing this command, see previous stderr output.";
    @SuppressFBWarnings(value={"PA_PUBLIC_PRIMITIVE_ATTRIBUTE"}, justification="Preserve API compatibility")
    public transient InputStream stdin;
    @Deprecated
    public transient Channel channel;
    @SuppressFBWarnings(value={"PA_PUBLIC_PRIMITIVE_ATTRIBUTE"}, justification="Preserve API compatibility")
    public transient Locale locale;
    @CheckForNull
    private transient Charset encoding;
    private transient Authentication transportAuth;
    private static final ThreadLocal<CLICommand> CURRENT_COMMAND = new ThreadLocal();

    public String getName() {
        String name = this.getClass().getName();
        name = name.substring(name.lastIndexOf(46) + 1);
        if ((name = name.substring(name.lastIndexOf(36) + 1)).endsWith("Command")) {
            name = name.substring(0, name.length() - 7);
        }
        return name.replaceAll("([a-z0-9])([A-Z])", "$1-$2").toLowerCase(Locale.ENGLISH);
    }

    public abstract String getShortDescription();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int main(List<String> args, Locale locale, InputStream stdin, PrintStream stdout, PrintStream stderr) {
        this.stdin = new BufferedInputStream(stdin);
        this.stdout = stdout;
        this.stderr = stderr;
        this.locale = locale;
        CmdLineParser p = this.getCmdLineParser();
        Authentication auth = this.getTransportAuthentication2();
        CLIContext context = new CLIContext(this.getName(), args, auth);
        SecurityContext sc = null;
        Authentication old = null;
        try {
            sc = SecurityContextHolder.getContext();
            old = sc.getAuthentication();
            sc.setAuthentication(auth);
            if (!(this instanceof HelpCommand) && !(this instanceof WhoAmICommand)) {
                Jenkins.get().checkPermission(Jenkins.READ);
            }
            p.parseArgument(args.toArray(new String[0]));
            Listeners.notify(CLIListener.class, true, listener -> listener.onExecution(context));
            int res = this.run();
            Listeners.notify(CLIListener.class, true, listener -> listener.onCompleted(context, res));
            int n = res;
            return n;
        }
        catch (Throwable e) {
            int exitCode = this.handleException(e, context, p);
            Listeners.notify(CLIListener.class, true, listener -> listener.onThrowable(context, e));
            int n = exitCode;
            return n;
        }
        finally {
            if (sc != null) {
                sc.setAuthentication(old);
            }
        }
    }

    protected int handleException(Throwable e, CLIContext context, CmdLineParser p) {
        int exitCode;
        if (e instanceof CmdLineException) {
            exitCode = 2;
            this.printError(e.getMessage());
            this.printUsage(this.stderr, p);
        } else if (e instanceof IllegalArgumentException) {
            exitCode = 3;
            this.printError(e.getMessage());
        } else if (e instanceof IllegalStateException) {
            exitCode = 4;
            this.printError(e.getMessage());
        } else if (e instanceof AbortException) {
            exitCode = 5;
            this.printError(e.getMessage());
        } else if (e instanceof AccessDeniedException) {
            exitCode = 6;
            this.printError(e.getMessage());
        } else if (e instanceof BadCredentialsException) {
            exitCode = 7;
            this.printError("Bad Credentials. Search the server log for " + context.getCorrelationId() + " for more details.");
        } else {
            exitCode = 1;
            this.printError("Unexpected exception occurred while performing " + this.getName() + " command.");
            Functions.printStackTrace(e, this.stderr);
        }
        return exitCode;
    }

    private void printError(String errorMessage) {
        this.stderr.println();
        this.stderr.println("ERROR: " + errorMessage);
    }

    protected CmdLineParser getCmdLineParser() {
        ParserProperties properties = ParserProperties.defaults().withAtSyntax(ALLOW_AT_SYNTAX);
        return new CmdLineParser((Object)this, properties);
    }

    @Deprecated
    public Channel checkChannel() throws AbortException {
        throw new AbortException("This command is requesting the -remoting mode which is no longer supported. See https://www.jenkins.io/redirect/cli-command-requires-channel");
    }

    public Authentication getTransportAuthentication2() {
        Authentication a = this.transportAuth;
        if (a == null) {
            a = Jenkins.ANONYMOUS2;
        }
        return a;
    }

    @Deprecated
    public org.acegisecurity.Authentication getTransportAuthentication() {
        return org.acegisecurity.Authentication.fromSpring(this.getTransportAuthentication2());
    }

    public void setTransportAuth2(Authentication transportAuth) {
        this.transportAuth = transportAuth;
    }

    @Deprecated
    public void setTransportAuth(org.acegisecurity.Authentication transportAuth) {
        this.setTransportAuth2(transportAuth.toSpring());
    }

    protected abstract int run() throws Exception;

    protected void printUsage(PrintStream stderr, CmdLineParser p) {
        stderr.print("java -jar jenkins-cli.jar " + this.getName());
        p.printSingleLineUsage((OutputStream)stderr);
        stderr.println();
        this.printUsageSummary(stderr);
        p.printUsage((OutputStream)stderr);
    }

    @Restricted(value={NoExternalUse.class})
    public final String getSingleLineSummary() {
        Charset charset;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.getCmdLineParser().printSingleLineUsage((OutputStream)out);
        try {
            charset = this.getClientCharset();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        return out.toString(charset);
    }

    @Restricted(value={NoExternalUse.class})
    public final String getUsage() {
        Charset charset;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.getCmdLineParser().printUsage((OutputStream)out);
        try {
            charset = this.getClientCharset();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        return out.toString(charset);
    }

    @Restricted(value={NoExternalUse.class})
    public final String getLongDescription() {
        Charset charset;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            charset = this.getClientCharset();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        PrintStream ps = new PrintStream((OutputStream)out, false, charset);
        this.printUsageSummary(ps);
        ps.close();
        return out.toString(charset);
    }

    protected void printUsageSummary(PrintStream stderr) {
        stderr.println(this.getShortDescription());
    }

    @Deprecated
    protected String getClientSystemProperty(String name) throws IOException, InterruptedException {
        this.checkChannel();
        return null;
    }

    public void setClientCharset(@NonNull Charset encoding) {
        this.encoding = encoding;
    }

    @NonNull
    protected Charset getClientCharset() throws IOException, InterruptedException {
        if (this.encoding != null) {
            return this.encoding;
        }
        return Charset.defaultCharset();
    }

    @Deprecated
    protected String getClientEnvironmentVariable(String name) throws IOException, InterruptedException {
        this.checkChannel();
        return null;
    }

    protected CLICommand createClone() {
        try {
            return (CLICommand)this.getClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new LinkageError(e.getMessage(), e);
        }
    }

    public static ExtensionList<CLICommand> all() {
        return ExtensionList.lookup(CLICommand.class);
    }

    public static CLICommand clone(String name) {
        for (CLICommand cmd : CLICommand.all()) {
            if (!name.equals(cmd.getName())) continue;
            return cmd.createClone();
        }
        return null;
    }

    static CLICommand setCurrent(CLICommand cmd) {
        CLICommand old = CLICommand.getCurrent();
        CURRENT_COMMAND.set(cmd);
        return old;
    }

    public static CLICommand getCurrent() {
        return CURRENT_COMMAND.get();
    }

    static {
        Jenkins j = Jenkins.getInstanceOrNull();
        if (j != null) {
            try {
                for (Class c : Index.list(OptionHandlerExtension.class, (ClassLoader)j.getPluginManager().uberClassLoader, Class.class)) {
                    Type t = Types.getBaseClass((Type)c, OptionHandler.class);
                    CmdLineParser.registerHandler((Class)Types.erasure((Type)Types.getTypeArgument((Type)t, (int)0)), (Class)c);
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }
}

