/*
 * Decompiled with CFR 0.152.
 */
package hudson.diagnosis;

import hudson.Extension;
import hudson.RestrictedSince;
import hudson.Util;
import hudson.diagnosis.Messages;
import hudson.model.AdministrativeMonitor;
import hudson.security.Permission;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jenkins.security.stapler.StaplerDispatchable;
import org.jenkinsci.Symbol;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.stapler.HttpRedirect;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.HttpResponses;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.interceptor.RequirePOST;

@Extension
@Symbol(value={"reverseProxy"})
public class ReverseProxySetupMonitor
extends AdministrativeMonitor {
    private static final Logger LOGGER = Logger.getLogger(ReverseProxySetupMonitor.class.getName());

    @Override
    public boolean isActivated() {
        return true;
    }

    @Restricted(value={DoNotUse.class})
    @RestrictedSince(value="2.235")
    public HttpResponse doTest(StaplerRequest2 request, @QueryParameter boolean testWithContext) {
        String redirect;
        String referer = request.getReferer();
        Jenkins j = Jenkins.get();
        if (testWithContext) {
            Object contextPath = request.getServletContext().getContextPath();
            if (((String)contextPath).startsWith("/")) {
                contextPath = ((String)contextPath).substring(1) + "/";
            }
            redirect = j.getRootUrl() + (String)contextPath + "administrativeMonitor/" + this.id + "/testForReverseProxySetup/" + (referer != null ? Util.rawEncode(referer) : "NO-REFERER") + "/";
        } else {
            redirect = j.getRootUrl() + "administrativeMonitor/" + this.id + "/testForReverseProxySetup/" + (referer != null ? Util.rawEncode(referer) : "NO-REFERER") + "/";
        }
        LOGGER.log(Level.FINE, "coming from {0} and redirecting to {1}", new Object[]{referer, redirect});
        return new HttpRedirect(redirect);
    }

    @Restricted(value={DoNotUse.class})
    @StaplerDispatchable
    @RestrictedSince(value="2.235")
    public void getTestForReverseProxySetup(String rest) {
        Jenkins j = Jenkins.get();
        String inferred = j.getRootUrlFromRequest() + "manage";
        if (rest.startsWith(inferred)) {
            throw HttpResponses.ok();
        }
        LOGGER.log(Level.WARNING, "{0} vs. {1}", new Object[]{inferred, rest});
        throw HttpResponses.errorWithoutStack((int)404, (String)(inferred + " vs. " + rest));
    }

    @Override
    public Permission getRequiredPermission() {
        return Jenkins.SYSTEM_READ;
    }

    @Restricted(value={DoNotUse.class})
    @RequirePOST
    @RestrictedSince(value="2.235")
    public HttpResponse doAct(@QueryParameter String no) throws IOException {
        if (no != null) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            this.disable(true);
            return HttpResponses.redirectViaContextPath((String)"/manage");
        }
        return new HttpRedirect("https://www.jenkins.io/redirect/troubleshooting/broken-reverse-proxy");
    }

    @Override
    public String getDisplayName() {
        return Messages.ReverseProxySetupMonitor_DisplayName();
    }
}

