/*
 * Decompiled with CFR 0.152.
 */
package hudson.node_monitors;

import hudson.model.Computer;
import hudson.node_monitors.DiskSpaceMonitorDescriptor;
import hudson.node_monitors.NodeMonitor;
import java.text.ParseException;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.kohsuke.stapler.DataBoundSetter;

public abstract class AbstractDiskSpaceMonitor
extends NodeMonitor {
    public final String freeSpaceThreshold;
    private String freeSpaceWarningThreshold;
    private static final Logger LOGGER = Logger.getLogger(AbstractDiskSpaceMonitor.class.getName());
    private static final long DEFAULT_THRESHOLD = 0x40000000L;

    protected AbstractDiskSpaceMonitor(String threshold) throws ParseException {
        this.freeSpaceThreshold = threshold;
        DiskSpaceMonitorDescriptor.DiskSpace.parse(threshold);
    }

    protected AbstractDiskSpaceMonitor() {
        this.freeSpaceThreshold = "1GiB";
        this.freeSpaceWarningThreshold = "2GiB";
    }

    public Object readResolve() {
        if (this.freeSpaceWarningThreshold == null) {
            if (this.freeSpaceThreshold != null) {
                Pattern p = Pattern.compile("(\\d+)(.*)");
                Matcher m = p.matcher(this.freeSpaceThreshold);
                if (m.matches()) {
                    String digits = m.group(1);
                    String unit = m.group(2);
                    try {
                        int wt = Integer.parseInt(digits) * 2;
                        this.freeSpaceWarningThreshold = wt + unit;
                    }
                    catch (NumberFormatException nfe) {
                        this.freeSpaceWarningThreshold = "2GiB";
                    }
                }
            } else {
                this.freeSpaceWarningThreshold = "2GiB";
            }
        }
        return this;
    }

    @DataBoundSetter
    public void setFreeSpaceWarningThreshold(String freeSpaceWarningThreshold) {
        this.freeSpaceWarningThreshold = freeSpaceWarningThreshold;
    }

    public String getFreeSpaceWarningThreshold() {
        return this.freeSpaceWarningThreshold;
    }

    public long getThresholdBytes() {
        try {
            return DiskSpaceMonitorDescriptor.DiskSpace.parse((String)this.freeSpaceThreshold).size;
        }
        catch (ParseException e) {
            return 0x40000000L;
        }
    }

    protected long getThresholdBytes(Computer c) {
        return this.getThresholdBytes();
    }

    protected long getWarningThresholdBytes() {
        if (this.freeSpaceWarningThreshold == null) {
            return 0x80000000L;
        }
        try {
            return DiskSpaceMonitorDescriptor.DiskSpace.parse((String)this.freeSpaceWarningThreshold).size;
        }
        catch (ParseException e) {
            return 0x80000000L;
        }
    }

    protected long getWarningThresholdBytes(Computer c) {
        return this.getWarningThresholdBytes();
    }

    @Override
    public Object data(Computer c) {
        DiskSpaceMonitorDescriptor.DiskSpace size = (DiskSpaceMonitorDescriptor.DiskSpace)super.data(c);
        ((DiskSpaceMonitorDescriptor)this.getDescriptor()).markNodeOfflineOrOnline(c, size, this);
        return size;
    }
}

