// CHECKSTYLE:OFF

package jenkins.console;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code consoleUrlProviderDisplayName.Description}: {@code Select
     * which view you want to use for build console links. Views listed
     * higher will be prioritized over those listed lower. The views you
     * choose here will be used rather than those set by administrators.}.
     * 
     * @return
     *     {@code Select which view you want to use for build console links.
     *     Views listed higher will be prioritized over those listed lower. The
     *     views you choose here will be used rather than those set by
     *     administrators.}
     */
    public static String consoleUrlProviderDisplayName_Description() {
        return holder.format("consoleUrlProviderDisplayName.Description");
    }

    /**
     * Key {@code consoleUrlProviderDisplayName.Description}: {@code Select
     * which view you want to use for build console links. Views listed
     * higher will be prioritized over those listed lower. The views you
     * choose here will be used rather than those set by administrators.}.
     * 
     * @return
     *     {@code Select which view you want to use for build console links.
     *     Views listed higher will be prioritized over those listed lower. The
     *     views you choose here will be used rather than those set by
     *     administrators.}
     */
    public static Localizable _consoleUrlProviderDisplayName_Description() {
        return new Localizable(holder, "consoleUrlProviderDisplayName.Description");
    }

    /**
     * Key {@code consoleUrlProviderDisplayName}: {@code Console URL
     * Provider}.
     * 
     * @return
     *     {@code Console URL Provider}
     */
    public static String consoleUrlProviderDisplayName() {
        return holder.format("consoleUrlProviderDisplayName");
    }

    /**
     * Key {@code consoleUrlProviderDisplayName}: {@code Console URL
     * Provider}.
     * 
     * @return
     *     {@code Console URL Provider}
     */
    public static Localizable _consoleUrlProviderDisplayName() {
        return new Localizable(holder, "consoleUrlProviderDisplayName");
    }

    /**
     * Key {@code defaultProviderDisplayName}: {@code Default}.
     * 
     * @return
     *     {@code Default}
     */
    public static String defaultProviderDisplayName() {
        return holder.format("defaultProviderDisplayName");
    }

    /**
     * Key {@code defaultProviderDisplayName}: {@code Default}.
     * 
     * @return
     *     {@code Default}
     */
    public static Localizable _defaultProviderDisplayName() {
        return new Localizable(holder, "defaultProviderDisplayName");
    }

}
