// CHECKSTYLE:OFF

package jenkins.management;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code SystemInfoLink.Description}: {@code Displays various
     * environmental information to assist trouble-shooting.}.
     * 
     * @return
     *     {@code Displays various environmental information to assist
     *     trouble-shooting.}
     */
    public static String SystemInfoLink_Description() {
        return holder.format("SystemInfoLink.Description");
    }

    /**
     * Key {@code SystemInfoLink.Description}: {@code Displays various
     * environmental information to assist trouble-shooting.}.
     * 
     * @return
     *     {@code Displays various environmental information to assist
     *     trouble-shooting.}
     */
    public static Localizable _SystemInfoLink_Description() {
        return new Localizable(holder, "SystemInfoLink.Description");
    }

    /**
     * Key {@code NodesLink.Description}: {@code Add, remove, control and
     * monitor the various nodes that Jenkins runs jobs on.}.
     * 
     * @return
     *     {@code Add, remove, control and monitor the various nodes that Jenkins
     *     runs jobs on.}
     */
    public static String NodesLink_Description() {
        return holder.format("NodesLink.Description");
    }

    /**
     * Key {@code NodesLink.Description}: {@code Add, remove, control and
     * monitor the various nodes that Jenkins runs jobs on.}.
     * 
     * @return
     *     {@code Add, remove, control and monitor the various nodes that Jenkins
     *     runs jobs on.}
     */
    public static Localizable _NodesLink_Description() {
        return new Localizable(holder, "NodesLink.Description");
    }

    /**
     * Key {@code ConfigureTools.DisplayName}: {@code Tools}.
     * 
     * @return
     *     {@code Tools}
     */
    public static String ConfigureTools_DisplayName() {
        return holder.format("ConfigureTools.DisplayName");
    }

    /**
     * Key {@code ConfigureTools.DisplayName}: {@code Tools}.
     * 
     * @return
     *     {@code Tools}
     */
    public static Localizable _ConfigureTools_DisplayName() {
        return new Localizable(holder, "ConfigureTools.DisplayName");
    }

    /**
     * Key {@code ConsoleLink.DisplayName}: {@code Script Console}.
     * 
     * @return
     *     {@code Script Console}
     */
    public static String ConsoleLink_DisplayName() {
        return holder.format("ConsoleLink.DisplayName");
    }

    /**
     * Key {@code ConsoleLink.DisplayName}: {@code Script Console}.
     * 
     * @return
     *     {@code Script Console}
     */
    public static Localizable _ConsoleLink_DisplayName() {
        return new Localizable(holder, "ConsoleLink.DisplayName");
    }

    /**
     * Key {@code ConfigureTools.Description}: {@code Configure tools, their
     * locations and automatic installers.}.
     * 
     * @return
     *     {@code Configure tools, their locations and automatic installers.}
     */
    public static String ConfigureTools_Description() {
        return holder.format("ConfigureTools.Description");
    }

    /**
     * Key {@code ConfigureTools.Description}: {@code Configure tools, their
     * locations and automatic installers.}.
     * 
     * @return
     *     {@code Configure tools, their locations and automatic installers.}
     */
    public static Localizable _ConfigureTools_Description() {
        return new Localizable(holder, "ConfigureTools.Description");
    }

    /**
     * Key {@code ConfigureLink.DisplayName}: {@code System}.
     * 
     * @return
     *     {@code System}
     */
    public static String ConfigureLink_DisplayName() {
        return holder.format("ConfigureLink.DisplayName");
    }

    /**
     * Key {@code ConfigureLink.DisplayName}: {@code System}.
     * 
     * @return
     *     {@code System}
     */
    public static Localizable _ConfigureLink_DisplayName() {
        return new Localizable(holder, "ConfigureLink.DisplayName");
    }

    /**
     * Key {@code ConsoleLink.Description}: {@code Executes arbitrary script
     * for administration/trouble-shooting/diagnostics.}.
     * 
     * @return
     *     {@code Executes arbitrary script for
     *     administration/trouble-shooting/diagnostics.}
     */
    public static String ConsoleLink_Description() {
        return holder.format("ConsoleLink.Description");
    }

    /**
     * Key {@code ConsoleLink.Description}: {@code Executes arbitrary script
     * for administration/trouble-shooting/diagnostics.}.
     * 
     * @return
     *     {@code Executes arbitrary script for
     *     administration/trouble-shooting/diagnostics.}
     */
    public static Localizable _ConsoleLink_Description() {
        return new Localizable(holder, "ConsoleLink.Description");
    }

    /**
     * Key {@code NodesLink.DisplayName}: {@code Nodes}.
     * 
     * @return
     *     {@code Nodes}
     */
    public static String NodesLink_DisplayName() {
        return holder.format("NodesLink.DisplayName");
    }

    /**
     * Key {@code NodesLink.DisplayName}: {@code Nodes}.
     * 
     * @return
     *     {@code Nodes}
     */
    public static Localizable _NodesLink_DisplayName() {
        return new Localizable(holder, "NodesLink.DisplayName");
    }

    /**
     * Key {@code PluginsLink.updateAvailable}: {@code 1 update available}.
     * 
     * @return
     *     {@code 1 update available}
     */
    public static String PluginsLink_updateAvailable() {
        return holder.format("PluginsLink.updateAvailable");
    }

    /**
     * Key {@code PluginsLink.updateAvailable}: {@code 1 update available}.
     * 
     * @return
     *     {@code 1 update available}
     */
    public static Localizable _PluginsLink_updateAvailable() {
        return new Localizable(holder, "PluginsLink.updateAvailable");
    }

    /**
     * Key {@code ConfigureLink.Description}: {@code Configure global
     * settings and paths.}.
     * 
     * @return
     *     {@code Configure global settings and paths.}
     */
    public static String ConfigureLink_Description() {
        return holder.format("ConfigureLink.Description");
    }

    /**
     * Key {@code ConfigureLink.Description}: {@code Configure global
     * settings and paths.}.
     * 
     * @return
     *     {@code Configure global settings and paths.}
     */
    public static Localizable _ConfigureLink_Description() {
        return new Localizable(holder, "ConfigureLink.Description");
    }

    /**
     * Key {@code PluginsLink.incompatibleUpdateAvailable}: {@code 1 update
     * is incompatible with the installed version}.
     * 
     * @return
     *     {@code 1 update is incompatible with the installed version}
     */
    public static String PluginsLink_incompatibleUpdateAvailable() {
        return holder.format("PluginsLink.incompatibleUpdateAvailable");
    }

    /**
     * Key {@code PluginsLink.incompatibleUpdateAvailable}: {@code 1 update
     * is incompatible with the installed version}.
     * 
     * @return
     *     {@code 1 update is incompatible with the installed version}
     */
    public static Localizable _PluginsLink_incompatibleUpdateAvailable() {
        return new Localizable(holder, "PluginsLink.incompatibleUpdateAvailable");
    }

    /**
     * Key {@code ShutdownLink.ShutDownReason_update}: {@code Update reason}.
     * 
     * @return
     *     {@code Update reason}
     */
    public static String ShutdownLink_ShutDownReason_update() {
        return holder.format("ShutdownLink.ShutDownReason_update");
    }

    /**
     * Key {@code ShutdownLink.ShutDownReason_update}: {@code Update reason}.
     * 
     * @return
     *     {@code Update reason}
     */
    public static Localizable _ShutdownLink_ShutDownReason_update() {
        return new Localizable(holder, "ShutdownLink.ShutDownReason_update");
    }

    /**
     * Key {@code SystemInfoLink.DisplayName}: {@code System Information}.
     * 
     * @return
     *     {@code System Information}
     */
    public static String SystemInfoLink_DisplayName() {
        return holder.format("SystemInfoLink.DisplayName");
    }

    /**
     * Key {@code SystemInfoLink.DisplayName}: {@code System Information}.
     * 
     * @return
     *     {@code System Information}
     */
    public static Localizable _SystemInfoLink_DisplayName() {
        return new Localizable(holder, "SystemInfoLink.DisplayName");
    }

    /**
     * Key {@code CliLink.DisplayName}: {@code Jenkins CLI}.
     * 
     * @return
     *     {@code Jenkins CLI}
     */
    public static String CliLink_DisplayName() {
        return holder.format("CliLink.DisplayName");
    }

    /**
     * Key {@code CliLink.DisplayName}: {@code Jenkins CLI}.
     * 
     * @return
     *     {@code Jenkins CLI}
     */
    public static Localizable _CliLink_DisplayName() {
        return new Localizable(holder, "CliLink.DisplayName");
    }

    /**
     * Key {@code PluginsLink.DisplayName}: {@code Plugins}.
     * 
     * @return
     *     {@code Plugins}
     */
    public static String PluginsLink_DisplayName() {
        return holder.format("PluginsLink.DisplayName");
    }

    /**
     * Key {@code PluginsLink.DisplayName}: {@code Plugins}.
     * 
     * @return
     *     {@code Plugins}
     */
    public static Localizable _PluginsLink_DisplayName() {
        return new Localizable(holder, "PluginsLink.DisplayName");
    }

    /**
     * Key {@code StatisticsLink.Description}: {@code Check your resource
     * utilization and see if you need more computers for your builds.}.
     * 
     * @return
     *     {@code Check your resource utilization and see if you need more
     *     computers for your builds.}
     */
    public static String StatisticsLink_Description() {
        return holder.format("StatisticsLink.Description");
    }

    /**
     * Key {@code StatisticsLink.Description}: {@code Check your resource
     * utilization and see if you need more computers for your builds.}.
     * 
     * @return
     *     {@code Check your resource utilization and see if you need more
     *     computers for your builds.}
     */
    public static Localizable _StatisticsLink_Description() {
        return new Localizable(holder, "StatisticsLink.Description");
    }

    /**
     * Key {@code PluginsLink.updatesAvailable}: {@code {0} updates
     * available}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code {0} updates available}
     */
    public static String PluginsLink_updatesAvailable(Object arg0) {
        return holder.format("PluginsLink.updatesAvailable", arg0);
    }

    /**
     * Key {@code PluginsLink.updatesAvailable}: {@code {0} updates
     * available}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code {0} updates available}
     */
    public static Localizable _PluginsLink_updatesAvailable(Object arg0) {
        return new Localizable(holder, "PluginsLink.updatesAvailable", arg0);
    }

    /**
     * Key {@code ShutdownLink.Description}: {@code Stops executing new
     * builds, so that the system can be eventually shut down safely.}.
     * 
     * @return
     *     {@code Stops executing new builds, so that the system can be
     *     eventually shut down safely.}
     */
    public static String ShutdownLink_Description() {
        return holder.format("ShutdownLink.Description");
    }

    /**
     * Key {@code ShutdownLink.Description}: {@code Stops executing new
     * builds, so that the system can be eventually shut down safely.}.
     * 
     * @return
     *     {@code Stops executing new builds, so that the system can be
     *     eventually shut down safely.}
     */
    public static Localizable _ShutdownLink_Description() {
        return new Localizable(holder, "ShutdownLink.Description");
    }

    /**
     * Key {@code PluginsLink.securityUpdatesAvailable}: {@code {0} updates
     * fix security vulnerabilities}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code {0} updates fix security vulnerabilities}
     */
    public static String PluginsLink_securityUpdatesAvailable(Object arg0) {
        return holder.format("PluginsLink.securityUpdatesAvailable", arg0);
    }

    /**
     * Key {@code PluginsLink.securityUpdatesAvailable}: {@code {0} updates
     * fix security vulnerabilities}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code {0} updates fix security vulnerabilities}
     */
    public static Localizable _PluginsLink_securityUpdatesAvailable(Object arg0) {
        return new Localizable(holder, "PluginsLink.securityUpdatesAvailable", arg0);
    }

    /**
     * Key {@code PluginsLink.securityUpdateAvailable}: {@code 1 update fixes
     * security vulnerabilities}.
     * 
     * @return
     *     {@code 1 update fixes security vulnerabilities}
     */
    public static String PluginsLink_securityUpdateAvailable() {
        return holder.format("PluginsLink.securityUpdateAvailable");
    }

    /**
     * Key {@code PluginsLink.securityUpdateAvailable}: {@code 1 update fixes
     * security vulnerabilities}.
     * 
     * @return
     *     {@code 1 update fixes security vulnerabilities}
     */
    public static Localizable _PluginsLink_securityUpdateAvailable() {
        return new Localizable(holder, "PluginsLink.securityUpdateAvailable");
    }

    /**
     * Key {@code ReloadLink.Description}: {@code Discard all the loaded data
     * in memory and reload everything from file system.
     * Useful when you
     * modified config files directly on disk.}.
     * 
     * @return
     *     {@code Discard all the loaded data in memory and reload everything
     *     from file system.
     *     Useful when you modified config files directly on
     *     disk.}
     */
    public static String ReloadLink_Description() {
        return holder.format("ReloadLink.Description");
    }

    /**
     * Key {@code ReloadLink.Description}: {@code Discard all the loaded data
     * in memory and reload everything from file system.
     * Useful when you
     * modified config files directly on disk.}.
     * 
     * @return
     *     {@code Discard all the loaded data in memory and reload everything
     *     from file system.
     *     Useful when you modified config files directly on
     *     disk.}
     */
    public static Localizable _ReloadLink_Description() {
        return new Localizable(holder, "ReloadLink.Description");
    }

    /**
     * Key {@code SystemLogLink.Description}: {@code System log captures
     * output from <code>java.util.logging</code> output related to
     * Jenkins.}.
     * 
     * @return
     *     {@code System log captures output from <code>java.util.logging</code>
     *     output related to Jenkins.}
     */
    public static String SystemLogLink_Description() {
        return holder.format("SystemLogLink.Description");
    }

    /**
     * Key {@code SystemLogLink.Description}: {@code System log captures
     * output from <code>java.util.logging</code> output related to
     * Jenkins.}.
     * 
     * @return
     *     {@code System log captures output from <code>java.util.logging</code>
     *     output related to Jenkins.}
     */
    public static Localizable _SystemLogLink_Description() {
        return new Localizable(holder, "SystemLogLink.Description");
    }

    /**
     * Key {@code ShutdownLink.DisplayName_update}: {@code Update shutdown
     * preparation}.
     * 
     * @return
     *     {@code Update shutdown preparation}
     */
    public static String ShutdownLink_DisplayName_update() {
        return holder.format("ShutdownLink.DisplayName_update");
    }

    /**
     * Key {@code ShutdownLink.DisplayName_update}: {@code Update shutdown
     * preparation}.
     * 
     * @return
     *     {@code Update shutdown preparation}
     */
    public static Localizable _ShutdownLink_DisplayName_update() {
        return new Localizable(holder, "ShutdownLink.DisplayName_update");
    }

    /**
     * Key {@code ShutdownLink.ShutDownReason_title}: {@code Reason}.
     * 
     * @return
     *     {@code Reason}
     */
    public static String ShutdownLink_ShutDownReason_title() {
        return holder.format("ShutdownLink.ShutDownReason_title");
    }

    /**
     * Key {@code ShutdownLink.ShutDownReason_title}: {@code Reason}.
     * 
     * @return
     *     {@code Reason}
     */
    public static Localizable _ShutdownLink_ShutDownReason_title() {
        return new Localizable(holder, "ShutdownLink.ShutDownReason_title");
    }

    /**
     * Key {@code ShutdownLink.DisplayName_prepare}: {@code Prepare for
     * Shutdown}.
     * 
     * @return
     *     {@code Prepare for Shutdown}
     */
    public static String ShutdownLink_DisplayName_prepare() {
        return holder.format("ShutdownLink.DisplayName_prepare");
    }

    /**
     * Key {@code ShutdownLink.DisplayName_prepare}: {@code Prepare for
     * Shutdown}.
     * 
     * @return
     *     {@code Prepare for Shutdown}
     */
    public static Localizable _ShutdownLink_DisplayName_prepare() {
        return new Localizable(holder, "ShutdownLink.DisplayName_prepare");
    }

    /**
     * Key {@code ReloadLink.DisplayName}: {@code Reload Configuration from
     * Disk}.
     * 
     * @return
     *     {@code Reload Configuration from Disk}
     */
    public static String ReloadLink_DisplayName() {
        return holder.format("ReloadLink.DisplayName");
    }

    /**
     * Key {@code ReloadLink.DisplayName}: {@code Reload Configuration from
     * Disk}.
     * 
     * @return
     *     {@code Reload Configuration from Disk}
     */
    public static Localizable _ReloadLink_DisplayName() {
        return new Localizable(holder, "ReloadLink.DisplayName");
    }

    /**
     * Key {@code ShutdownLink.ShuttingDownInProgressDescription}: {@code
     * Jenkins is currently shutting down. New builds are not executing.}.
     * 
     * @return
     *     {@code Jenkins is currently shutting down. New builds are not
     *     executing.}
     */
    public static String ShutdownLink_ShuttingDownInProgressDescription() {
        return holder.format("ShutdownLink.ShuttingDownInProgressDescription");
    }

    /**
     * Key {@code ShutdownLink.ShuttingDownInProgressDescription}: {@code
     * Jenkins is currently shutting down. New builds are not executing.}.
     * 
     * @return
     *     {@code Jenkins is currently shutting down. New builds are not
     *     executing.}
     */
    public static Localizable _ShutdownLink_ShuttingDownInProgressDescription() {
        return new Localizable(holder, "ShutdownLink.ShuttingDownInProgressDescription");
    }

    /**
     * Key {@code ShutdownLink.DisplayName_cancel}: {@code Cancel Shutdown}.
     * 
     * @return
     *     {@code Cancel Shutdown}
     */
    public static String ShutdownLink_DisplayName_cancel() {
        return holder.format("ShutdownLink.DisplayName_cancel");
    }

    /**
     * Key {@code ShutdownLink.DisplayName_cancel}: {@code Cancel Shutdown}.
     * 
     * @return
     *     {@code Cancel Shutdown}
     */
    public static Localizable _ShutdownLink_DisplayName_cancel() {
        return new Localizable(holder, "ShutdownLink.DisplayName_cancel");
    }

    /**
     * Key {@code StatisticsLink.DisplayName}: {@code Load Statistics}.
     * 
     * @return
     *     {@code Load Statistics}
     */
    public static String StatisticsLink_DisplayName() {
        return holder.format("StatisticsLink.DisplayName");
    }

    /**
     * Key {@code StatisticsLink.DisplayName}: {@code Load Statistics}.
     * 
     * @return
     *     {@code Load Statistics}
     */
    public static Localizable _StatisticsLink_DisplayName() {
        return new Localizable(holder, "StatisticsLink.DisplayName");
    }

    /**
     * Key {@code SystemLogLink.DisplayName}: {@code System Log}.
     * 
     * @return
     *     {@code System Log}
     */
    public static String SystemLogLink_DisplayName() {
        return holder.format("SystemLogLink.DisplayName");
    }

    /**
     * Key {@code SystemLogLink.DisplayName}: {@code System Log}.
     * 
     * @return
     *     {@code System Log}
     */
    public static Localizable _SystemLogLink_DisplayName() {
        return new Localizable(holder, "SystemLogLink.DisplayName");
    }

    /**
     * Key {@code CliLink.Description}: {@code Access/manage Jenkins from
     * your shell, or from your script.}.
     * 
     * @return
     *     {@code Access/manage Jenkins from your shell, or from your script.}
     */
    public static String CliLink_Description() {
        return holder.format("CliLink.Description");
    }

    /**
     * Key {@code CliLink.Description}: {@code Access/manage Jenkins from
     * your shell, or from your script.}.
     * 
     * @return
     *     {@code Access/manage Jenkins from your shell, or from your script.}
     */
    public static Localizable _CliLink_Description() {
        return new Localizable(holder, "CliLink.Description");
    }

    /**
     * Key {@code PluginsLink.Description}: {@code Add, remove, disable or
     * enable plugins that can extend the functionality of Jenkins.}.
     * 
     * @return
     *     {@code Add, remove, disable or enable plugins that can extend the
     *     functionality of Jenkins.}
     */
    public static String PluginsLink_Description() {
        return holder.format("PluginsLink.Description");
    }

    /**
     * Key {@code PluginsLink.Description}: {@code Add, remove, disable or
     * enable plugins that can extend the functionality of Jenkins.}.
     * 
     * @return
     *     {@code Add, remove, disable or enable plugins that can extend the
     *     functionality of Jenkins.}
     */
    public static Localizable _PluginsLink_Description() {
        return new Localizable(holder, "PluginsLink.Description");
    }

    /**
     * Key {@code PluginsLink.incompatibleUpdatesAvailable}: {@code {0}
     * updates are incompatible with the installed version}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code {0} updates are incompatible with the installed version}
     */
    public static String PluginsLink_incompatibleUpdatesAvailable(Object arg0) {
        return holder.format("PluginsLink.incompatibleUpdatesAvailable", arg0);
    }

    /**
     * Key {@code PluginsLink.incompatibleUpdatesAvailable}: {@code {0}
     * updates are incompatible with the installed version}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code {0} updates are incompatible with the installed version}
     */
    public static Localizable _PluginsLink_incompatibleUpdatesAvailable(Object arg0) {
        return new Localizable(holder, "PluginsLink.incompatibleUpdatesAvailable", arg0);
    }

}
