/*
 * Decompiled with CFR 0.152.
 */
package hudson.model;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.model.Resource;
import hudson.model.ResourceActivity;
import hudson.model.ResourceList;
import hudson.util.AdaptedIterator;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArraySet;
import jenkins.security.NotReallyRoleSensitiveCallable;

public class ResourceController {
    private final Set<ResourceActivity> inProgress = new CopyOnWriteArraySet<ResourceActivity>();
    private final Collection<ResourceList> resourceView = new AbstractCollection<ResourceList>(){

        @Override
        public Iterator<ResourceList> iterator() {
            return new AdaptedIterator<ResourceActivity, ResourceList>(ResourceController.this.inProgress.iterator()){

                @Override
                protected ResourceList adapt(ResourceActivity item) {
                    return item.getResourceList();
                }
            };
        }

        @Override
        public int size() {
            return ResourceController.this.inProgress.size();
        }
    };
    private ResourceList inUse = ResourceList.EMPTY;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(@NonNull Runnable task, final ResourceActivity activity) throws InterruptedException {
        final ResourceList resources = activity.getResourceList();
        this._withLock(new NotReallyRoleSensitiveCallable<Void, InterruptedException>(){

            public Void call() throws InterruptedException {
                while (ResourceController.this.inUse.isCollidingWith(resources)) {
                    ResourceController.this._await();
                }
                ResourceController.this.inProgress.add(activity);
                ResourceController.this.inUse = ResourceList.union(ResourceController.this.inUse, resources);
                return null;
            }
        });
        try {
            task.run();
            this._withLock(new Runnable(){
                final /* synthetic */ ResourceActivity val$activity;
                {
                    this.val$activity = resourceActivity;
                }

                @Override
                public void run() {
                    ResourceController.this.inProgress.remove(this.val$activity);
                    ResourceController.this.inUse = ResourceList.union(ResourceController.this.resourceView);
                    ResourceController.this._signalAll();
                }
            });
        }
        catch (Throwable throwable) {
            this._withLock(new /* invalid duplicate definition of identical inner class */);
            throw throwable;
        }
    }

    public boolean canRun(final ResourceList resources) {
        try {
            return this._withLock(new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    return !ResourceController.this.inUse.isCollidingWith(resources);
                }
            });
        }
        catch (Exception e) {
            throw new IllegalStateException("Inner callable does not throw exception", e);
        }
    }

    public Resource getMissingResource(final ResourceList resources) {
        try {
            return this._withLock(new Callable<Resource>(){

                @Override
                public Resource call() {
                    return resources.getConflict(ResourceController.this.inUse);
                }
            });
        }
        catch (Exception e) {
            throw new IllegalStateException("Inner callable does not throw exception", e);
        }
    }

    public ResourceActivity getBlockingActivity(ResourceActivity activity) {
        ResourceList res = activity.getResourceList();
        for (ResourceActivity a : this.inProgress) {
            if (!res.isCollidingWith(a.getResourceList())) continue;
            return a;
        }
        return null;
    }

    @SuppressFBWarnings(value={"WA_NOT_IN_LOOP"}, justification="the caller does indeed call this method in a loop")
    protected void _await() throws InterruptedException {
        this.wait();
    }

    protected void _signalAll() {
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _withLock(Runnable runnable) {
        ResourceController resourceController = this;
        synchronized (resourceController) {
            runnable.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <V> V _withLock(Callable<V> callable) throws Exception {
        ResourceController resourceController = this;
        synchronized (resourceController) {
            return callable.call();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <V, T extends Throwable> V _withLock(hudson.remoting.Callable<V, T> callable) throws T {
        ResourceController resourceController = this;
        synchronized (resourceController) {
            return (V)callable.call();
        }
    }
}

