/*
 * Decompiled with CFR 0.152.
 */
package hudson.model;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.model.AutoCompletionCandidates;
import hudson.model.Descriptor;
import hudson.model.Job;
import hudson.model.Messages;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.RunParameterValue;
import hudson.model.SimpleParameterDefinition;
import hudson.util.EnumConverter;
import hudson.util.RunList;
import java.util.Objects;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.apache.commons.beanutils.Converter;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.export.Exported;

public class RunParameterDefinition
extends SimpleParameterDefinition {
    private final String projectName;
    private final String runId;
    private final RunParameterFilter filter;
    private static final Logger LOGGER = Logger.getLogger(RunParameterDefinition.class.getName());

    @DataBoundConstructor
    public RunParameterDefinition(@NonNull String name, String projectName, @CheckForNull String description, @CheckForNull RunParameterFilter filter) {
        super(name, description);
        this.projectName = projectName;
        this.runId = null;
        this.filter = filter;
    }

    @Deprecated
    public RunParameterDefinition(@NonNull String name, String projectName, @CheckForNull String description) {
        this(name, projectName, description, RunParameterFilter.ALL);
    }

    private RunParameterDefinition(@NonNull String name, String projectName, String runId, @CheckForNull String description, @CheckForNull RunParameterFilter filter) {
        super(name, description);
        this.projectName = projectName;
        this.runId = runId;
        this.filter = filter;
    }

    @Override
    public ParameterDefinition copyWithDefaultValue(ParameterValue defaultValue) {
        if (defaultValue instanceof RunParameterValue) {
            RunParameterValue value = (RunParameterValue)defaultValue;
            return new RunParameterDefinition(this.getName(), this.getProjectName(), value.getRunId(), this.getDescription(), this.getFilter());
        }
        return this;
    }

    @Exported
    public String getProjectName() {
        return this.projectName;
    }

    public Job getProject() {
        return Jenkins.get().getItemByFullName(this.projectName, Job.class);
    }

    @Exported
    public RunParameterFilter getFilter() {
        return null == this.filter ? RunParameterFilter.ALL : this.filter;
    }

    public RunList getBuilds() {
        switch (this.getFilter().ordinal()) {
            case 3: {
                return ((RunList)this.getProject().getBuilds()).overThresholdOnly(Result.ABORTED).completedOnly();
            }
            case 2: {
                return ((RunList)this.getProject().getBuilds()).overThresholdOnly(Result.UNSTABLE).completedOnly();
            }
            case 1: {
                return ((RunList)this.getProject().getBuilds()).overThresholdOnly(Result.SUCCESS).completedOnly();
            }
        }
        return this.getProject().getBuilds();
    }

    @Override
    public ParameterValue getDefaultParameterValue() {
        if (this.runId != null) {
            return this.createValue(this.runId);
        }
        Job project = this.getProject();
        if (project == null) {
            return null;
        }
        Object lastBuild = switch (this.getFilter().ordinal()) {
            case 3 -> project.getLastCompletedBuild();
            case 2 -> project.getLastSuccessfulBuild();
            case 1 -> project.getLastStableBuild();
            default -> project.getLastBuild();
        };
        if (lastBuild != null) {
            return this.createValue(((Run)lastBuild).getExternalizableId());
        }
        return null;
    }

    @Override
    public ParameterValue createValue(StaplerRequest2 req, JSONObject jo) {
        RunParameterValue value = (RunParameterValue)req.bindJSON(RunParameterValue.class, jo);
        value.setDescription(this.getDescription());
        return value;
    }

    @Override
    public RunParameterValue createValue(String value) {
        return new RunParameterValue(this.getName(), value, this.getDescription());
    }

    @Override
    public int hashCode() {
        if (RunParameterDefinition.class != this.getClass()) {
            return super.hashCode();
        }
        return Objects.hash(new Object[]{this.getName(), this.getDescription(), this.projectName, this.runId, this.filter});
    }

    @Override
    @SuppressFBWarnings(value={"EQ_GETCLASS_AND_CLASS_CONSTANT"}, justification="ParameterDefinitionTest tests that subclasses are not equal to their parent classes, so the behavior appears to be intentional")
    public boolean equals(Object obj) {
        if (RunParameterDefinition.class != this.getClass()) {
            return super.equals(obj);
        }
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RunParameterDefinition other = (RunParameterDefinition)obj;
        if (!Objects.equals(this.getName(), other.getName())) {
            return false;
        }
        if (!Objects.equals(this.getDescription(), other.getDescription())) {
            return false;
        }
        if (!Objects.equals(this.projectName, other.projectName)) {
            return false;
        }
        if (!Objects.equals(this.runId, other.runId)) {
            return false;
        }
        return Objects.equals((Object)this.filter, (Object)other.filter);
    }

    public static enum RunParameterFilter {
        ALL,
        STABLE,
        SUCCESSFUL,
        COMPLETED;


        public String getName() {
            return this.name();
        }

        static {
            Stapler.CONVERT_UTILS.register((Converter)new EnumConverter(), RunParameterFilter.class);
        }
    }

    @Extension
    @Symbol(value={"run", "runParam"})
    public static class DescriptorImpl
    extends ParameterDefinition.ParameterDescriptor {
        @Override
        @NonNull
        public String getDisplayName() {
            return Messages.RunParameterDefinition_DisplayName();
        }

        @Override
        public String getHelpFile() {
            return "/help/parameter/run.html";
        }

        @Override
        public ParameterDefinition newInstance(StaplerRequest2 req, JSONObject formData) throws Descriptor.FormException {
            return (ParameterDefinition)req.bindJSON(RunParameterDefinition.class, formData);
        }

        public AutoCompletionCandidates doAutoCompleteProjectName(@QueryParameter String value) {
            return AutoCompletionCandidates.ofJobNames(Job.class, value, null, Jenkins.get());
        }
    }
}

