/*
 * Decompiled with CFR 0.152.
 */
package hudson.security.csrf;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.DescriptorExtensionList;
import hudson.ExtensionPoint;
import hudson.Util;
import hudson.init.Initializer;
import hudson.model.Api;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.security.csrf.CrumbIssuerDescriptor;
import hudson.util.MultipartFormDataParser;
import io.jenkins.servlet.ServletRequestWrapper;
import io.jenkins.servlet.http.HttpServletRequestWrapper;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import javax.servlet.ServletRequest;
import jenkins.model.Jenkins;
import jenkins.security.stapler.StaplerAccessibleType;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse2;
import org.kohsuke.stapler.WebApp;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean
@StaplerAccessibleType
public abstract class CrumbIssuer
implements Describable<CrumbIssuer>,
ExtensionPoint {
    private static final String CRUMB_ATTRIBUTE = CrumbIssuer.class.getName() + "_crumb";
    @Restricted(value={NoExternalUse.class})
    public static final String DEFAULT_CRUMB_NAME = "Jenkins-Crumb";

    @Exported
    public String getCrumbRequestField() {
        return ((CrumbIssuerDescriptor)this.getDescriptor()).getCrumbRequestField();
    }

    @Exported
    public String getCrumb() {
        return this.getCrumb((jakarta.servlet.ServletRequest)Stapler.getCurrentRequest2());
    }

    public String getCrumb(jakarta.servlet.ServletRequest request) {
        String crumb = null;
        if (request != null) {
            crumb = (String)request.getAttribute(CRUMB_ATTRIBUTE);
        }
        if (crumb == null) {
            crumb = this.issueCrumb(request, ((CrumbIssuerDescriptor)this.getDescriptor()).getCrumbSalt());
            if (request != null) {
                if (crumb != null && !crumb.isEmpty()) {
                    request.setAttribute(CRUMB_ATTRIBUTE, (Object)crumb);
                } else {
                    request.removeAttribute(CRUMB_ATTRIBUTE);
                }
            }
        }
        return crumb;
    }

    @Deprecated
    public String getCrumb(ServletRequest request) {
        return this.getCrumb(request != null ? CrumbIssuer.wrap(request) : null);
    }

    protected String issueCrumb(jakarta.servlet.ServletRequest request, String salt) {
        return Util.ifOverridden(() -> this.issueCrumb(request != null ? CrumbIssuer.wrap(request) : null, salt), CrumbIssuer.class, this.getClass(), "issueCrumb", ServletRequest.class, String.class);
    }

    @Deprecated
    protected String issueCrumb(ServletRequest request, String salt) {
        return Util.ifOverridden(() -> this.issueCrumb(request != null ? CrumbIssuer.wrap(request) : null, salt), CrumbIssuer.class, this.getClass(), "issueCrumb", jakarta.servlet.ServletRequest.class, String.class);
    }

    public boolean validateCrumb(jakarta.servlet.ServletRequest request) {
        Descriptor desc = this.getDescriptor();
        String crumbField = ((CrumbIssuerDescriptor)desc).getCrumbRequestField();
        String crumbSalt = ((CrumbIssuerDescriptor)desc).getCrumbSalt();
        return this.validateCrumb(request, crumbSalt, request.getParameter(crumbField));
    }

    public boolean validateCrumb(jakarta.servlet.ServletRequest request, MultipartFormDataParser parser) {
        Descriptor desc = this.getDescriptor();
        String crumbField = ((CrumbIssuerDescriptor)desc).getCrumbRequestField();
        String crumbSalt = ((CrumbIssuerDescriptor)desc).getCrumbSalt();
        return this.validateCrumb(request, crumbSalt, parser.get(crumbField));
    }

    @Deprecated
    public boolean validateCrumb(ServletRequest request, MultipartFormDataParser parser) {
        return this.validateCrumb(request != null ? CrumbIssuer.wrap(request) : null, parser);
    }

    private static jakarta.servlet.ServletRequest wrap(@NonNull ServletRequest request) {
        if (request instanceof javax.servlet.http.HttpServletRequest) {
            javax.servlet.http.HttpServletRequest httpRequest = (javax.servlet.http.HttpServletRequest)request;
            return HttpServletRequestWrapper.toJakartaHttpServletRequest((javax.servlet.http.HttpServletRequest)httpRequest);
        }
        return ServletRequestWrapper.toJakartaServletRequest((ServletRequest)request);
    }

    public boolean validateCrumb(jakarta.servlet.ServletRequest request, String salt, String crumb) {
        return Util.ifOverridden(() -> this.validateCrumb(request != null ? CrumbIssuer.wrap(request) : null, salt, crumb), CrumbIssuer.class, this.getClass(), "validateCrumb", ServletRequest.class, String.class, String.class);
    }

    private static ServletRequest wrap(@NonNull jakarta.servlet.ServletRequest request) {
        if (request instanceof HttpServletRequest) {
            HttpServletRequest httpRequest = (HttpServletRequest)request;
            return HttpServletRequestWrapper.fromJakartaHttpServletRequest((HttpServletRequest)httpRequest);
        }
        return ServletRequestWrapper.fromJakartaServletRequest((jakarta.servlet.ServletRequest)request);
    }

    @Deprecated
    public boolean validateCrumb(ServletRequest request, String salt, String crumb) {
        return Util.ifOverridden(() -> this.validateCrumb(request != null ? CrumbIssuer.wrap(request) : null, salt, crumb), CrumbIssuer.class, this.getClass(), "validateCrumb", jakarta.servlet.ServletRequest.class, String.class, String.class);
    }

    @Override
    public CrumbIssuerDescriptor<CrumbIssuer> getDescriptor() {
        return (CrumbIssuerDescriptor)Jenkins.get().getDescriptorOrDie(this.getClass());
    }

    public static DescriptorExtensionList<CrumbIssuer, Descriptor<CrumbIssuer>> all() {
        return Jenkins.get().getDescriptorList(CrumbIssuer.class);
    }

    public Api getApi() {
        return new RestrictedApi(this);
    }

    @Initializer
    public static void initStaplerCrumbIssuer() {
        WebApp.get((ServletContext)Jenkins.get().getServletContext()).setCrumbIssuer(new org.kohsuke.stapler.CrumbIssuer(){

            public String issueCrumb(StaplerRequest2 request) {
                CrumbIssuer ci = Jenkins.get().getCrumbIssuer();
                return ci != null ? ci.getCrumb((jakarta.servlet.ServletRequest)request) : DEFAULT.issueCrumb(request);
            }

            public void validateCrumb(StaplerRequest2 request, String submittedCrumb) {
                CrumbIssuer ci = Jenkins.get().getCrumbIssuer();
                if (ci == null) {
                    DEFAULT.validateCrumb(request, submittedCrumb);
                } else if (!ci.validateCrumb((jakarta.servlet.ServletRequest)request, ((CrumbIssuerDescriptor)ci.getDescriptor()).getCrumbSalt(), submittedCrumb)) {
                    throw new SecurityException("Crumb didn't match");
                }
            }
        });
    }

    @Restricted(value={NoExternalUse.class})
    public static class RestrictedApi
    extends Api {
        RestrictedApi(CrumbIssuer instance) {
            super(instance);
        }

        @Override
        public void doXml(StaplerRequest2 req, StaplerResponse2 rsp, @QueryParameter String xpath, @QueryParameter String wrapper, @QueryParameter String tree, @QueryParameter int depth) throws IOException, ServletException {
            this.setHeaders(rsp);
            CrumbIssuer ci = (CrumbIssuer)this.bean;
            Object text = "/*/crumbRequestField/text()".equals(xpath) ? ci.getCrumbRequestField() : ("/*/crumb/text()".equals(xpath) ? ci.getCrumb() : ("concat(//crumbRequestField,\":\",//crumb)".equals(xpath) ? ci.getCrumbRequestField() + ":" + ci.getCrumb() : ("concat(//crumbRequestField,'=',//crumb)".equals(xpath) ? (ci.getCrumbRequestField().startsWith(".") || ci.getCrumbRequestField().contains("-") ? ci.getCrumbRequestField() + "=" + ci.getCrumb() : null) : null)));
            if (text != null) {
                try (ServletOutputStream o = rsp.getOutputStream();){
                    rsp.setContentType("text/plain;charset=UTF-8");
                    o.write(((String)text).getBytes(StandardCharsets.UTF_8));
                }
            } else {
                super.doXml(req, rsp, xpath, wrapper, tree, depth);
            }
        }
    }
}

