/*
 * Decompiled with CFR 0.152.
 */
package hudson.util;

import com.thoughtworks.xstream.XStreamException;
import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.converters.ErrorWriter;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.converters.collections.MapConverter;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.mapper.Mapper;
import com.thoughtworks.xstream.security.InputManipulationException;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.util.RobustReflectionConverter;
import hudson.util.XStream2SecurityUtils;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.logging.Logger;
import jenkins.util.xstream.CriticalXStreamException;
import org.jvnet.tiger_types.Types;

final class RobustMapConverter
extends MapConverter {
    private static final Object ERROR = new Object();
    @CheckForNull
    private final Class<?> keyType;
    @CheckForNull
    private final Class<?> valueType;

    RobustMapConverter(Mapper mapper) {
        this(mapper, null);
    }

    RobustMapConverter(Mapper mapper, Type mapType) {
        super(mapper);
        if (mapType != null && Map.class.isAssignableFrom(Types.erasure((Type)mapType))) {
            Type baseType = Types.getBaseClass((Type)mapType, Map.class);
            Type keyTypeArg = Types.getTypeArgument((Type)baseType, (int)0, Object.class);
            this.keyType = Types.erasure((Type)keyTypeArg);
            Type valueTypeArg = Types.getTypeArgument((Type)baseType, (int)1, Object.class);
            this.valueType = Types.erasure((Type)valueTypeArg);
        } else {
            this.keyType = null;
            this.valueType = null;
        }
    }

    protected void putCurrentEntryIntoMap(HierarchicalStreamReader reader, UnmarshallingContext context, Map map, Map target) {
        Object key = this.read(reader, context, map, this.keyType);
        Object value = this.read(reader, context, map, this.valueType);
        if (key != ERROR && value != ERROR) {
            try {
                long nanoNow = System.nanoTime();
                target.put(key, value);
                XStream2SecurityUtils.checkForCollectionDoSAttack(context, nanoNow);
            }
            catch (InputManipulationException e) {
                Logger.getLogger(RobustMapConverter.class.getName()).warning("DoS detected and prevented. If the heuristic was too aggressive, you can customize the behavior by setting the hudson.util.XStream2.collectionUpdateLimit system property. See https://www.jenkins.io/redirect/xstream-dos-prevention for more information.");
                throw new CriticalXStreamException((XStreamException)((Object)e));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object read(HierarchicalStreamReader reader, UnmarshallingContext context, Map map, @CheckForNull Class<?> expectedType) {
        if (!reader.hasMoreChildren()) {
            ConversionException exception = new ConversionException("Invalid map entry");
            reader.appendErrors((ErrorWriter)exception);
            RobustReflectionConverter.addErrorInContext(context, exception);
            return ERROR;
        }
        reader.moveDown();
        try {
            Object object = this.readBareItem(reader, context, map);
            if (expectedType != null && object != null && !expectedType.isInstance(object)) {
                ConversionException exception = new ConversionException("Invalid type for map entry key/value");
                exception.add("required-type", expectedType.getName());
                exception.add("class", object.getClass().getName());
                exception.add("converter-type", ((Object)((Object)this)).getClass().getName());
                reader.appendErrors((ErrorWriter)exception);
                RobustReflectionConverter.addErrorInContext(context, exception);
                Object object2 = ERROR;
                return object2;
            }
            Object object3 = object;
            return object3;
        }
        catch (CriticalXStreamException x) {
            throw x;
        }
        catch (XStreamException | LinkageError x) {
            RobustReflectionConverter.addErrorInContext(context, x);
            Object object = ERROR;
            return object;
        }
        finally {
            reader.moveUp();
        }
    }
}

