/*
 * Decompiled with CFR 0.152.
 */
package jenkins.mvn;

import hudson.ExtensionPoint;
import hudson.FilePath;
import hudson.model.AbstractBuild;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.TaskListener;
import io.jenkins.servlet.ServletExceptionWrapper;
import javax.servlet.ServletException;
import jenkins.mvn.DefaultSettingsProvider;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerRequest2;

public abstract class SettingsProvider
implements Describable<SettingsProvider>,
ExtensionPoint {
    public abstract FilePath supplySettings(AbstractBuild<?, ?> var1, TaskListener var2);

    public static SettingsProvider parseSettingsProvider(StaplerRequest2 req) throws Descriptor.FormException, jakarta.servlet.ServletException {
        JSONObject settings = req.getSubmittedForm().getJSONObject("settings");
        if (settings == null) {
            return new DefaultSettingsProvider();
        }
        return (SettingsProvider)req.bindJSON(SettingsProvider.class, settings);
    }

    @Deprecated
    public static SettingsProvider parseSettingsProvider(StaplerRequest req) throws Descriptor.FormException, ServletException {
        try {
            return SettingsProvider.parseSettingsProvider(StaplerRequest.toStaplerRequest2((StaplerRequest)req));
        }
        catch (jakarta.servlet.ServletException e) {
            throw ServletExceptionWrapper.fromJakartaServletException((jakarta.servlet.ServletException)e);
        }
    }

    public static FilePath getSettingsFilePath(SettingsProvider settings, AbstractBuild<?, ?> build, TaskListener listener) {
        FilePath settingsPath = null;
        if (settings != null) {
            settingsPath = settings.supplySettings(build, listener);
        }
        return settingsPath;
    }

    public static String getSettingsRemotePath(SettingsProvider settings, AbstractBuild<?, ?> build, TaskListener listener) {
        FilePath fp = SettingsProvider.getSettingsFilePath(settings, build, listener);
        return fp == null ? null : fp.getRemote();
    }
}

