/*
 * Decompiled with CFR 0.152.
 */
package hudson.console;

import hudson.Extension;
import hudson.MarkupText;
import hudson.console.ConsoleAnnotationDescriptor;
import hudson.console.ConsoleAnnotator;
import hudson.console.ConsoleNote;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;

public class HyperlinkNote
extends ConsoleNote {
    private final String url;
    private final int length;
    private static final Logger LOGGER = Logger.getLogger(HyperlinkNote.class.getName());

    public HyperlinkNote(String url, int length) {
        this.url = url;
        this.length = length;
    }

    public ConsoleAnnotator annotate(Object context, MarkupText text, int charPos) {
        String url = this.url;
        if (url.startsWith("/")) {
            StaplerRequest req = Stapler.getCurrentRequest();
            url = req != null ? req.getContextPath() + url : Jenkins.getInstance().getRootUrl() + url.substring(1);
        }
        text.addMarkup(charPos, charPos + this.length, "<a href='" + url + "'" + this.extraAttributes() + ">", "</a>");
        return null;
    }

    protected String extraAttributes() {
        return "";
    }

    public static String encodeTo(String url, String text) {
        try {
            return new HyperlinkNote(url, text.length()).encode() + text;
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Failed to serialize " + HyperlinkNote.class, e);
            return text;
        }
    }

    @Extension
    @Symbol(value={"hyperlink"})
    public static class DescriptorImpl
    extends ConsoleAnnotationDescriptor {
        @Override
        public String getDisplayName() {
            return "Hyperlinks";
        }
    }
}

