/*
 * Decompiled with CFR 0.152.
 */
package hudson.model;

import hudson.Extension;
import hudson.ExtensionList;
import hudson.model.AsyncPeriodicWork;
import hudson.model.Fingerprint;
import hudson.model.TaskListener;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.regex.Pattern;
import jenkins.model.Jenkins;
import org.jenkinsci.Symbol;

@Extension
@Symbol(value={"fingerprintCleanup"})
public final class FingerprintCleanupThread
extends AsyncPeriodicWork {
    private static final FileFilter LENGTH2DIR_FILTER = new FileFilter(){

        @Override
        public boolean accept(File f) {
            return f.isDirectory() && f.getName().length() == 2;
        }
    };
    private static final FileFilter FINGERPRINTFILE_FILTER = new FileFilter(){
        private final Pattern PATTERN = Pattern.compile("[0-9a-f]{28}\\.xml");

        @Override
        public boolean accept(File f) {
            return f.isFile() && this.PATTERN.matcher(f.getName()).matches();
        }
    };

    public FingerprintCleanupThread() {
        super("Fingerprint cleanup");
    }

    @Override
    public long getRecurrencePeriod() {
        return 86400000L;
    }

    public static void invoke() {
        FingerprintCleanupThread.getInstance().run();
    }

    private static FingerprintCleanupThread getInstance() {
        return ExtensionList.lookup(AsyncPeriodicWork.class).get(FingerprintCleanupThread.class);
    }

    @Override
    public void execute(TaskListener listener) {
        int numFiles = 0;
        File root = new File(Jenkins.getInstance().getRootDir(), "fingerprints");
        File[] files1 = root.listFiles(LENGTH2DIR_FILTER);
        if (files1 != null) {
            for (File file1 : files1) {
                File[] files2;
                for (File file2 : files2 = file1.listFiles(LENGTH2DIR_FILTER)) {
                    File[] files3;
                    for (File file3 : files3 = file2.listFiles(FINGERPRINTFILE_FILTER)) {
                        if (!this.check(file3, listener)) continue;
                        ++numFiles;
                    }
                    this.deleteIfEmpty(file2);
                }
                this.deleteIfEmpty(file1);
            }
        }
        listener.getLogger().println("Cleaned up " + numFiles + " records");
    }

    private void deleteIfEmpty(File dir) {
        String[] r = dir.list();
        if (r == null) {
            return;
        }
        if (r.length == 0) {
            dir.delete();
        }
    }

    private boolean check(File fingerprintFile, TaskListener listener) {
        try {
            Fingerprint fp = Fingerprint.load(fingerprintFile);
            if (fp == null || !fp.isAlive()) {
                listener.getLogger().println("deleting obsolete " + fingerprintFile);
                fingerprintFile.delete();
                return true;
            }
            listener.getLogger().println("possibly trimming " + fingerprintFile);
            fp = Jenkins.getInstance()._getFingerprint(fp.getHashString());
            return fp.trim();
        }
        catch (IOException e) {
            e.printStackTrace(listener.error("Failed to process " + fingerprintFile));
            return false;
        }
    }
}

