/*
 * Decompiled with CFR 0.152.
 */
package hudson.model;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.infradna.tool.bridge_method_injector.BridgeMethodsAdded;
import com.infradna.tool.bridge_method_injector.WithBridgeMethods;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.SingleValueConverter;
import com.thoughtworks.xstream.converters.basic.AbstractSingleValueConverter;
import hudson.BulkChange;
import hudson.ExtensionList;
import hudson.ExtensionPoint;
import hudson.Util;
import hudson.XmlFile;
import hudson.cli.declarative.CLIResolver;
import hudson.init.InitMilestone;
import hudson.init.Initializer;
import hudson.model.AbstractItem;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Actionable;
import hudson.model.Api;
import hudson.model.Cause;
import hudson.model.CauseAction;
import hudson.model.Computer;
import hudson.model.Executor;
import hudson.model.Job;
import hudson.model.Label;
import hudson.model.LoadBalancer;
import hudson.model.Messages;
import hudson.model.ModelObject;
import hudson.model.Node;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.model.ResourceActivity;
import hudson.model.ResourceController;
import hudson.model.Run;
import hudson.model.Saveable;
import hudson.model.labels.LabelAssignmentAction;
import hudson.model.listeners.SaveableListener;
import hudson.model.queue.CauseOfBlockage;
import hudson.model.queue.FoldableAction;
import hudson.model.queue.FutureImpl;
import hudson.model.queue.MappingWorksheet;
import hudson.model.queue.QueueListener;
import hudson.model.queue.QueueSorter;
import hudson.model.queue.QueueTaskDispatcher;
import hudson.model.queue.QueueTaskFuture;
import hudson.model.queue.ScheduleResult;
import hudson.model.queue.SubTask;
import hudson.model.queue.Tasks;
import hudson.model.queue.WorkUnit;
import hudson.model.queue.WorkUnitContext;
import hudson.security.AccessControlled;
import hudson.security.Permission;
import hudson.triggers.SafeTimerTask;
import hudson.util.ConsistentHash;
import hudson.util.Iterators;
import hudson.util.TimeUnit2;
import hudson.util.XStream2;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import jenkins.model.queue.AsynchronousExecution;
import jenkins.security.QueueItemAuthenticator;
import jenkins.security.QueueItemAuthenticatorProvider;
import jenkins.util.AtmostOneTaskExecutor;
import jenkins.util.Timer;
import org.acegisecurity.Authentication;
import org.jenkinsci.bytecode.AdaptField;
import org.jenkinsci.remoting.RoleChecker;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.HttpResponses;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;
import org.kohsuke.stapler.interceptor.RequirePOST;

@ExportedBean
@BridgeMethodsAdded
public class Queue
extends ResourceController
implements Saveable {
    private final Set<WaitingItem> waitingList = new TreeSet<WaitingItem>();
    private final ItemList<BlockedItem> blockedProjects = new ItemList();
    private final ItemList<BuildableItem> buildables = new ItemList();
    private final ItemList<BuildableItem> pendings = new ItemList();
    private volatile transient Snapshot snapshot = new Snapshot(this.waitingList, this.blockedProjects, this.buildables, this.pendings);
    private final Cache<Long, LeftItem> leftItems = CacheBuilder.newBuilder().expireAfterWrite(300L, TimeUnit.SECONDS).build();
    private volatile transient LoadBalancer loadBalancer;
    private volatile transient QueueSorter sorter;
    private final transient AtmostOneTaskExecutor<Void> maintainerThread = new AtmostOneTaskExecutor<Void>(new Callable<Void>(){

        @Override
        public Void call() throws Exception {
            Queue.this.maintain();
            return null;
        }

        public String toString() {
            return "Periodic Jenkins queue maintenance";
        }
    });
    private final transient ReentrantLock lock = new ReentrantLock();
    private final transient Condition condition = this.lock.newCondition();
    private static ConsistentHash.Hash<Node> NODE_HASH = new ConsistentHash.Hash<Node>(){

        @Override
        public String hash(Node node) {
            return node.getNodeName();
        }
    };
    private static final Logger LOGGER = Logger.getLogger(Queue.class.getName());
    public static final XStream XSTREAM = new XStream2();

    public Queue(@Nonnull LoadBalancer loadBalancer) {
        this.loadBalancer = loadBalancer.sanitize();
        new MaintainTask(this).periodic();
    }

    public LoadBalancer getLoadBalancer() {
        return this.loadBalancer;
    }

    public void setLoadBalancer(@Nonnull LoadBalancer loadBalancer) {
        if (loadBalancer == null) {
            throw new IllegalArgumentException();
        }
        this.loadBalancer = loadBalancer.sanitize();
    }

    public QueueSorter getSorter() {
        return this.sorter;
    }

    public void setSorter(QueueSorter sorter) {
        this.sorter = sorter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() {
        block23: {
            this.lock.lock();
            try {
                try {
                    this.waitingList.clear();
                    this.blockedProjects.clear();
                    this.buildables.clear();
                    this.pendings.clear();
                    File queueFile = this.getQueueFile();
                    if (queueFile.exists()) {
                        try (BufferedReader in = new BufferedReader(new InputStreamReader(new FileInputStream(queueFile)));){
                            String line;
                            while ((line = in.readLine()) != null) {
                                AbstractProject j = Jenkins.getInstance().getItemByFullName(line, AbstractProject.class);
                                if (j == null) continue;
                                j.scheduleBuild();
                            }
                        }
                        queueFile.delete();
                        break block23;
                    }
                    queueFile = this.getXMLQueueFile();
                    if (queueFile.exists()) {
                        List<Item> items;
                        Object unmarshaledObj = new XmlFile(XSTREAM, queueFile).read();
                        if (unmarshaledObj instanceof State) {
                            State state = (State)unmarshaledObj;
                            items = state.items;
                            WaitingItem.COUNTER.set(state.counter);
                        } else {
                            items = (List<Item>)unmarshaledObj;
                            long maxId = 0L;
                            for (Item o : items) {
                                if (!(o instanceof Item)) continue;
                                maxId = Math.max(maxId, o.id);
                            }
                            WaitingItem.COUNTER.set(maxId);
                        }
                        for (Item o : items) {
                            if (o instanceof Task) {
                                this.schedule((Task)((Object)o), 0);
                                continue;
                            }
                            if (!(o instanceof Item)) continue;
                            Item item = o;
                            if (item.task == null) continue;
                            if (item instanceof WaitingItem) {
                                item.enter(this);
                                continue;
                            }
                            if (item instanceof BlockedItem) {
                                item.enter(this);
                                continue;
                            }
                            if (item instanceof BuildableItem) {
                                item.enter(this);
                                continue;
                            }
                            throw new IllegalStateException("Unknown item type! " + item);
                        }
                        File bk = new File(queueFile.getPath() + ".bak");
                        bk.delete();
                        queueFile.renameTo(bk);
                        queueFile.delete();
                    }
                }
                catch (IOException e) {
                    LOGGER.log(Level.WARNING, "Failed to load the queue file " + this.getXMLQueueFile(), e);
                }
                finally {
                    this.updateSnapshot();
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save() {
        if (BulkChange.contains(this)) {
            return;
        }
        XmlFile queueFile = new XmlFile(XSTREAM, this.getXMLQueueFile());
        this.lock.lock();
        try {
            State state = new State();
            state.counter = WaitingItem.COUNTER.longValue();
            for (Item item : this.getItems()) {
                if (item.task instanceof TransientTask) continue;
                state.items.add(item);
            }
            try {
                queueFile.write(state);
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Failed to write out the queue file " + this.getXMLQueueFile(), e);
            }
        }
        finally {
            this.lock.unlock();
        }
        SaveableListener.fireOnChange(this, queueFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Jenkins.getInstance().checkPermission(Jenkins.ADMINISTER);
        this.lock.lock();
        try {
            try {
                for (WaitingItem i : new ArrayList<WaitingItem>(this.waitingList)) {
                    i.cancel(this);
                }
                this.blockedProjects.cancelAll();
                this.pendings.cancelAll();
                this.buildables.cancelAll();
            }
            finally {
                this.updateSnapshot();
            }
        }
        finally {
            this.lock.unlock();
        }
        this.scheduleMaintenance();
    }

    private File getQueueFile() {
        return new File(Jenkins.getInstance().getRootDir(), "queue.txt");
    }

    File getXMLQueueFile() {
        return new File(Jenkins.getInstance().getRootDir(), "queue.xml");
    }

    @Deprecated
    public boolean add(AbstractProject p) {
        return this.schedule(p) != null;
    }

    @CheckForNull
    public WaitingItem schedule(AbstractProject p) {
        return this.schedule(p, p.getQuietPeriod());
    }

    @Deprecated
    public boolean add(AbstractProject p, int quietPeriod) {
        return this.schedule(p, quietPeriod) != null;
    }

    @Deprecated
    public WaitingItem schedule(Task p, int quietPeriod, List<Action> actions) {
        return this.schedule2(p, quietPeriod, actions).getCreateItem();
    }

    /*
     * Exception decompiling
     */
    @Nonnull
    public ScheduleResult schedule2(Task p, int quietPeriod, List<Action> actions) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [9[WHILELOOP]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    private ScheduleResult scheduleInternal(Task p, int quietPeriod, List<Action> actions) {
        this.lock.lock();
        try {
            ArrayList<Item> duplicatesInQueue;
            GregorianCalendar due;
            block15: {
                due = new GregorianCalendar();
                ((Calendar)due).add(13, quietPeriod);
                duplicatesInQueue = new ArrayList<Item>();
                for (Item existing : this.liveGetItems(p)) {
                    boolean shouldScheduleItem = false;
                    for (QueueAction action : existing.getActions(QueueAction.class)) {
                        shouldScheduleItem |= action.shouldSchedule(actions);
                    }
                    for (QueueAction action : Util.filter(actions, QueueAction.class)) {
                        shouldScheduleItem |= action.shouldSchedule(new ArrayList<Action>(existing.getAllActions()));
                    }
                    if (shouldScheduleItem) continue;
                    duplicatesInQueue.add(existing);
                }
                if (!duplicatesInQueue.isEmpty()) break block15;
                LOGGER.log(Level.FINE, "{0} added to queue", p);
                WaitingItem added = new WaitingItem(due, p, actions);
                added.enter(this);
                this.scheduleMaintenance();
                ScheduleResult.Created created = ScheduleResult.created(added);
                this.updateSnapshot();
                return created;
            }
            try {
                LOGGER.log(Level.FINE, "{0} is already in the queue", p);
                for (Item item : duplicatesInQueue) {
                    for (FoldableAction a : Util.filter(actions, FoldableAction.class)) {
                        a.foldIntoExisting(item, p, actions);
                    }
                }
                boolean queueUpdated = false;
                for (WaitingItem wi : Util.filter(duplicatesInQueue, WaitingItem.class)) {
                    if (wi.timestamp.before(due)) continue;
                    wi.leave(this);
                    wi.timestamp = due;
                    wi.enter(this);
                    queueUpdated = true;
                }
                if (queueUpdated) {
                    this.scheduleMaintenance();
                }
                ScheduleResult.Existing existing = ScheduleResult.existing((Item)duplicatesInQueue.get(0));
                this.updateSnapshot();
                return existing;
            }
            catch (Throwable throwable) {
                this.updateSnapshot();
                throw throwable;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Deprecated
    public boolean add(Task p, int quietPeriod) {
        return this.schedule(p, quietPeriod) != null;
    }

    @CheckForNull
    public WaitingItem schedule(Task p, int quietPeriod) {
        return this.schedule(p, quietPeriod, new Action[0]);
    }

    @Deprecated
    public boolean add(Task p, int quietPeriod, Action ... actions) {
        return this.schedule(p, quietPeriod, actions) != null;
    }

    @CheckForNull
    public WaitingItem schedule(Task p, int quietPeriod, Action ... actions) {
        return this.schedule2(p, quietPeriod, actions).getCreateItem();
    }

    @Nonnull
    public ScheduleResult schedule2(Task p, int quietPeriod, Action ... actions) {
        return this.schedule2(p, quietPeriod, Arrays.asList(actions));
    }

    /*
     * Exception decompiling
     */
    public boolean cancel(Task p) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[WHILELOOP]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void updateSnapshot() {
        this.snapshot = new Snapshot(this.waitingList, this.blockedProjects, this.buildables, this.pendings);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cancel(Item item) {
        LOGGER.log(Level.FINE, "Cancelling {0} item#{1}", new Object[]{item.task, item.id});
        this.lock.lock();
        try {
            try {
                boolean bl = item.cancel(this);
                this.updateSnapshot();
                return bl;
            }
            catch (Throwable throwable) {
                this.updateSnapshot();
                throw throwable;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @RequirePOST
    public HttpResponse doCancelItem(@QueryParameter long id) throws IOException, ServletException {
        Item item = this.getItem(id);
        if (item != null) {
            this.cancel(item);
        }
        return HttpResponses.forwardToPreviousPage();
    }

    public boolean isEmpty() {
        Snapshot snapshot = this.snapshot;
        return snapshot.waitingList.isEmpty() && snapshot.blockedProjects.isEmpty() && snapshot.buildables.isEmpty() && snapshot.pendings.isEmpty();
    }

    private WaitingItem peek() {
        return this.waitingList.iterator().next();
    }

    @Exported(inline=true)
    public Item[] getItems() {
        Snapshot s = this.snapshot;
        List<Item> r = new ArrayList<Item>();
        for (Item p : s.waitingList) {
            r = this.checkPermissionsAndAddToList(r, p);
        }
        for (Item p : s.blockedProjects) {
            r = this.checkPermissionsAndAddToList(r, p);
        }
        for (Item p : Iterators.reverse(s.buildables)) {
            r = this.checkPermissionsAndAddToList(r, p);
        }
        for (Item p : Iterators.reverse(s.pendings)) {
            r = this.checkPermissionsAndAddToList(r, p);
        }
        Item[] items = new Item[r.size()];
        r.toArray(items);
        return items;
    }

    private List<Item> checkPermissionsAndAddToList(List<Item> r, Item t) {
        if (t.task instanceof AccessControlled && (((AccessControlled)((Object)t.task)).hasPermission(hudson.model.Item.READ) || ((AccessControlled)((Object)t.task)).hasPermission(Permission.READ))) {
            r.add(t);
        }
        return r;
    }

    @Exported(inline=true)
    @Restricted(value={NoExternalUse.class})
    public StubItem[] getDiscoverableItems() {
        Snapshot s = this.snapshot;
        List<StubItem> r = new ArrayList<StubItem>();
        for (Item p : s.waitingList) {
            r = this.filterDiscoverableItemListBasedOnPermissions(r, p);
        }
        for (Item p : s.blockedProjects) {
            r = this.filterDiscoverableItemListBasedOnPermissions(r, p);
        }
        for (Item p : Iterators.reverse(s.buildables)) {
            r = this.filterDiscoverableItemListBasedOnPermissions(r, p);
        }
        for (Item p : Iterators.reverse(s.pendings)) {
            r = this.filterDiscoverableItemListBasedOnPermissions(r, p);
        }
        StubItem[] items = new StubItem[r.size()];
        r.toArray(items);
        return items;
    }

    private List<StubItem> filterDiscoverableItemListBasedOnPermissions(List<StubItem> r, Item t) {
        if (t.task instanceof hudson.model.Item && !((hudson.model.Item)((Object)t.task)).hasPermission(hudson.model.Item.READ) && ((hudson.model.Item)((Object)t.task)).hasPermission(hudson.model.Item.DISCOVER)) {
            r.add(new StubItem(new StubTask(t.task)));
        }
        return r;
    }

    @Deprecated
    public List<Item> getApproximateItemsQuickly() {
        return Arrays.asList(this.getItems());
    }

    public Item getItem(long id) {
        Snapshot snapshot = this.snapshot;
        for (Item item : snapshot.blockedProjects) {
            if (item.id != id) continue;
            return item;
        }
        for (Item item : snapshot.buildables) {
            if (item.id != id) continue;
            return item;
        }
        for (Item item : snapshot.pendings) {
            if (item.id != id) continue;
            return item;
        }
        for (Item item : snapshot.waitingList) {
            if (item.id != id) continue;
            return item;
        }
        return (Item)this.leftItems.getIfPresent((Object)id);
    }

    public List<BuildableItem> getBuildableItems(Computer c) {
        Snapshot snapshot = this.snapshot;
        ArrayList<BuildableItem> result = new ArrayList<BuildableItem>();
        this._getBuildableItems(c, snapshot.buildables, result);
        this._getBuildableItems(c, snapshot.pendings, result);
        return result;
    }

    private void _getBuildableItems(Computer c, List<BuildableItem> col, List<BuildableItem> result) {
        Node node = c.getNode();
        if (node == null) {
            return;
        }
        for (BuildableItem p : col) {
            if (node.canTake(p) != null) continue;
            result.add(p);
        }
    }

    public List<BuildableItem> getBuildableItems() {
        Snapshot snapshot = this.snapshot;
        ArrayList<BuildableItem> r = new ArrayList<BuildableItem>(snapshot.buildables);
        r.addAll(snapshot.pendings);
        return r;
    }

    public List<BuildableItem> getPendingItems() {
        return new ArrayList<BuildableItem>(this.snapshot.pendings);
    }

    protected List<BlockedItem> getBlockedItems() {
        return new ArrayList<BlockedItem>(this.snapshot.blockedProjects);
    }

    public Collection<LeftItem> getLeftItems() {
        return Collections.unmodifiableCollection(this.leftItems.asMap().values());
    }

    public void clearLeftItems() {
        this.leftItems.invalidateAll();
    }

    public List<Item> getUnblockedItems() {
        Snapshot snapshot = this.snapshot;
        ArrayList<Item> queuedNotBlocked = new ArrayList<Item>();
        queuedNotBlocked.addAll(snapshot.waitingList);
        queuedNotBlocked.addAll(snapshot.buildables);
        queuedNotBlocked.addAll(snapshot.pendings);
        return queuedNotBlocked;
    }

    public Set<Task> getUnblockedTasks() {
        List<Item> items = this.getUnblockedItems();
        HashSet<Task> unblockedTasks = new HashSet<Task>(items.size());
        for (Item t : items) {
            unblockedTasks.add(t.task);
        }
        return unblockedTasks;
    }

    public boolean isPending(Task t) {
        Snapshot snapshot = this.snapshot;
        for (BuildableItem i : snapshot.pendings) {
            if (!i.task.equals(t)) continue;
            return true;
        }
        return false;
    }

    @Nonnegative
    public int countBuildableItemsFor(@CheckForNull Label l) {
        Snapshot snapshot = this.snapshot;
        int r = 0;
        for (BuildableItem bi : snapshot.buildables) {
            for (SubTask subTask : bi.task.getSubTasks()) {
                if (null != l && bi.getAssignedLabelFor(subTask) != l) continue;
                ++r;
            }
        }
        for (BuildableItem bi : snapshot.pendings) {
            for (SubTask subTask : bi.task.getSubTasks()) {
                if (null != l && bi.getAssignedLabelFor(subTask) != l) continue;
                ++r;
            }
        }
        return r;
    }

    @Nonnegative
    public int strictCountBuildableItemsFor(@CheckForNull Label l) {
        Snapshot _snapshot = this.snapshot;
        int r = 0;
        for (BuildableItem bi : _snapshot.buildables) {
            for (SubTask subTask : bi.task.getSubTasks()) {
                if (bi.getAssignedLabelFor(subTask) != l) continue;
                ++r;
            }
        }
        for (BuildableItem bi : _snapshot.pendings) {
            for (SubTask subTask : bi.task.getSubTasks()) {
                if (bi.getAssignedLabelFor(subTask) != l) continue;
                ++r;
            }
        }
        return r;
    }

    public int countBuildableItems() {
        return this.countBuildableItemsFor(null);
    }

    public Item getItem(Task t) {
        Snapshot snapshot = this.snapshot;
        for (Item item : snapshot.blockedProjects) {
            if (!item.task.equals(t)) continue;
            return item;
        }
        for (Item item : snapshot.buildables) {
            if (!item.task.equals(t)) continue;
            return item;
        }
        for (Item item : snapshot.pendings) {
            if (!item.task.equals(t)) continue;
            return item;
        }
        for (Item item : snapshot.waitingList) {
            if (!item.task.equals(t)) continue;
            return item;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Item> liveGetItems(Task t) {
        this.lock.lock();
        try {
            ArrayList<Item> result = new ArrayList<Item>();
            result.addAll(this.blockedProjects.getAll(t));
            result.addAll(this.buildables.getAll(t));
            result.addAll(this.pendings.getAll(t));
            for (Item item : this.waitingList) {
                if (!item.task.equals(t)) continue;
                result.add(item);
            }
            ArrayList<Item> arrayList = result;
            return arrayList;
        }
        finally {
            this.lock.unlock();
        }
    }

    public List<Item> getItems(Task t) {
        Snapshot snapshot = this.snapshot;
        ArrayList<Item> result = new ArrayList<Item>();
        for (Item item : snapshot.blockedProjects) {
            if (!item.task.equals(t)) continue;
            result.add(item);
        }
        for (Item item : snapshot.buildables) {
            if (!item.task.equals(t)) continue;
            result.add(item);
        }
        for (Item item : snapshot.pendings) {
            if (!item.task.equals(t)) continue;
            result.add(item);
        }
        for (Item item : snapshot.waitingList) {
            if (!item.task.equals(t)) continue;
            result.add(item);
        }
        return result;
    }

    public boolean contains(Task t) {
        Snapshot snapshot = this.snapshot;
        for (Item item : snapshot.blockedProjects) {
            if (!item.task.equals(t)) continue;
            return true;
        }
        for (Item item : snapshot.buildables) {
            if (!item.task.equals(t)) continue;
            return true;
        }
        for (Item item : snapshot.pendings) {
            if (!item.task.equals(t)) continue;
            return true;
        }
        for (Item item : snapshot.waitingList) {
            if (!item.task.equals(t)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onStartExecuting(Executor exec) throws InterruptedException {
        this.lock.lock();
        try {
            try {
                WorkUnit wu = exec.getCurrentWorkUnit();
                this.pendings.remove(wu.context.item);
                LeftItem li = new LeftItem(wu.context);
                li.enter(this);
            }
            finally {
                this.updateSnapshot();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @WithBridgeMethods(value={void.class})
    public Future<?> scheduleMaintenance() {
        return this.maintainerThread.submit();
    }

    private boolean isBuildBlocked(Item i) {
        if (i.task.isBuildBlocked() || !this.canRun(i.task.getResourceList())) {
            return true;
        }
        for (QueueTaskDispatcher d : QueueTaskDispatcher.all()) {
            if (d.canRun(i) == null) continue;
            return true;
        }
        return false;
    }

    private boolean allowNewBuildableTask(Task t) {
        try {
            if (t.isConcurrentBuild()) {
                return true;
            }
        }
        catch (AbstractMethodError abstractMethodError) {
            // empty catch block
        }
        return !this.buildables.containsKey(t) && !this.pendings.containsKey(t);
    }

    public static void withLock(Runnable runnable) {
        Queue queue;
        Jenkins jenkins = Jenkins.getInstanceOrNull();
        Queue queue2 = queue = jenkins == null ? null : jenkins.getQueue();
        if (queue == null) {
            runnable.run();
        } else {
            queue._withLock(runnable);
        }
    }

    public static <V, T extends Throwable> V withLock(hudson.remoting.Callable<V, T> callable) throws T {
        Queue queue;
        Jenkins jenkins = Jenkins.getInstanceOrNull();
        Queue queue2 = queue = jenkins == null ? null : jenkins.getQueue();
        if (queue == null) {
            return (V)callable.call();
        }
        return queue._withLock(callable);
    }

    public static <V> V withLock(Callable<V> callable) throws Exception {
        Queue queue;
        Jenkins jenkins = Jenkins.getInstanceOrNull();
        Queue queue2 = queue = jenkins == null ? null : jenkins.getQueue();
        if (queue == null) {
            return callable.call();
        }
        return queue._withLock(callable);
    }

    public static boolean tryWithLock(Runnable runnable) {
        Queue queue;
        Jenkins jenkins = Jenkins.getInstanceOrNull();
        Queue queue2 = queue = jenkins == null ? null : jenkins.getQueue();
        if (queue == null) {
            runnable.run();
            return true;
        }
        return queue._tryWithLock(runnable);
    }

    public static Runnable wrapWithLock(Runnable runnable) {
        Jenkins jenkins = Jenkins.getInstanceOrNull();
        Queue queue = jenkins == null ? null : jenkins.getQueue();
        return queue == null ? runnable : new LockedRunnable(runnable);
    }

    public static <V, T extends Throwable> hudson.remoting.Callable<V, T> wrapWithLock(hudson.remoting.Callable<V, T> callable) {
        Jenkins jenkins = Jenkins.getInstanceOrNull();
        Queue queue = jenkins == null ? null : jenkins.getQueue();
        return queue == null ? callable : new LockedHRCallable(callable);
    }

    public static <V> Callable<V> wrapWithLock(Callable<V> callable) {
        Jenkins jenkins = Jenkins.getInstanceOrNull();
        Queue queue = jenkins == null ? null : jenkins.getQueue();
        return queue == null ? callable : new LockedJUCCallable(callable);
    }

    @Override
    protected void _await() throws InterruptedException {
        this.condition.await();
    }

    @Override
    protected void _signalAll() {
        this.condition.signalAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _withLock(Runnable runnable) {
        this.lock.lock();
        try {
            runnable.run();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean _tryWithLock(Runnable runnable) {
        if (this.lock.tryLock()) {
            try {
                runnable.run();
            }
            finally {
                this.lock.unlock();
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <V, T extends Throwable> V _withLock(hudson.remoting.Callable<V, T> callable) throws T {
        this.lock.lock();
        try {
            Object object = callable.call();
            return (V)object;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected <V> V _withLock(Callable<V> callable) throws Exception {
        this.lock.lock();
        try {
            V v = callable.call();
            return v;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void maintain() {
        this.lock.lock();
        try {
            try {
                LOGGER.log(Level.FINE, "Queue maintenance started on {0} with {1}", new Object[]{this, this.snapshot});
                HashMap<Executor, JobOffer> parked = new HashMap<Executor, JobOffer>();
                ArrayList<BuildableItem> lostPendings = new ArrayList<BuildableItem>(this.pendings);
                for (Computer c : Jenkins.getInstance().getComputers()) {
                    for (Executor e : c.getExecutors()) {
                        WorkUnit workUnit;
                        if (e.isInterrupted()) {
                            lostPendings.clear();
                            LOGGER.log(Level.FINEST, "Interrupt thread for executor {0} is set and we do not know what work unit was on the executor.", e.getDisplayName());
                            continue;
                        }
                        if (e.isParking()) {
                            LOGGER.log(Level.FINEST, "{0} is parking and is waiting for a job to execute.", e.getDisplayName());
                            parked.put(e, new JobOffer(e));
                        }
                        if ((workUnit = e.getCurrentWorkUnit()) == null) continue;
                        lostPendings.remove(workUnit.context.item);
                    }
                }
                for (BuildableItem buildableItem : lostPendings) {
                    LOGGER.log(Level.INFO, "BuildableItem {0}: pending -> buildable as the assigned executor disappeared", buildableItem.task.getFullDisplayName());
                    buildableItem.isPending = false;
                    this.pendings.remove(buildableItem);
                    this.makeBuildable(buildableItem);
                }
                QueueSorter s = this.sorter;
                ArrayList<BlockedItem> blockedItems = new ArrayList<BlockedItem>(this.blockedProjects.values());
                if (s != null) {
                    s.sortBlockedItems(blockedItems);
                } else {
                    Collections.sort(blockedItems, QueueSorter.DEFAULT_BLOCKED_ITEM_COMPARATOR);
                }
                for (BlockedItem p : blockedItems) {
                    String taskDisplayName = p.task.getFullDisplayName();
                    LOGGER.log(Level.FINEST, "Current blocked item: {0}", taskDisplayName);
                    if (this.isBuildBlocked(p) || !this.allowNewBuildableTask(p.task)) continue;
                    LOGGER.log(Level.FINEST, "BlockedItem {0}: blocked -> buildable as the build is not blocked and new tasks are allowed", taskDisplayName);
                    Runnable r = this.makeBuildable(new BuildableItem(p));
                    if (r == null) continue;
                    p.leave(this);
                    r.run();
                    this.updateSnapshot();
                }
                while (!this.waitingList.isEmpty()) {
                    WaitingItem top = this.peek();
                    if (top.timestamp.compareTo(new GregorianCalendar()) > 0) {
                        LOGGER.log(Level.FINEST, "Finished moving all ready items from queue.");
                        break;
                    }
                    top.leave(this);
                    Task task = top.task;
                    if (!this.isBuildBlocked(top) && this.allowNewBuildableTask(task)) {
                        Runnable r = this.makeBuildable(new BuildableItem(top));
                        String topTaskDisplayName = top.task.getFullDisplayName();
                        if (r != null) {
                            LOGGER.log(Level.FINEST, "Executing runnable {0}", topTaskDisplayName);
                            r.run();
                            continue;
                        }
                        LOGGER.log(Level.FINEST, "Item {0} was unable to be made a buildable and is now a blocked item.", topTaskDisplayName);
                        new BlockedItem(top).enter(this);
                        continue;
                    }
                    new BlockedItem(top).enter(this);
                }
                if (s != null) {
                    s.sortBuildableItems(this.buildables);
                }
                this.updateSnapshot();
                for (BuildableItem buildableItem : new ArrayList<BuildableItem>(this.buildables)) {
                    if (this.isBuildBlocked(buildableItem)) {
                        buildableItem.leave(this);
                        new BlockedItem(buildableItem).enter(this);
                        LOGGER.log(Level.FINE, "Catching that {0} is blocked in the last minute", buildableItem);
                        this.updateSnapshot();
                        continue;
                    }
                    String taskDisplayName = buildableItem.task.getFullDisplayName();
                    if (buildableItem.task instanceof FlyweightTask) {
                        Runnable r = this.makeFlyWeightTaskBuildable(new BuildableItem(buildableItem));
                        if (r == null) continue;
                        buildableItem.leave(this);
                        LOGGER.log(Level.FINEST, "Executing flyweight task {0}", taskDisplayName);
                        r.run();
                        this.updateSnapshot();
                        continue;
                    }
                    ArrayList<JobOffer> candidates = new ArrayList<JobOffer>(parked.size());
                    for (JobOffer j : parked.values()) {
                        if (!j.canTake(buildableItem)) continue;
                        LOGGER.log(Level.FINEST, "{0} is a potential candidate for task {1}", new Object[]{j.executor.getDisplayName(), taskDisplayName});
                        candidates.add(j);
                    }
                    MappingWorksheet ws = new MappingWorksheet(buildableItem, candidates);
                    MappingWorksheet.Mapping m = this.loadBalancer.map(buildableItem.task, ws);
                    if (m == null) {
                        LOGGER.log(Level.FINER, "Failed to map {0} to executors. candidates={1} parked={2}", new Object[]{buildableItem, candidates, parked.values()});
                        continue;
                    }
                    WorkUnitContext wuc = new WorkUnitContext(buildableItem);
                    LOGGER.log(Level.FINEST, "Found a matching executor for {0}. Using it.", taskDisplayName);
                    m.execute(wuc);
                    buildableItem.leave(this);
                    if (!wuc.getWorkUnits().isEmpty()) {
                        LOGGER.log(Level.FINEST, "BuildableItem {0} marked as pending.", taskDisplayName);
                        this.makePending(buildableItem);
                    } else {
                        LOGGER.log(Level.FINEST, "BuildableItem {0} with empty work units!?", buildableItem);
                    }
                    this.updateSnapshot();
                }
            }
            finally {
                this.updateSnapshot();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @CheckForNull
    private Runnable makeBuildable(BuildableItem p) {
        if (p.task instanceof FlyweightTask) {
            String taskDisplayName = p.task.getFullDisplayName();
            if (!Queue.isBlockedByShutdown(p.task)) {
                Runnable runnable = this.makeFlyWeightTaskBuildable(p);
                LOGGER.log(Level.FINEST, "Converting flyweight task: {0} into a BuildableRunnable", taskDisplayName);
                if (runnable != null) {
                    return runnable;
                }
                LOGGER.log(Level.FINEST, "Flyweight task {0} is entering as buildable to provision a node.", taskDisplayName);
                return new BuildableRunnable(p);
            }
            LOGGER.log(Level.FINEST, "Task {0} is blocked by shutdown.", taskDisplayName);
            return null;
        }
        return new BuildableRunnable(p);
    }

    @CheckForNull
    private Runnable makeFlyWeightTaskBuildable(final BuildableItem p) {
        if (p.task instanceof FlyweightTask) {
            Jenkins h = Jenkins.getInstance();
            HashMap<Node, Integer> hashSource = new HashMap<Node, Integer>(h.getNodes().size());
            hashSource.put(h, Math.max(h.getNumExecutors() * 100, 1));
            for (Node n : h.getNodes()) {
                hashSource.put(n, n.getNumExecutors() * 100);
            }
            ConsistentHash<Node> hash = new ConsistentHash<Node>(NODE_HASH);
            hash.addAll((Map<Node, Integer>)hashSource);
            Label lbl = p.getAssignedLabel();
            for (Node n : hash.list(p.task.getFullDisplayName())) {
                final Computer c = n.toComputer();
                if (c == null || c.isOffline() || lbl != null && !lbl.contains(n) || n.canTake(p) != null) continue;
                LOGGER.log(Level.FINEST, "Creating flyweight task {0} for computer {1}", new Object[]{p.task.getFullDisplayName(), c.getName()});
                return new Runnable(){

                    @Override
                    public void run() {
                        c.startFlyWeightTask(new WorkUnitContext(p).createWorkUnit(p.task));
                        Queue.this.makePending(p);
                    }
                };
            }
        }
        return null;
    }

    private boolean makePending(BuildableItem p) {
        p.isPending = true;
        return this.pendings.add(p);
    }

    @Deprecated
    public static boolean ifBlockedByHudsonShutdown(Task task) {
        return Queue.isBlockedByShutdown(task);
    }

    public static boolean isBlockedByShutdown(Task task) {
        return Jenkins.getInstance().isQuietingDown() && !(task instanceof NonBlockingTask);
    }

    public Api getApi() {
        return new Api(this);
    }

    @CLIResolver
    public static Queue getInstance() {
        return Jenkins.getInstance().getQueue();
    }

    @Initializer(after=InitMilestone.JOB_LOADED)
    public static void init(Jenkins h) {
        h.getQueue().load();
    }

    static {
        XSTREAM.registerConverter((SingleValueConverter)new AbstractSingleValueConverter(){

            public boolean canConvert(Class klazz) {
                return hudson.model.Item.class.isAssignableFrom(klazz);
            }

            public Object fromString(String string) {
                hudson.model.Item item = Jenkins.getInstance().getItemByFullName(string);
                if (item == null) {
                    throw new NoSuchElementException("No such job exists: " + string);
                }
                return item;
            }

            public String toString(Object item) {
                return ((hudson.model.Item)item).getFullName();
            }
        });
        XSTREAM.registerConverter((SingleValueConverter)new AbstractSingleValueConverter(){

            public boolean canConvert(Class klazz) {
                return Run.class.isAssignableFrom(klazz);
            }

            public Object fromString(String string) {
                String[] split = string.split("#");
                String projectName = split[0];
                int buildNumber = Integer.parseInt(split[1]);
                Job job = (Job)Jenkins.getInstance().getItemByFullName(projectName);
                if (job == null) {
                    throw new NoSuchElementException("No such job exists: " + projectName);
                }
                Object run = job.getBuildByNumber(buildNumber);
                if (run == null) {
                    throw new NoSuchElementException("No such build: " + string);
                }
                return run;
            }

            public String toString(Object object) {
                Run run = (Run)object;
                return ((AbstractItem)run.getParent()).getFullName() + "#" + run.getNumber();
            }
        });
        XSTREAM.registerConverter((SingleValueConverter)new AbstractSingleValueConverter(){

            public boolean canConvert(Class klazz) {
                return Queue.class.isAssignableFrom(klazz);
            }

            public Object fromString(String string) {
                return Jenkins.getInstance().getQueue();
            }

            public String toString(Object item) {
                return "queue";
            }
        });
    }

    private static class LockedHRCallable<V, T extends Throwable>
    implements hudson.remoting.Callable<V, T> {
        private static final long serialVersionUID = 1L;
        private final hudson.remoting.Callable<V, T> delegate;

        private LockedHRCallable(hudson.remoting.Callable<V, T> delegate) {
            this.delegate = delegate;
        }

        public V call() throws T {
            return Queue.withLock(this.delegate);
        }

        public void checkRoles(RoleChecker checker) throws SecurityException {
            this.delegate.checkRoles(checker);
        }
    }

    private static class LockedJUCCallable<V>
    implements Callable<V> {
        private final Callable<V> delegate;

        private LockedJUCCallable(Callable<V> delegate) {
            this.delegate = delegate;
        }

        @Override
        public V call() throws Exception {
            return Queue.withLock(this.delegate);
        }
    }

    private class BuildableRunnable
    implements Runnable {
        private final BuildableItem buildableItem;

        private BuildableRunnable(BuildableItem p) {
            this.buildableItem = p;
        }

        @Override
        public void run() {
            this.buildableItem.enter(Queue.this);
        }
    }

    private static class LockedRunnable
    implements Runnable {
        private final Runnable delegate;

        private LockedRunnable(Runnable delegate) {
            this.delegate = delegate;
        }

        @Override
        public void run() {
            Queue.withLock(this.delegate);
        }
    }

    private static class Snapshot {
        private final Set<WaitingItem> waitingList;
        private final List<BlockedItem> blockedProjects;
        private final List<BuildableItem> buildables;
        private final List<BuildableItem> pendings;

        public Snapshot(Set<WaitingItem> waitingList, List<BlockedItem> blockedProjects, List<BuildableItem> buildables, List<BuildableItem> pendings) {
            this.waitingList = new LinkedHashSet<WaitingItem>(waitingList);
            this.blockedProjects = new ArrayList<BlockedItem>(blockedProjects);
            this.buildables = new ArrayList<BuildableItem>(buildables);
            this.pendings = new ArrayList<BuildableItem>(pendings);
        }

        public String toString() {
            return "Queue.Snapshot{waitingList=" + this.waitingList + ";blockedProjects=" + this.blockedProjects + ";buildables=" + this.buildables + ";pendings=" + this.pendings + "}";
        }
    }

    private class ItemList<T extends Item>
    extends ArrayList<T> {
        private ItemList() {
        }

        public T get(Task task) {
            for (Item item : this) {
                if (!item.task.equals(task)) continue;
                return (T)item;
            }
            return null;
        }

        public List<T> getAll(Task task) {
            ArrayList<Item> result = new ArrayList<Item>();
            for (Item item : this) {
                if (!item.task.equals(task)) continue;
                result.add(item);
            }
            return result;
        }

        public boolean containsKey(Task task) {
            return this.get(task) != null;
        }

        public T remove(Task task) {
            Iterator it = this.iterator();
            while (it.hasNext()) {
                Item t = (Item)it.next();
                if (!t.task.equals(task)) continue;
                it.remove();
                return (T)t;
            }
            return null;
        }

        public void put(Task task, T item) {
            assert (((Item)item).task.equals(task));
            this.add(item);
        }

        public ItemList<T> values() {
            return this;
        }

        public T cancel(Task p) {
            T x = this.get(p);
            if (x != null) {
                ((Item)x).cancel(Queue.this);
            }
            return x;
        }

        public void cancelAll() {
            for (Item t : new ArrayList(this)) {
                t.cancel(Queue.this);
            }
            this.clear();
        }
    }

    private static class MaintainTask
    extends SafeTimerTask {
        private final WeakReference<Queue> queue;

        MaintainTask(Queue queue) {
            this.queue = new WeakReference<Queue>(queue);
        }

        private void periodic() {
            long interval = 5000L;
            Timer.get().scheduleWithFixedDelay(this, interval, interval, TimeUnit.MILLISECONDS);
        }

        @Override
        protected void doRun() {
            Queue q = (Queue)this.queue.get();
            if (q != null) {
                q.maintain();
            } else {
                this.cancel();
            }
        }
    }

    public static final class LeftItem
    extends Item {
        public final WorkUnitContext outcome;

        public LeftItem(WorkUnitContext wuc) {
            super(wuc.item);
            this.outcome = wuc;
        }

        public LeftItem(Item cancelled) {
            super(cancelled);
            this.outcome = null;
        }

        @Override
        public CauseOfBlockage getCauseOfBlockage() {
            return null;
        }

        @Exported
        @CheckForNull
        public Executable getExecutable() {
            return this.outcome != null ? this.outcome.getPrimaryWorkUnit().getExecutable() : null;
        }

        @Exported
        public boolean isCancelled() {
            return this.outcome == null;
        }

        @Override
        void enter(Queue q) {
            q.leftItems.put((Object)this.getId(), (Object)this);
            for (QueueListener ql : QueueListener.all()) {
                try {
                    ql.onLeft(this);
                }
                catch (Throwable e) {
                    LOGGER.log(Level.WARNING, "QueueListener failed while processing " + this, e);
                }
            }
        }

        @Override
        boolean leave(Queue q) {
            return false;
        }
    }

    public static final class BuildableItem
    extends NotWaitingItem {
        private boolean isPending;

        public BuildableItem(WaitingItem wi) {
            super(wi);
        }

        public BuildableItem(NotWaitingItem ni) {
            super(ni);
        }

        @Override
        public CauseOfBlockage getCauseOfBlockage() {
            Jenkins jenkins = Jenkins.getInstance();
            if (Queue.isBlockedByShutdown(this.task)) {
                return CauseOfBlockage.fromMessage(Messages._Queue_HudsonIsAboutToShutDown());
            }
            Label label = this.getAssignedLabel();
            List<Node> allNodes = jenkins.getNodes();
            if (allNodes.isEmpty()) {
                label = null;
            }
            if (label != null) {
                Set<Node> nodes = label.getNodes();
                if (label.isOffline()) {
                    if (nodes.size() != 1) {
                        return new CauseOfBlockage.BecauseLabelIsOffline(label);
                    }
                    return new CauseOfBlockage.BecauseNodeIsOffline(nodes.iterator().next());
                }
                if (nodes.size() != 1) {
                    return new CauseOfBlockage.BecauseLabelIsBusy(label);
                }
                return new CauseOfBlockage.BecauseNodeIsBusy(nodes.iterator().next());
            }
            return CauseOfBlockage.createNeedsMoreExecutor(Messages._Queue_WaitingForNextAvailableExecutor());
        }

        @Override
        public boolean isStuck() {
            Label label = this.getAssignedLabel();
            if (label != null && label.isOffline()) {
                return true;
            }
            long d = this.task.getEstimatedDuration();
            long elapsed = System.currentTimeMillis() - this.buildableStartMilliseconds;
            if (d >= 0L) {
                return elapsed > Math.max(d, 60000L) * 10L;
            }
            return TimeUnit2.MILLISECONDS.toHours(elapsed) > 24L;
        }

        @Exported
        public boolean isPending() {
            return this.isPending;
        }

        @Override
        void enter(Queue q) {
            q.buildables.add(this);
            for (QueueListener ql : QueueListener.all()) {
                try {
                    ql.onEnterBuildable(this);
                }
                catch (Throwable e) {
                    LOGGER.log(Level.WARNING, "QueueListener failed while processing " + this, e);
                }
            }
        }

        @Override
        boolean leave(Queue q) {
            boolean r = q.buildables.remove(this);
            if (r) {
                LOGGER.log(Level.FINE, "{0} no longer blocked", this);
                for (QueueListener ql : QueueListener.all()) {
                    try {
                        ql.onLeaveBuildable(this);
                    }
                    catch (Throwable e) {
                        LOGGER.log(Level.WARNING, "QueueListener failed while processing " + this, e);
                    }
                }
            }
            return r;
        }
    }

    public final class BlockedItem
    extends NotWaitingItem {
        public BlockedItem(WaitingItem wi) {
            super(wi);
        }

        public BlockedItem(NotWaitingItem ni) {
            super(ni);
        }

        @Override
        public CauseOfBlockage getCauseOfBlockage() {
            ResourceActivity r = Queue.this.getBlockingActivity(this.task);
            if (r != null) {
                if (r == this.task) {
                    return CauseOfBlockage.fromMessage(Messages._Queue_InProgress());
                }
                return CauseOfBlockage.fromMessage(Messages._Queue_BlockedBy(r.getDisplayName()));
            }
            for (QueueTaskDispatcher d : QueueTaskDispatcher.all()) {
                CauseOfBlockage cause = d.canRun(this);
                if (cause == null) continue;
                return cause;
            }
            return this.task.getCauseOfBlockage();
        }

        @Override
        void enter(Queue q) {
            LOGGER.log(Level.FINE, "{0} is blocked", this);
            Queue.this.blockedProjects.add(this);
            for (QueueListener ql : QueueListener.all()) {
                try {
                    ql.onEnterBlocked(this);
                }
                catch (Throwable e) {
                    LOGGER.log(Level.WARNING, "QueueListener failed while processing " + this, e);
                }
            }
        }

        @Override
        boolean leave(Queue q) {
            boolean r = Queue.this.blockedProjects.remove(this);
            if (r) {
                LOGGER.log(Level.FINE, "{0} no longer blocked", this);
                for (QueueListener ql : QueueListener.all()) {
                    try {
                        ql.onLeaveBlocked(this);
                    }
                    catch (Throwable e) {
                        LOGGER.log(Level.WARNING, "QueueListener failed while processing " + this, e);
                    }
                }
            }
            return r;
        }
    }

    public static abstract class NotWaitingItem
    extends Item {
        @Exported
        public final long buildableStartMilliseconds;

        protected NotWaitingItem(WaitingItem wi) {
            super(wi);
            this.buildableStartMilliseconds = System.currentTimeMillis();
        }

        protected NotWaitingItem(NotWaitingItem ni) {
            super(ni);
            this.buildableStartMilliseconds = ni.buildableStartMilliseconds;
        }
    }

    public static final class WaitingItem
    extends Item
    implements Comparable<WaitingItem> {
        private static final AtomicLong COUNTER = new AtomicLong(0L);
        @Exported
        public Calendar timestamp;

        public WaitingItem(Calendar timestamp, Task project, List<Action> actions) {
            super(project, actions, COUNTER.incrementAndGet(), new FutureImpl(project));
            this.timestamp = timestamp;
        }

        static int getCurrentCounterValue() {
            return COUNTER.intValue();
        }

        @Override
        public int compareTo(WaitingItem that) {
            int r = this.timestamp.getTime().compareTo(that.timestamp.getTime());
            if (r != 0) {
                return r;
            }
            if (this.getId() < that.getId()) {
                return -1;
            }
            if (this.getId() == that.getId()) {
                return 0;
            }
            return 1;
        }

        @Override
        public CauseOfBlockage getCauseOfBlockage() {
            long diff = this.timestamp.getTimeInMillis() - System.currentTimeMillis();
            if (diff > 0L) {
                return CauseOfBlockage.fromMessage(Messages._Queue_InQuietPeriod(Util.getTimeSpanString(diff)));
            }
            return CauseOfBlockage.fromMessage(Messages._Queue_Unknown());
        }

        @Override
        void enter(Queue q) {
            if (q.waitingList.add(this)) {
                for (QueueListener ql : QueueListener.all()) {
                    try {
                        ql.onEnterWaiting(this);
                    }
                    catch (Throwable e) {
                        LOGGER.log(Level.WARNING, "QueueListener failed while processing " + this, e);
                    }
                }
            }
        }

        @Override
        boolean leave(Queue q) {
            boolean r = q.waitingList.remove(this);
            if (r) {
                for (QueueListener ql : QueueListener.all()) {
                    try {
                        ql.onLeaveWaiting(this);
                    }
                    catch (Throwable e) {
                        LOGGER.log(Level.WARNING, "QueueListener failed while processing " + this, e);
                    }
                }
            }
            return r;
        }
    }

    public static abstract class QueueDecisionHandler
    implements ExtensionPoint {
        public abstract boolean shouldSchedule(Task var1, List<Action> var2);

        public static ExtensionList<QueueDecisionHandler> all() {
            return ExtensionList.lookup(QueueDecisionHandler.class);
        }
    }

    public static interface QueueAction
    extends Action {
        public boolean shouldSchedule(List<Action> var1);
    }

    @ExportedBean(defaultVisibility=999)
    @Restricted(value={NoExternalUse.class})
    public class StubItem {
        @Exported
        public StubTask task;

        public StubItem(StubTask task) {
            this.task = task;
        }
    }

    @ExportedBean(defaultVisibility=999)
    @Restricted(value={NoExternalUse.class})
    public static class StubTask {
        private String name;

        public StubTask(@Nonnull Task base) {
            this.name = base.getName();
        }

        @Exported
        public String getName() {
            return this.name;
        }
    }

    @ExportedBean(defaultVisibility=999)
    @BridgeMethodsAdded
    public static abstract class Item
    extends Actionable {
        private final long id;
        @Exported
        public final Task task;
        private transient FutureImpl future;
        private final long inQueueSince;

        @Exported
        public long getId() {
            return this.id;
        }

        @AdaptField(was={int.class}, name="id")
        @Deprecated
        public int getIdLegacy() {
            if (this.id > Integer.MAX_VALUE) {
                throw new IllegalStateException("Sorry, you need to update any Plugins attempting to assign 'Queue.Item.id' to an int value. 'Queue.Item.id' is now a long value and has incremented to a value greater than Integer.MAX_VALUE (2^31 - 1).");
            }
            return (int)this.id;
        }

        @Exported
        public boolean isBlocked() {
            return this instanceof BlockedItem;
        }

        @Exported
        public boolean isBuildable() {
            return this instanceof BuildableItem;
        }

        @Exported
        public boolean isStuck() {
            return false;
        }

        @Exported
        public long getInQueueSince() {
            return this.inQueueSince;
        }

        public String getInQueueForString() {
            long duration = System.currentTimeMillis() - this.inQueueSince;
            return Util.getTimeSpanString(duration);
        }

        @WithBridgeMethods(value={Future.class})
        public QueueTaskFuture<Executable> getFuture() {
            return this.future;
        }

        public Label getAssignedLabel() {
            for (LabelAssignmentAction laa : this.getActions(LabelAssignmentAction.class)) {
                Label l = laa.getAssignedLabel(this.task);
                if (l == null) continue;
                return l;
            }
            return this.task.getAssignedLabel();
        }

        @CheckForNull
        public Label getAssignedLabelFor(@Nonnull SubTask st) {
            for (LabelAssignmentAction laa : this.getActions(LabelAssignmentAction.class)) {
                Label l = laa.getAssignedLabel(st);
                if (l == null) continue;
                return l;
            }
            return st.getAssignedLabel();
        }

        public final List<Cause> getCauses() {
            CauseAction ca = this.getAction(CauseAction.class);
            if (ca != null) {
                return Collections.unmodifiableList(ca.getCauses());
            }
            return Collections.emptyList();
        }

        @Restricted(value={DoNotUse.class})
        public String getCausesDescription() {
            List<Cause> causes = this.getCauses();
            StringBuilder s = new StringBuilder();
            for (Cause c : causes) {
                s.append(c.getShortDescription()).append('\n');
            }
            return s.toString();
        }

        protected Item(Task task, List<Action> actions, long id, FutureImpl future) {
            this.task = task;
            this.id = id;
            this.future = future;
            this.inQueueSince = System.currentTimeMillis();
            for (Action action : actions) {
                this.addAction(action);
            }
        }

        protected Item(Task task, List<Action> actions, long id, FutureImpl future, long inQueueSince) {
            this.task = task;
            this.id = id;
            this.future = future;
            this.inQueueSince = inQueueSince;
            for (Action action : actions) {
                this.addAction(action);
            }
        }

        protected Item(Item item) {
            this(item.task, new ArrayList<Action>(item.getAllActions()), item.id, item.future, item.inQueueSince);
        }

        @Exported
        public String getUrl() {
            return "queue/item/" + this.id + '/';
        }

        @Exported
        public final String getWhy() {
            CauseOfBlockage cob = this.getCauseOfBlockage();
            return cob != null ? cob.getShortDescription() : null;
        }

        public abstract CauseOfBlockage getCauseOfBlockage();

        @Exported
        public String getParams() {
            StringBuilder s = new StringBuilder();
            for (ParametersAction pa : this.getActions(ParametersAction.class)) {
                for (ParameterValue p : pa.getParameters()) {
                    s.append('\n').append(p.getShortDescription());
                }
            }
            return s.toString();
        }

        public boolean hasCancelPermission() {
            return this.task.hasAbortPermission();
        }

        @Override
        public String getDisplayName() {
            return null;
        }

        @Override
        public String getSearchUrl() {
            return null;
        }

        @Deprecated
        @RequirePOST
        public HttpResponse doCancelQueue() throws IOException, ServletException {
            Jenkins.getInstance().getQueue().cancel(this);
            return HttpResponses.forwardToPreviousPage();
        }

        @Nonnull
        public Authentication authenticate() {
            for (QueueItemAuthenticator auth : QueueItemAuthenticatorProvider.authenticators()) {
                Authentication a = auth.authenticate(this);
                if (a == null) continue;
                return a;
            }
            return Tasks.getDefaultAuthenticationOf(this.task, this);
        }

        public Api getApi() {
            return new Api(this);
        }

        private Object readResolve() {
            this.future = new FutureImpl(this.task);
            return this;
        }

        public String toString() {
            return this.getClass().getName() + ':' + this.task + ':' + this.id;
        }

        abstract void enter(Queue var1);

        abstract boolean leave(Queue var1);

        boolean cancel(Queue q) {
            boolean r = this.leave(q);
            if (r) {
                this.future.setAsCancelled();
                LeftItem li = new LeftItem(this);
                li.enter(q);
            }
            return r;
        }
    }

    public static interface Executable
    extends Runnable {
        @Nonnull
        public SubTask getParent();

        @Override
        public void run() throws AsynchronousExecution;

        public long getEstimatedDuration();

        public String toString();
    }

    public static interface Task
    extends ModelObject,
    SubTask {
        public boolean isBuildBlocked();

        @Deprecated
        public String getWhyBlocked();

        public CauseOfBlockage getCauseOfBlockage();

        public String getName();

        public String getFullDisplayName();

        public void checkAbortPermission();

        public boolean hasAbortPermission();

        public String getUrl();

        public boolean isConcurrentBuild();

        public Collection<? extends SubTask> getSubTasks();

        @Nonnull
        public Authentication getDefaultAuthentication();

        @Nonnull
        public Authentication getDefaultAuthentication(Item var1);
    }

    public static interface NonBlockingTask
    extends Task {
    }

    public static interface FlyweightTask
    extends Task {
    }

    public static interface TransientTask
    extends Task {
    }

    static class State {
        public long counter;
        public List<Item> items = new ArrayList<Item>();

        State() {
        }
    }

    public class JobOffer
    extends MappingWorksheet.ExecutorSlot {
        public final Executor executor;
        private WorkUnit workUnit;

        private JobOffer(Executor executor) {
            this.executor = executor;
        }

        @Override
        protected void set(WorkUnit p) {
            assert (this.workUnit == null);
            this.workUnit = p;
            assert (this.executor.isParking());
            this.executor.start(this.workUnit);
        }

        @Override
        public Executor getExecutor() {
            return this.executor;
        }

        public boolean canTake(BuildableItem item) {
            Node node = this.getNode();
            if (node == null) {
                return false;
            }
            if (node.canTake(item) != null) {
                return false;
            }
            for (QueueTaskDispatcher d : QueueTaskDispatcher.all()) {
                if (d.canTake(node, item) == null) continue;
                return false;
            }
            return this.isAvailable();
        }

        @Override
        public boolean isAvailable() {
            return this.workUnit == null && !this.executor.getOwner().isOffline() && this.executor.getOwner().isAcceptingTasks();
        }

        @CheckForNull
        public Node getNode() {
            return this.executor.getOwner().getNode();
        }

        public boolean isNotExclusive() {
            return this.getNode().getMode() == Node.Mode.NORMAL;
        }

        public String toString() {
            return String.format("JobOffer[%s #%d]", this.executor.getOwner().getName(), this.executor.getNumber());
        }
    }
}

