/*
 * Decompiled with CFR 0.152.
 */
package hudson.node_monitors;

import hudson.Extension;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.node_monitors.AbstractAsyncNodeMonitorDescriptor;
import hudson.node_monitors.AbstractNodeMonitorDescriptor;
import hudson.node_monitors.Messages;
import hudson.node_monitors.MonitorOfflineCause;
import hudson.node_monitors.NodeMonitor;
import hudson.remoting.Callable;
import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import java.util.logging.Logger;
import jenkins.security.MasterToSlaveCallable;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

public class ResponseTimeMonitor
extends NodeMonitor {
    @Extension
    public static final AbstractNodeMonitorDescriptor<Data> DESCRIPTOR = new AbstractAsyncNodeMonitorDescriptor<Data>(){

        @Override
        protected Callable<Data, IOException> createCallable(Computer c) {
            return new Step1((Data)this.get(c));
        }

        @Override
        protected Map<Computer, Data> monitor() throws InterruptedException {
            Map<Computer, Data> base = super.monitor();
            for (Map.Entry e : base.entrySet()) {
                Computer c = e.getKey();
                Data d = (Data)e.getValue();
                if (d == null) {
                    d = new Data((Data)this.get(c), -1L);
                    e.setValue(d);
                }
                if (!d.hasTooManyTimeouts() || this.isIgnored()) continue;
                c.disconnect(d);
                LOGGER.warning(Messages.ResponseTimeMonitor_MarkedOffline(c.getName()));
            }
            return base;
        }

        @Override
        public String getDisplayName() {
            return Messages.ResponseTimeMonitor_DisplayName();
        }

        @Override
        public NodeMonitor newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            return new ResponseTimeMonitor();
        }
    };
    private static final long TIMEOUT = 5000L;
    private static final Logger LOGGER = Logger.getLogger(ResponseTimeMonitor.class.getName());

    @ExportedBean
    public static final class Data
    extends MonitorOfflineCause
    implements Serializable {
        private final long[] past5;
        private static final long serialVersionUID = 1L;

        private Data(Data old, long newDataPoint) {
            if (old == null) {
                this.past5 = new long[]{newDataPoint};
            } else {
                this.past5 = new long[Math.min(5, old.past5.length + 1)];
                int copyLen = this.past5.length - 1;
                System.arraycopy(old.past5, old.past5.length - copyLen, this.past5, 0, copyLen);
                this.past5[this.past5.length - 1] = newDataPoint;
            }
        }

        private int failureCount() {
            int cnt = 0;
            int i = this.past5.length - 1;
            while (i >= 0 && this.past5[i] < 0L) {
                --i;
                ++cnt;
            }
            return cnt;
        }

        @Exported
        public long getAverage() {
            long total = 0L;
            for (long l : this.past5) {
                if (l < 0L) {
                    total += 5000L;
                    continue;
                }
                total += l;
            }
            return total / (long)this.past5.length;
        }

        public boolean hasTooManyTimeouts() {
            return this.failureCount() >= 5;
        }

        public String toString() {
            int fc = this.failureCount();
            if (fc > 0) {
                return Messages.ResponseTimeMonitor_TimeOut(fc);
            }
            return this.getAverage() + "ms";
        }

        @Override
        public Class<? extends NodeMonitor> getTrigger() {
            return ResponseTimeMonitor.class;
        }
    }

    private static final class Step3
    implements Serializable {
        private final Data cur;
        private final long start;
        private static final long serialVersionUID = 1L;

        private Step3(Data cur, long start) {
            this.cur = cur;
            this.start = start;
        }

        private Object readResolve() {
            long end = System.currentTimeMillis();
            return new Data(this.cur, end - this.start);
        }
    }

    private static final class Step2
    extends MasterToSlaveCallable<Step3, IOException> {
        private final Data cur;
        private final long start = System.currentTimeMillis();
        private static final long serialVersionUID = 1L;

        public Step2(Data cur) {
            this.cur = cur;
        }

        public Step3 call() {
            return new Step3(this.cur, this.start);
        }
    }

    private static final class Step1
    extends MasterToSlaveCallable<Data, IOException> {
        private Data cur;
        private static final long serialVersionUID = 1L;

        private Step1(Data cur) {
            this.cur = cur;
        }

        public Data call() {
            return new Data(this.cur, 0L);
        }

        private Object writeReplace() {
            return new Step2(this.cur);
        }
    }
}

