/*
 * Decompiled with CFR 0.152.
 */
package hudson.os.solaris;

import com.sun.akuma.Daemon;
import com.sun.akuma.JavaVMArguments;
import hudson.Extension;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AdministrativeMonitor;
import hudson.model.TaskListener;
import hudson.os.SU;
import hudson.util.ForkOutputStream;
import hudson.util.HudsonIsRestarting;
import hudson.util.StreamTaskListener;
import hudson.util.jna.GNUCLibrary;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import jenkins.security.MasterToSlaveCallable;
import jenkins.util.SystemProperties;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.jvnet.libpam.impl.CLibrary;
import org.jvnet.solaris.libzfs.ACLBuilder;
import org.jvnet.solaris.libzfs.ErrorCode;
import org.jvnet.solaris.libzfs.LibZFS;
import org.jvnet.solaris.libzfs.ZFSException;
import org.jvnet.solaris.libzfs.ZFSFileSystem;
import org.kohsuke.stapler.HttpRedirect;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.HttpResponses;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.interceptor.RequirePOST;

public class ZFSInstaller
extends AdministrativeMonitor
implements Serializable {
    private static final long serialVersionUID = 1018007614648118323L;
    private final boolean active = this.shouldBeActive();
    private String prospectiveZfsFileSystemName;
    private static final Logger LOGGER = Logger.getLogger(ZFSInstaller.class.getName());
    public static boolean disabled = SystemProperties.getBoolean(ZFSInstaller.class.getName() + ".disabled");

    @Override
    public boolean isActivated() {
        return this.active;
    }

    public boolean isRoot() {
        return GNUCLibrary.LIBC.geteuid() == 0;
    }

    public String getProspectiveZfsFileSystemName() {
        return this.prospectiveZfsFileSystemName;
    }

    private boolean shouldBeActive() {
        if (!System.getProperty("os.name").equals("SunOS") || disabled) {
            return false;
        }
        try {
            LibZFS zfs = new LibZFS();
            List roots = zfs.roots();
            if (roots.isEmpty()) {
                return false;
            }
            ZFSFileSystem hudsonZfs = zfs.getFileSystemByMountPoint(Jenkins.getInstance().getRootDir());
            if (hudsonZfs != null) {
                return false;
            }
            ZFSFileSystem pool = (ZFSFileSystem)roots.get(0);
            this.prospectiveZfsFileSystemName = ZFSInstaller.computeHudsonFileSystemName(zfs, pool);
            return true;
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Failed to detect whether Hudson is on ZFS", e);
            return false;
        }
        catch (LinkageError e) {
            LOGGER.info("No ZFS available. If you believe this is an error, increase the logging level to get the stack trace");
            LOGGER.log(Level.FINE, "Stack trace of failed ZFS load", e);
            return false;
        }
    }

    @RequirePOST
    public HttpResponse doAct(StaplerRequest req) throws ServletException, IOException {
        Jenkins.getInstance().checkPermission(Jenkins.ADMINISTER);
        if (req.hasParameter("n")) {
            this.disable(true);
            return HttpResponses.redirectViaContextPath((String)"/manage");
        }
        return new HttpRedirect("confirm");
    }

    private String createZfsFileSystem(final TaskListener listener, String rootUsername, String rootPassword) throws IOException, InterruptedException, ZFSException {
        final int uid = GNUCLibrary.LIBC.geteuid();
        final int gid = GNUCLibrary.LIBC.getegid();
        CLibrary.passwd pwd = GNUCLibrary.LIBC.getpwuid(uid);
        if (pwd == null) {
            throw new IOException("Failed to obtain the current user information for " + uid);
        }
        final String userName = pwd.pw_name;
        final File home = Jenkins.getInstance().getRootDir();
        return SU.execute(listener, rootUsername, rootPassword, new MasterToSlaveCallable<String, IOException>(){
            private static final long serialVersionUID = 7731167233498214301L;

            public String call() throws IOException {
                PrintStream out = listener.getLogger();
                LibZFS zfs = new LibZFS();
                ZFSFileSystem existing = zfs.getFileSystemByMountPoint(home);
                if (existing != null) {
                    out.println(home + " is already on ZFS. Doing nothing");
                    return existing.getName();
                }
                String name = ZFSInstaller.computeHudsonFileSystemName(zfs, (ZFSFileSystem)zfs.roots().get(0));
                out.println("Creating " + name);
                ZFSFileSystem hudson = (ZFSFileSystem)zfs.create(name, ZFSFileSystem.class);
                File dir = Util.createTempDir();
                hudson.setMountPoint(dir);
                hudson.mount();
                if (GNUCLibrary.LIBC.chown(dir.getPath(), uid, gid) != 0) {
                    throw new IOException("Failed to chown " + dir);
                }
                hudson.unmount();
                try {
                    hudson.setProperty("hudson:managed-by", "hudson");
                    ACLBuilder acl = new ACLBuilder();
                    acl.user(userName).withEverything();
                    hudson.allow(acl);
                }
                catch (ZFSException e) {
                    try {
                        hudson.destory();
                    }
                    catch (Exception _) {
                        // empty catch block
                    }
                    throw e;
                }
                return hudson.getName();
            }
        });
    }

    @RequirePOST
    public void doStart(StaplerRequest req, StaplerResponse rsp, @QueryParameter String username, @QueryParameter String password) throws ServletException, IOException {
        String datasetName;
        Jenkins hudson = Jenkins.getInstance();
        hudson.checkPermission(Jenkins.ADMINISTER);
        ByteArrayOutputStream log = new ByteArrayOutputStream();
        StreamTaskListener listener = new StreamTaskListener((OutputStream)log);
        try {
            datasetName = this.createZfsFileSystem(listener, username, password);
        }
        catch (Exception e) {
            ZFSException ze;
            e.printStackTrace(listener.error(e.getMessage()));
            if (e instanceof ZFSException && (ze = (ZFSException)((Object)e)).getCode() == ErrorCode.EZFS_PERM) {
                req.setAttribute("message", (Object)log.toString());
                rsp.forward((Object)this, "askRootPassword", req);
                return;
            }
            req.setAttribute("pre", (Object)true);
            this.sendError(log.toString(), req, rsp);
            return;
        }
        hudson.servletContext.setAttribute("app", (Object)new HudsonIsRestarting());
        rsp.sendRedirect2(req.getContextPath() + "/manage");
        new Thread("restart thread"){

            @Override
            public void run() {
                try {
                    Thread.sleep(5000L);
                    int sz = GNUCLibrary.LIBC.getdtablesize();
                    for (int i = 3; i < sz; ++i) {
                        int flags = GNUCLibrary.LIBC.fcntl(i, 1);
                        if (flags < 0) continue;
                        GNUCLibrary.LIBC.fcntl(i, 2, flags | 1);
                    }
                    JavaVMArguments args = JavaVMArguments.current();
                    args.setSystemProperty(ZFSInstaller.class.getName() + ".migrate", datasetName);
                    Daemon.selfExec((JavaVMArguments)args);
                }
                catch (IOException | InterruptedException e) {
                    LOGGER.log(Level.SEVERE, "Restart failed", e);
                }
            }
        }.start();
    }

    @Extension
    public static AdministrativeMonitor init() {
        String migrationTarget = SystemProperties.getString(ZFSInstaller.class.getName() + ".migrate");
        if (migrationTarget != null) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            StreamTaskListener listener = new StreamTaskListener(new ForkOutputStream(System.out, (OutputStream)out));
            try {
                if (ZFSInstaller.migrate(listener, migrationTarget)) {
                    return new MigrationCompleteNotice();
                }
            }
            catch (Exception e) {
                e.printStackTrace(listener.error("Migration failed"));
            }
            return new MigrationFailedNotice(out);
        }
        ZFSInstaller zi = new ZFSInstaller();
        if (zi.isActivated()) {
            return zi;
        }
        return null;
    }

    private static boolean migrate(TaskListener listener, String target) throws IOException, InterruptedException {
        PrintStream out = listener.getLogger();
        LibZFS zfs = new LibZFS();
        File home = Jenkins.getInstance().getRootDir();
        ZFSFileSystem existing = zfs.getFileSystemByMountPoint(home);
        if (existing != null) {
            out.println(home + " is already on ZFS. Doing nothing");
            return true;
        }
        File tmpDir = Util.createTempDir();
        out.println("Opening " + target);
        ZFSFileSystem hudson = (ZFSFileSystem)zfs.open(target, ZFSFileSystem.class);
        hudson.setMountPoint(tmpDir);
        hudson.setProperty("hudson:managed-by", "hudson");
        hudson.mount();
        out.println("Copying all existing data files");
        if (ZFSInstaller.system(home, listener, "/usr/bin/cp", "-pR", ".", tmpDir.getAbsolutePath()) != 0) {
            out.println("Failed to copy " + home + " to " + tmpDir);
            return false;
        }
        out.println("Unmounting " + target);
        hudson.unmount(1024);
        File backup = new File(home.getPath() + ".backup");
        out.println("Moving " + home + " to " + backup);
        if (backup.exists()) {
            Util.deleteRecursive(backup);
        }
        if (!home.renameTo(backup)) {
            out.println("Failed to move your current data " + home + " out of the way");
        }
        out.println("Creating a new mount point at " + home);
        if (!home.mkdir()) {
            throw new IOException("Failed to create mount point " + home);
        }
        out.println("Mounting " + target);
        hudson.setMountPoint(home);
        hudson.mount();
        out.println("Sharing " + target);
        try {
            hudson.setProperty("sharesmb", "on");
            hudson.setProperty("sharenfs", "on");
            hudson.share();
        }
        catch (ZFSException e) {
            listener.error("Failed to share the file systems: " + e.getCode());
        }
        out.println("Deleting " + backup);
        if (ZFSInstaller.system(new File("/"), listener, "/usr/bin/rm", "-rf", backup.getAbsolutePath()) != 0) {
            out.println("Failed to delete " + backup.getAbsolutePath());
            return false;
        }
        out.println("Migration completed");
        return true;
    }

    private static int system(File pwd, TaskListener listener, String ... args) throws IOException, InterruptedException {
        return new Launcher.LocalLauncher(listener).launch().cmds(args).stdout(System.out).pwd(pwd).join();
    }

    private static String computeHudsonFileSystemName(LibZFS zfs, ZFSFileSystem top) {
        if (!zfs.exists(top.getName() + "/hudson")) {
            return top.getName() + "/hudson";
        }
        int i = 2;
        String name;
        while (zfs.exists(name = top.getName() + "/hudson" + i)) {
            ++i;
        }
        return name;
    }

    public static final class MigrationFailedNotice
    extends AdministrativeMonitor {
        ByteArrayOutputStream record;

        MigrationFailedNotice(ByteArrayOutputStream record) {
            this.record = record;
        }

        @Override
        public boolean isActivated() {
            return true;
        }

        public String getLog() {
            return this.record.toString();
        }
    }

    public static final class MigrationCompleteNotice
    extends AdministrativeMonitor {
        @Override
        public boolean isActivated() {
            return true;
        }
    }
}

