/*
 * Decompiled with CFR 0.152.
 */
package hudson.slaves;

import hudson.FilePath;
import hudson.Launcher;
import hudson.Proc;
import hudson.model.Computer;
import hudson.model.TaskListener;
import hudson.remoting.Channel;
import hudson.remoting.ChannelBuilder;
import hudson.remoting.CommandTransport;
import hudson.remoting.Launcher;
import hudson.remoting.SocketChannelStream;
import hudson.util.ClasspathBuilder;
import hudson.util.JVMBuilder;
import hudson.util.StreamCopyThread;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOError;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.security.ChannelConfigurator;

public class Channels {
    private static final Logger LOGGER = Logger.getLogger(Channels.class.getName());

    @Deprecated
    public static Channel forProcess(String name, ExecutorService execService, InputStream in, OutputStream out, Proc proc) throws IOException {
        return Channels.forProcess(name, execService, in, out, null, proc);
    }

    public static Channel forProcess(String name, ExecutorService execService, InputStream in, OutputStream out, OutputStream header, final Proc proc) throws IOException {
        ChannelBuilder cb = new ChannelBuilder(name, execService){

            public Channel build(CommandTransport transport) throws IOException {
                return new Channel(this, transport){

                    public synchronized void terminate(IOException e) {
                        super.terminate(e);
                        try {
                            proc.kill();
                        }
                        catch (IOException x) {
                            LOGGER.log(Level.INFO, "Failed to terminate the severed connection", x);
                        }
                        catch (InterruptedException x) {
                            Thread.currentThread().interrupt();
                        }
                    }

                    public synchronized void join() throws InterruptedException {
                        super.join();
                        try {
                            proc.join();
                        }
                        catch (IOException e) {
                            throw new IOError(e);
                        }
                    }
                };
            }
        };
        cb.withHeaderStream(header);
        for (ChannelConfigurator cc : ChannelConfigurator.all()) {
            cc.onChannelBuilding(cb, null);
        }
        return cb.build(in, out);
    }

    public static Channel forProcess(String name, ExecutorService execService, final Process proc, OutputStream header) throws IOException {
        final StreamCopyThread thread = new StreamCopyThread(name + " stderr", proc.getErrorStream(), header);
        thread.start();
        ChannelBuilder cb = new ChannelBuilder(name, execService){

            public Channel build(CommandTransport transport) throws IOException {
                return new Channel(this, transport){

                    public synchronized void terminate(IOException e) {
                        super.terminate(e);
                        proc.destroy();
                    }

                    public synchronized void join() throws InterruptedException {
                        super.join();
                        proc.waitFor();
                        thread.join();
                    }
                };
            }
        };
        cb.withHeaderStream(header);
        for (ChannelConfigurator cc : ChannelConfigurator.all()) {
            cc.onChannelBuilding(cb, null);
        }
        return cb.build(proc.getInputStream(), proc.getOutputStream());
    }

    public static Channel newJVM(String displayName, TaskListener listener, FilePath workDir, ClasspathBuilder classpath, Map<String, String> systemProperties) throws IOException {
        JVMBuilder vmb = new JVMBuilder();
        vmb.systemProperties(systemProperties);
        return Channels.newJVM(displayName, listener, vmb, workDir, classpath);
    }

    public static Channel newJVM(String displayName, TaskListener listener, JVMBuilder vmb, FilePath workDir, ClasspathBuilder classpath) throws IOException {
        ServerSocket serverSocket = new ServerSocket();
        serverSocket.bind(new InetSocketAddress("localhost", 0));
        serverSocket.setSoTimeout(10000);
        vmb.classpath().addJarOf(Channel.class);
        vmb.mainClass(Launcher.class);
        if (classpath != null) {
            vmb.args().add("-cp").add(classpath);
        }
        vmb.args().add("-connectTo", "localhost:" + serverSocket.getLocalPort());
        listener.getLogger().println("Starting " + displayName);
        Proc p = vmb.launch(new Launcher.LocalLauncher(listener)).stdout(listener).pwd(workDir).start();
        Socket s = serverSocket.accept();
        serverSocket.close();
        return Channels.forProcess("Channel to " + displayName, Computer.threadPoolForRemoting, new BufferedInputStream(SocketChannelStream.in((Socket)s)), new BufferedOutputStream(SocketChannelStream.out((Socket)s)), null, p);
    }
}

