/*
 * Decompiled with CFR 0.152.
 */
package hudson.slaves;

import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.Util;
import hudson.model.Descriptor;
import hudson.model.Slave;
import hudson.model.TaskListener;
import hudson.remoting.Channel;
import hudson.slaves.ComputerLauncher;
import hudson.slaves.Messages;
import hudson.slaves.SlaveComputer;
import hudson.util.FormValidation;
import hudson.util.ProcessTree;
import hudson.util.StreamCopyThread;
import java.io.IOException;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class CommandLauncher
extends ComputerLauncher {
    private final String agentCommand;
    private final EnvVars env;
    private static final Logger LOGGER = Logger.getLogger(CommandLauncher.class.getName());

    @DataBoundConstructor
    public CommandLauncher(String command) {
        this(command, null);
    }

    public CommandLauncher(String command, EnvVars env) {
        this.agentCommand = command;
        this.env = env;
    }

    public String getCommand() {
        return this.agentCommand;
    }

    private static String getTimestamp() {
        return String.format("[%1$tD %1$tT]", new Date());
    }

    @Override
    public void launch(SlaveComputer computer, final TaskListener listener) {
        block11: {
            EnvVars _cookie = null;
            Process _proc = null;
            try {
                Slave node = computer.getNode();
                if (node == null) {
                    throw new AbortException("Cannot launch commands on deleted nodes");
                }
                listener.getLogger().println(hudson.model.Messages.Slave_Launching(CommandLauncher.getTimestamp()));
                if (this.getCommand().trim().length() == 0) {
                    listener.getLogger().println(Messages.CommandLauncher_NoLaunchCommand());
                    return;
                }
                listener.getLogger().println("$ " + this.getCommand());
                ProcessBuilder pb = new ProcessBuilder(Util.tokenize(this.getCommand()));
                final EnvVars cookie = _cookie = EnvVars.createCookie();
                pb.environment().putAll(cookie);
                pb.environment().put("WORKSPACE", StringUtils.defaultString((String)computer.getAbsoluteRemoteFs(), (String)node.getRemoteFS()));
                String rootUrl = Jenkins.getInstance().getRootUrl();
                if (rootUrl != null) {
                    pb.environment().put("HUDSON_URL", rootUrl);
                    pb.environment().put("JENKINS_URL", rootUrl);
                    pb.environment().put("SLAVEJAR_URL", rootUrl + "/jnlpJars/slave.jar");
                }
                if (this.env != null) {
                    pb.environment().putAll(this.env);
                }
                final Process proc = _proc = pb.start();
                new StreamCopyThread("stderr copier for remote agent on " + computer.getDisplayName(), proc.getErrorStream(), listener.getLogger()).start();
                computer.setChannel(proc.getInputStream(), proc.getOutputStream(), listener.getLogger(), new Channel.Listener(){

                    public void onClosed(Channel channel, IOException cause) {
                        CommandLauncher.reportProcessTerminated(proc, listener);
                        try {
                            ProcessTree.get().killAll(proc, cookie);
                        }
                        catch (InterruptedException e) {
                            LOGGER.log(Level.INFO, "interrupted", e);
                        }
                    }
                });
                LOGGER.info("agent launched for " + computer.getDisplayName());
            }
            catch (InterruptedException e) {
                e.printStackTrace(listener.error(Messages.ComputerLauncher_abortedLaunch()));
            }
            catch (RuntimeException e) {
                e.printStackTrace(listener.error(Messages.ComputerLauncher_unexpectedError()));
            }
            catch (Error e) {
                e.printStackTrace(listener.error(Messages.ComputerLauncher_unexpectedError()));
            }
            catch (IOException e) {
                Util.displayIOException(e, listener);
                String msg = Util.getWin32ErrorMessage(e);
                msg = msg == null ? "" : " : " + msg;
                msg = hudson.model.Messages.Slave_UnableToLaunch(computer.getDisplayName(), msg);
                LOGGER.log(Level.SEVERE, msg, e);
                e.printStackTrace(listener.error(msg));
                if (_proc == null) break block11;
                CommandLauncher.reportProcessTerminated(_proc, listener);
                try {
                    ProcessTree.get().killAll(_proc, _cookie);
                }
                catch (InterruptedException x) {
                    x.printStackTrace(listener.error(Messages.ComputerLauncher_abortedLaunch()));
                }
            }
        }
    }

    private static void reportProcessTerminated(Process proc, TaskListener listener) {
        try {
            int exitCode = proc.exitValue();
            listener.error("Process terminated with exit code " + exitCode);
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            // empty catch block
        }
    }

    @Extension
    @Symbol(value={"command"})
    public static class DescriptorImpl
    extends Descriptor<ComputerLauncher> {
        @Override
        public String getDisplayName() {
            return Messages.CommandLauncher_displayName();
        }

        public FormValidation doCheckCommand(@QueryParameter String value) {
            if (Util.fixEmptyAndTrim(value) == null) {
                return FormValidation.error(Messages.CommandLauncher_NoLaunchCommand());
            }
            return FormValidation.ok();
        }
    }
}

