/*
 * Decompiled with CFR 0.152.
 */
package jenkins.security;

import hudson.FilePath;
import hudson.Util;
import hudson.util.Secret;
import hudson.util.TextFile;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.SecretKey;
import jenkins.model.Jenkins;
import jenkins.security.ConfidentialKey;
import jenkins.security.ConfidentialStore;
import org.apache.commons.io.IOUtils;

public class DefaultConfidentialStore
extends ConfidentialStore {
    private final SecureRandom sr = new SecureRandom();
    private final File rootDir;
    private final SecretKey masterKey;
    private static final byte[] MAGIC = "::::MAGIC::::".getBytes();

    public DefaultConfidentialStore() throws IOException, InterruptedException {
        this(new File(Jenkins.getInstance().getRootDir(), "secrets"));
    }

    public DefaultConfidentialStore(File rootDir) throws IOException, InterruptedException {
        TextFile masterSecret;
        this.rootDir = rootDir;
        if (rootDir.mkdirs()) {
            new FilePath(rootDir).chmod(448);
        }
        if (!(masterSecret = new TextFile(new File(rootDir, "master.key"))).exists()) {
            masterSecret.write(Util.toHexString(this.randomBytes(128)));
        }
        this.masterKey = Util.toAes128Key(masterSecret.readTrim());
    }

    @Override
    protected void store(ConfidentialKey key, byte[] payload) throws IOException {
        CipherOutputStream cos = null;
        FileOutputStream fos = null;
        try {
            Cipher sym = Secret.getCipher("AES");
            sym.init(1, this.masterKey);
            fos = new FileOutputStream(this.getFileFor(key));
            cos = new CipherOutputStream(fos, sym);
            cos.write(payload);
            cos.write(MAGIC);
        }
        catch (GeneralSecurityException e) {
            try {
                throw new IOException("Failed to persist the key: " + key.getId(), e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(cos);
                IOUtils.closeQuietly(fos);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)cos);
        IOUtils.closeQuietly((OutputStream)fos);
    }

    @Override
    protected byte[] load(ConfidentialKey key) throws IOException {
        byte[] byArray;
        CipherInputStream cis = null;
        FileInputStream fis = null;
        try {
            File f = this.getFileFor(key);
            if (!f.exists()) {
                byte[] byArray2 = null;
                return byArray2;
            }
            Cipher sym = Secret.getCipher("AES");
            sym.init(2, this.masterKey);
            fis = new FileInputStream(f);
            cis = new CipherInputStream(fis, sym);
            byte[] bytes = IOUtils.toByteArray((InputStream)cis);
            byArray = this.verifyMagic(bytes);
            IOUtils.closeQuietly((InputStream)cis);
        }
        catch (GeneralSecurityException e) {
            throw new IOException("Failed to load the key: " + key.getId(), e);
        }
        catch (IOException x) {
            if (x.getCause() instanceof BadPaddingException) {
                byte[] byArray3 = null;
                return byArray3;
            }
            throw x;
        }
        finally {
            IOUtils.closeQuietly(cis);
            IOUtils.closeQuietly(fis);
        }
        IOUtils.closeQuietly((InputStream)fis);
        return byArray;
    }

    private byte[] verifyMagic(byte[] payload) {
        int payloadLen = payload.length - MAGIC.length;
        if (payloadLen < 0) {
            return null;
        }
        for (int i = 0; i < MAGIC.length; ++i) {
            if (payload[payloadLen + i] == MAGIC[i]) continue;
            return null;
        }
        byte[] truncated = new byte[payloadLen];
        System.arraycopy(payload, 0, truncated, 0, truncated.length);
        return truncated;
    }

    private File getFileFor(ConfidentialKey key) {
        return new File(this.rootDir, key.getId());
    }

    @Override
    public byte[] randomBytes(int size) {
        byte[] random = new byte[size];
        this.sr.nextBytes(random);
        return random;
    }
}

