/*
 * Decompiled with CFR 0.152.
 */
package jenkins.security.s2m;

import hudson.Extension;
import hudson.remoting.ChannelBuilder;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.ReflectiveFilePathFilter;
import jenkins.security.ChannelConfigurator;
import jenkins.util.SystemProperties;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;

@Extension
@Restricted(value={DoNotUse.class})
public class DefaultFilePathFilter
extends ChannelConfigurator {
    public static boolean BYPASS = SystemProperties.getBoolean(DefaultFilePathFilter.class.getName() + ".allow");
    private static final Logger LOGGER = Logger.getLogger(DefaultFilePathFilter.class.getName());

    @Override
    public void onChannelBuilding(ChannelBuilder builder, Object context) {
        new ReflectiveFilePathFilter(){

            @Override
            protected boolean op(String op, File f) throws SecurityException {
                if (BYPASS) {
                    LOGGER.log(Level.FINE, "agent allowed to {0} {1}", new Object[]{op, f});
                    return true;
                }
                return false;
            }
        }.installTo(builder, 200.0);
    }
}

