/*
 * Decompiled with CFR 0.152.
 */
package jenkins.util.xml;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import jenkins.util.SystemProperties;
import jenkins.util.xml.RestrictiveEntityResolver;
import org.apache.commons.io.IOUtils;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

@Restricted(value={NoExternalUse.class})
public final class XMLUtils {
    private static final Logger LOGGER = LogManager.getLogManager().getLogger(XMLUtils.class.getName());
    private static final String DISABLED_PROPERTY_NAME = XMLUtils.class.getName() + ".disableXXEPrevention";
    private static final String FEATURE_HTTP_XML_ORG_SAX_FEATURES_EXTERNAL_GENERAL_ENTITIES = "http://xml.org/sax/features/external-general-entities";
    private static final String FEATURE_HTTP_XML_ORG_SAX_FEATURES_EXTERNAL_PARAMETER_ENTITIES = "http://xml.org/sax/features/external-parameter-entities";

    public static void safeTransform(@Nonnull Source source, @Nonnull Result out) throws TransformerException, SAXException {
        InputSource src = SAXSource.sourceToInputSource(source);
        if (src != null) {
            SAXTransformerFactory stFactory = (SAXTransformerFactory)TransformerFactory.newInstance();
            stFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            XMLReader xmlReader = XMLReaderFactory.createXMLReader();
            try {
                xmlReader.setFeature(FEATURE_HTTP_XML_ORG_SAX_FEATURES_EXTERNAL_GENERAL_ENTITIES, false);
            }
            catch (SAXException ignored) {
                // empty catch block
            }
            try {
                xmlReader.setFeature(FEATURE_HTTP_XML_ORG_SAX_FEATURES_EXTERNAL_PARAMETER_ENTITIES, false);
            }
            catch (SAXException ignored) {
                // empty catch block
            }
            xmlReader.setEntityResolver(RestrictiveEntityResolver.INSTANCE);
            SAXSource saxSource = new SAXSource(xmlReader, src);
            XMLUtils._transform(saxSource, out);
        } else if (SystemProperties.getBoolean(DISABLED_PROPERTY_NAME)) {
            LOGGER.log(Level.WARNING, "XML external entity (XXE) prevention has been disabled by the system property {0}=true Your system may be vulnerable to XXE attacks.", DISABLED_PROPERTY_NAME);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Caller stack trace: ", new Exception("XXE Prevention caller history"));
            }
            XMLUtils._transform(source, out);
        } else {
            throw new TransformerException("Could not convert source of type " + source.getClass() + " and " + "XXEPrevention is enabled.");
        }
    }

    @Nonnull
    public static Document parse(@Nonnull Reader stream) throws SAXException, IOException {
        DocumentBuilder docBuilder;
        try {
            docBuilder = XMLUtils.newDocumentBuilderFactory().newDocumentBuilder();
            docBuilder.setEntityResolver(RestrictiveEntityResolver.INSTANCE);
        }
        catch (ParserConfigurationException e) {
            throw new IllegalStateException("Unexpected error creating DocumentBuilder.", e);
        }
        return docBuilder.parse(new InputSource(stream));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static Document parse(@Nonnull File file, @Nonnull String encoding) throws SAXException, IOException {
        if (!file.exists() || !file.isFile()) {
            throw new IllegalArgumentException(String.format("File %s does not exist or is not a 'normal' file.", file.getAbsolutePath()));
        }
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            Document document;
            InputStreamReader fileReader = new InputStreamReader((InputStream)fileInputStream, encoding);
            try {
                document = XMLUtils.parse(fileReader);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly((Reader)fileReader);
                throw throwable;
            }
            IOUtils.closeQuietly((Reader)fileReader);
            return document;
        }
        finally {
            IOUtils.closeQuietly((InputStream)fileInputStream);
        }
    }

    @Nonnull
    public static String getValue(@Nonnull String xpath, @Nonnull File file) throws IOException, SAXException, XPathExpressionException {
        return XMLUtils.getValue(xpath, file, Charset.defaultCharset().toString());
    }

    @Nonnull
    public static String getValue(@Nonnull String xpath, @Nonnull File file, @Nonnull String fileDataEncoding) throws IOException, SAXException, XPathExpressionException {
        Document document = XMLUtils.parse(file, fileDataEncoding);
        return XMLUtils.getValue(xpath, document);
    }

    public static String getValue(String xpath, Document document) throws XPathExpressionException {
        XPath xPathProcessor = XPathFactory.newInstance().newXPath();
        return xPathProcessor.compile(xpath).evaluate(document);
    }

    private static void _transform(Source source, Result out) throws TransformerException {
        TransformerFactory factory = TransformerFactory.newInstance();
        factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        Transformer t = factory.newTransformer();
        t.transform(source, out);
    }

    private static DocumentBuilderFactory newDocumentBuilderFactory() {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setXIncludeAware(false);
        documentBuilderFactory.setExpandEntityReferences(false);
        XMLUtils.setDocumentBuilderFactoryFeature(documentBuilderFactory, "http://javax.xml.XMLConstants/feature/secure-processing", true);
        XMLUtils.setDocumentBuilderFactoryFeature(documentBuilderFactory, FEATURE_HTTP_XML_ORG_SAX_FEATURES_EXTERNAL_GENERAL_ENTITIES, false);
        XMLUtils.setDocumentBuilderFactoryFeature(documentBuilderFactory, FEATURE_HTTP_XML_ORG_SAX_FEATURES_EXTERNAL_PARAMETER_ENTITIES, false);
        XMLUtils.setDocumentBuilderFactoryFeature(documentBuilderFactory, "http://apache.org/xml/features/disallow-doctype-decl", true);
        return documentBuilderFactory;
    }

    private static void setDocumentBuilderFactoryFeature(DocumentBuilderFactory documentBuilderFactory, String feature, boolean state) {
        try {
            documentBuilderFactory.setFeature(feature, state);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

