/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit;

import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.htmlunit.cssparser.parser.CSSErrorHandler;
import org.htmlunit.cssparser.parser.CSSParseException;

public class DefaultCssErrorHandler
implements CSSErrorHandler,
Serializable {
    private static final Log LOG = LogFactory.getLog(DefaultCssErrorHandler.class);

    @Override
    public void error(CSSParseException exception) {
        if (LOG.isWarnEnabled()) {
            LOG.warn((Object)("CSS error: " + DefaultCssErrorHandler.buildMessage(exception)));
        }
    }

    @Override
    public void fatalError(CSSParseException exception) {
        if (LOG.isWarnEnabled()) {
            LOG.warn((Object)("CSS fatal error: " + DefaultCssErrorHandler.buildMessage(exception)));
        }
    }

    @Override
    public void warning(CSSParseException exception) {
        if (LOG.isWarnEnabled()) {
            LOG.warn((Object)("CSS warning: " + DefaultCssErrorHandler.buildMessage(exception)));
        }
    }

    private static String buildMessage(CSSParseException exception) {
        String uri = exception.getURI();
        int line = exception.getLineNumber();
        int col = exception.getColumnNumber();
        if (null == uri) {
            return "[" + line + ":" + col + "] " + exception.getMessage();
        }
        return "'" + uri + "' [" + line + ":" + col + "] " + exception.getMessage();
    }
}

