/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.css;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.htmlunit.BrowserVersion;
import org.htmlunit.BrowserVersionFeatures;
import org.htmlunit.WebWindow;
import org.htmlunit.css.AbstractCssStyleDeclaration;
import org.htmlunit.css.CssPixelValueConverter;
import org.htmlunit.css.ElementCssStyleDeclaration;
import org.htmlunit.css.StyleAttributes;
import org.htmlunit.css.StyleElement;
import org.htmlunit.cssparser.dom.AbstractCSSRuleImpl;
import org.htmlunit.cssparser.dom.CSSStyleDeclarationImpl;
import org.htmlunit.cssparser.dom.Property;
import org.htmlunit.cssparser.parser.selector.Selector;
import org.htmlunit.cssparser.parser.selector.SelectorSpecificity;
import org.htmlunit.html.DomElement;
import org.htmlunit.html.DomNode;
import org.htmlunit.html.HtmlBody;
import org.htmlunit.html.HtmlElement;
import org.htmlunit.javascript.host.Element;
import org.htmlunit.util.StringUtils;

public class ComputedCssStyleDeclaration
extends AbstractCssStyleDeclaration {
    private static final Set<StyleAttributes.Definition> INHERITABLE_DEFINITIONS = EnumSet.of(StyleAttributes.Definition.AZIMUTH, new StyleAttributes.Definition[]{StyleAttributes.Definition.BORDER_COLLAPSE, StyleAttributes.Definition.BORDER_SPACING, StyleAttributes.Definition.CAPTION_SIDE, StyleAttributes.Definition.COLOR, StyleAttributes.Definition.CURSOR, StyleAttributes.Definition.DIRECTION, StyleAttributes.Definition.ELEVATION, StyleAttributes.Definition.EMPTY_CELLS, StyleAttributes.Definition.FONT_FAMILY, StyleAttributes.Definition.FONT_SIZE, StyleAttributes.Definition.FONT_STYLE, StyleAttributes.Definition.FONT_VARIANT, StyleAttributes.Definition.FONT_WEIGHT, StyleAttributes.Definition.FONT, StyleAttributes.Definition.LETTER_SPACING, StyleAttributes.Definition.LINE_HEIGHT, StyleAttributes.Definition.LIST_STYLE_IMAGE, StyleAttributes.Definition.LIST_STYLE_POSITION, StyleAttributes.Definition.LIST_STYLE_TYPE, StyleAttributes.Definition.LIST_STYLE, StyleAttributes.Definition.ORPHANS, StyleAttributes.Definition.PITCH_RANGE, StyleAttributes.Definition.PITCH, StyleAttributes.Definition.QUOTES, StyleAttributes.Definition.RICHNESS, StyleAttributes.Definition.SPEAK_HEADER, StyleAttributes.Definition.SPEAK_NUMERAL, StyleAttributes.Definition.SPEAK_PUNCTUATION, StyleAttributes.Definition.SPEAK, StyleAttributes.Definition.SPEECH_RATE, StyleAttributes.Definition.STRESS, StyleAttributes.Definition.TEXT_ALIGN, StyleAttributes.Definition.TEXT_INDENT, StyleAttributes.Definition.TEXT_TRANSFORM, StyleAttributes.Definition.VISIBILITY, StyleAttributes.Definition.VOICE_FAMILY, StyleAttributes.Definition.VOLUME, StyleAttributes.Definition.WHITE_SPACE, StyleAttributes.Definition.WIDOWS, StyleAttributes.Definition.WORD_SPACING});
    public static final String EMPTY_FINAL = new String("");
    private Integer width_;
    private Integer height_;
    private Integer height2_;
    private Integer paddingHorizontal_;
    private Integer paddingVertical_;
    private Integer borderHorizontal_;
    private Integer borderVertical_;
    private Integer top_;
    private final SortedMap<String, StyleElement> localModifications_ = new TreeMap<String, StyleElement>();
    private ElementCssStyleDeclaration elementStyleDeclaration_;

    public ComputedCssStyleDeclaration(ElementCssStyleDeclaration styleDeclaration) {
        this.elementStyleDeclaration_ = styleDeclaration;
        this.getDomElementOrNull().setDefaults(this);
    }

    @Override
    public String getStylePriority(String name) {
        return this.elementStyleDeclaration_.getStylePriority(name);
    }

    @Override
    public String getCssText() {
        return this.elementStyleDeclaration_.getCssText();
    }

    @Override
    public String getStyleAttribute(String name) {
        StyleElement element = this.getStyleElement(name);
        if (element != null && element.getValue() != null) {
            String value = element.getValue();
            if (!"content".equals(name) && !value.contains("url")) {
                return StringUtils.toRootLowerCaseWithCache(value);
            }
            return value;
        }
        return "";
    }

    @Override
    public String getStyleAttribute(StyleAttributes.Definition definition, boolean getDefaultValueIfEmpty) {
        BrowserVersion browserVersion = this.getDomElementOrNull().getPage().getWebClient().getBrowserVersion();
        boolean feature = browserVersion.hasFeature(BrowserVersionFeatures.CSS_STYLE_PROP_DISCONNECTED_IS_EMPTY);
        boolean isDefInheritable = INHERITABLE_DEFINITIONS.contains((Object)definition);
        ComputedCssStyleDeclaration[] queue = new ComputedCssStyleDeclaration[]{this};
        String value = null;
        while (queue[0] != null) {
            value = ComputedCssStyleDeclaration.getStyleAttributeWorker(definition, getDefaultValueIfEmpty, browserVersion, feature, isDefInheritable, queue);
        }
        return value;
    }

    private static String getStyleAttributeWorker(StyleAttributes.Definition definition, boolean getDefaultValueIfEmpty, BrowserVersion browserVersion, boolean feature, boolean isDefInheritable, ComputedCssStyleDeclaration[] queue) {
        ComputedCssStyleDeclaration decl = queue[0];
        queue[0] = null;
        DomElement domElem = decl.getDomElementOrNull();
        if (!domElem.isAttachedToPage() && feature) {
            return EMPTY_FINAL;
        }
        String value = decl.getStyleAttribute(definition.getAttributeName());
        if (value.isEmpty()) {
            DomNode parent = domElem.getParentNode();
            if (isDefInheritable && parent instanceof DomElement) {
                WebWindow window = domElem.getPage().getEnclosingWindow();
                queue[0] = window.getComputedStyle((DomElement)parent, null);
            } else if (getDefaultValueIfEmpty) {
                value = definition.getDefaultComputedValue(browserVersion);
            }
        }
        return value;
    }

    @Override
    public void setCssText(String value) {
    }

    @Override
    public void setStyleAttribute(String name, String newValue, String important) {
    }

    @Override
    public String removeStyleAttribute(String name) {
        return null;
    }

    @Override
    public int getLength() {
        return this.elementStyleDeclaration_.getLength();
    }

    @Override
    public Object item(int index) {
        return this.elementStyleDeclaration_.item(index);
    }

    @Override
    public AbstractCSSRuleImpl getParentRule() {
        return this.elementStyleDeclaration_.getParentRule();
    }

    @Override
    public StyleElement getStyleElement(String name) {
        StyleElement existent = this.elementStyleDeclaration_.getStyleElement(name);
        if (this.localModifications_ != null) {
            StyleElement localStyleMod = (StyleElement)this.localModifications_.get(name);
            if (localStyleMod == null) {
                return existent;
            }
            if (existent == null) {
                return localStyleMod;
            }
            if ("important".equals(localStyleMod.getPriority())) {
                if (existent.isImportant()) {
                    if (existent.getSpecificity().compareTo(localStyleMod.getSpecificity()) < 0) {
                        return localStyleMod;
                    }
                } else {
                    return localStyleMod;
                }
            }
        }
        return existent;
    }

    @Override
    public StyleElement getStyleElementCaseInSensitive(String name) {
        return this.elementStyleDeclaration_.getStyleElementCaseInSensitive(name);
    }

    @Override
    public Map<String, StyleElement> getStyleMap() {
        return this.elementStyleDeclaration_.getStyleMap();
    }

    @Override
    public Element getElementOrNull() {
        return this.elementStyleDeclaration_.getElementOrNull();
    }

    @Override
    public DomElement getDomElementOrNull() {
        return this.elementStyleDeclaration_.getDomElementOrNull();
    }

    public String getDisplay() {
        BrowserVersion browserVersion;
        DomElement domElem = this.getDomElementOrNull();
        if (!domElem.isAttachedToPage() && (browserVersion = domElem.getPage().getWebClient().getBrowserVersion()).hasFeature(BrowserVersionFeatures.CSS_STYLE_PROP_DISCONNECTED_IS_EMPTY)) {
            return "";
        }
        String value = this.getStyleAttribute(StyleAttributes.Definition.DISPLAY.getAttributeName());
        if (hidden.jth.org.apache.commons.lang3.StringUtils.isEmpty(value)) {
            if (domElem instanceof HtmlElement) {
                return ((HtmlElement)domElem).getDefaultStyleDisplay().value();
            }
            return "";
        }
        return value;
    }

    public String getWidth() {
        if ("none".equals(this.getDisplay())) {
            return "auto";
        }
        final DomElement domElem = this.getDomElementOrNull();
        if (!domElem.isAttachedToPage()) {
            BrowserVersion browserVersion = domElem.getPage().getWebClient().getBrowserVersion();
            if (browserVersion.hasFeature(BrowserVersionFeatures.CSS_STYLE_PROP_DISCONNECTED_IS_EMPTY)) {
                return "";
            }
            if (this.getStyleAttribute(StyleAttributes.Definition.WIDTH, true).isEmpty()) {
                return "auto";
            }
        }
        int windowWidth = domElem.getPage().getEnclosingWindow().getInnerWidth();
        return CssPixelValueConverter.pixelString(domElem, new CssPixelValueConverter.CssValue(0, windowWidth){

            @Override
            public String get(ComputedCssStyleDeclaration style) {
                String value = style.getStyleAttribute(StyleAttributes.Definition.WIDTH, true);
                if (hidden.jth.org.apache.commons.lang3.StringUtils.isEmpty(value)) {
                    String content;
                    String position = ComputedCssStyleDeclaration.this.getStyleAttribute(StyleAttributes.Definition.POSITION, true);
                    if (("absolute".equals(position) || "fixed".equals(position)) && null != (content = domElem.getVisibleText()) && content.length() < 13) {
                        return content.length() * 7 + "px";
                    }
                    int windowDefaultValue = this.getWindowDefaultValue();
                    if (domElem instanceof HtmlBody) {
                        windowDefaultValue -= 16;
                    }
                    return windowDefaultValue + "px";
                }
                if ("auto".equals(value)) {
                    int windowDefaultValue = this.getWindowDefaultValue();
                    if (domElem instanceof HtmlBody) {
                        windowDefaultValue -= 16;
                    }
                    return windowDefaultValue + "px";
                }
                return value;
            }
        });
    }

    public Integer getCachedWidth() {
        return this.width_;
    }

    public int setCachedWidth(int width) {
        this.width_ = width;
        return width;
    }

    public Integer getCachedHeight() {
        return this.height_;
    }

    public int setCachedHeight(int height) {
        this.height_ = height;
        return height;
    }

    public Integer getCachedHeight2() {
        return this.height2_;
    }

    public int setCachedHeight2(int height) {
        this.height2_ = height;
        return height;
    }

    public Integer getCachedTop() {
        return this.top_;
    }

    public void setCachedTop(Integer top) {
        this.top_ = top;
    }

    public Integer getCachedPaddingHorizontal() {
        return this.paddingHorizontal_;
    }

    public int setCachedPaddingHorizontal(int paddingHorizontal) {
        this.paddingHorizontal_ = paddingHorizontal;
        return paddingHorizontal;
    }

    public Integer getCachedPaddingVertical() {
        return this.paddingVertical_;
    }

    public int setCachedPaddingVertical(int paddingVertical) {
        this.paddingVertical_ = paddingVertical;
        return paddingVertical;
    }

    public Integer getCachedBorderHorizontal() {
        return this.borderHorizontal_;
    }

    public int setCachedBorderHorizontal(int borderHorizontal) {
        this.borderHorizontal_ = borderHorizontal;
        return borderHorizontal;
    }

    public Integer getCachedBorderVertical() {
        return this.borderVertical_;
    }

    public int setCachedBorderVertical(int borderVertical) {
        this.borderVertical_ = borderVertical;
        return borderVertical;
    }

    public void applyStyleFromSelector(CSSStyleDeclarationImpl declaration, Selector selector) {
        SelectorSpecificity specificity = selector.getSelectorSpecificity();
        for (Property prop : declaration.getProperties()) {
            String name = prop.getName();
            String value = declaration.getPropertyValue(name);
            String priority = declaration.getPropertyPriority(name);
            this.applyLocalStyleAttribute(name, value, priority, specificity);
        }
    }

    private void applyLocalStyleAttribute(String name, String newValue, String priority, SelectorSpecificity specificity) {
        StyleElement existingElement;
        if (!"important".equals(priority) && (existingElement = (StyleElement)this.localModifications_.get(name)) != null) {
            if (existingElement.isImportant()) {
                return;
            }
            if (specificity.compareTo(existingElement.getSpecificity()) < 0) {
                return;
            }
        }
        StyleElement element = new StyleElement(name, newValue, priority, specificity);
        this.localModifications_.put(name, element);
    }

    public void setDefaultLocalStyleAttribute(String name, String newValue) {
        StyleElement element = new StyleElement(name, newValue, "", SelectorSpecificity.DEFAULT_STYLE_ATTRIBUTE);
        this.localModifications_.put(name, element);
    }
}

