/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.cssparser.dom;

import java.util.ArrayList;
import java.util.List;
import org.htmlunit.cssparser.dom.CSSMediaRuleImpl;
import org.htmlunit.cssparser.dom.CSSRuleListImpl;
import org.htmlunit.cssparser.dom.CSSStyleSheetImpl;
import org.htmlunit.cssparser.util.ParserUtils;

public class CSSStyleSheetListImpl {
    private List<CSSStyleSheetImpl> cssStyleSheets_;

    public List<CSSStyleSheetImpl> getCSSStyleSheets() {
        if (this.cssStyleSheets_ == null) {
            this.cssStyleSheets_ = new ArrayList<CSSStyleSheetImpl>();
        }
        return this.cssStyleSheets_;
    }

    public int getLength() {
        return this.getCSSStyleSheets().size();
    }

    public void add(CSSStyleSheetImpl cssStyleSheet) {
        this.getCSSStyleSheets().add(cssStyleSheet);
    }

    public CSSStyleSheetImpl merge() {
        CSSStyleSheetImpl merged = new CSSStyleSheetImpl();
        CSSRuleListImpl cssRuleList = new CSSRuleListImpl();
        for (CSSStyleSheetImpl cssStyleSheet : this.getCSSStyleSheets()) {
            CSSMediaRuleImpl cssMediaRule = new CSSMediaRuleImpl(merged, null, cssStyleSheet.getMedia());
            cssMediaRule.setRuleList(cssStyleSheet.getCssRules());
            cssRuleList.add(cssMediaRule);
        }
        merged.setCssRules(cssRuleList);
        merged.setMediaText("all");
        return merged;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CSSStyleSheetListImpl)) {
            return false;
        }
        CSSStyleSheetListImpl ssl = (CSSStyleSheetListImpl)obj;
        return this.equalsStyleSheets(ssl);
    }

    private boolean equalsStyleSheets(CSSStyleSheetListImpl ssl) {
        if (ssl == null || this.getLength() != ssl.getLength()) {
            return false;
        }
        int i = 0;
        for (CSSStyleSheetImpl styleSheet : this.cssStyleSheets_) {
            CSSStyleSheetImpl styleSheet2;
            if (!ParserUtils.equals(styleSheet, styleSheet2 = ssl.cssStyleSheets_.get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int hashCode() {
        int hash = 17;
        hash = ParserUtils.hashCode(hash, this.cssStyleSheets_);
        return hash;
    }
}

