/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.html;

import java.net.MalformedURLException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.htmlunit.BrowserVersion;
import org.htmlunit.BrowserVersionFeatures;
import org.htmlunit.Page;
import org.htmlunit.ScriptResult;
import org.htmlunit.SgmlPage;
import org.htmlunit.WebClient;
import org.htmlunit.corejs.javascript.Context;
import org.htmlunit.html.DisabledElement;
import org.htmlunit.html.DomAttr;
import org.htmlunit.html.DomNode;
import org.htmlunit.html.FormFieldWithNameHistory;
import org.htmlunit.html.HtmlCheckBoxInput;
import org.htmlunit.html.HtmlElement;
import org.htmlunit.html.HtmlImageInput;
import org.htmlunit.html.HtmlPage;
import org.htmlunit.html.HtmlRadioButtonInput;
import org.htmlunit.html.HtmlResetInput;
import org.htmlunit.html.HtmlSubmitInput;
import org.htmlunit.html.SubmittableElement;
import org.htmlunit.html.ValidatableElement;
import org.htmlunit.javascript.AbstractJavaScriptEngine;
import org.htmlunit.javascript.host.event.Event;
import org.htmlunit.javascript.host.event.MouseEvent;
import org.htmlunit.javascript.host.html.HTMLInputElement;
import org.htmlunit.javascript.regexp.RegExpJsToJavaConverter;
import org.htmlunit.util.NameValuePair;
import org.htmlunit.util.StringUtils;
import org.xml.sax.helpers.AttributesImpl;

public abstract class HtmlInput
extends HtmlElement
implements DisabledElement,
SubmittableElement,
FormFieldWithNameHistory,
ValidatableElement {
    private static final Log LOG = LogFactory.getLog(HtmlInput.class);
    public static final String TAG_NAME = "input";
    private String rawValue_;
    private boolean isValueDirty_;
    private final String originalName_;
    private Collection<String> newNames_ = Collections.emptySet();
    private boolean valueModifiedByJavascript_;
    private Object valueAtFocus_;
    private String customValidity_;

    public HtmlInput(SgmlPage page, Map<String, DomAttr> attributes) {
        this(TAG_NAME, page, attributes);
    }

    public HtmlInput(String qualifiedName, SgmlPage page, Map<String, DomAttr> attributes) {
        super(qualifiedName, page, attributes);
        this.rawValue_ = this.getValueAttribute();
        this.originalName_ = this.getNameAttribute();
    }

    public void setValueAttribute(String newValue) {
        super.setAttribute("value", newValue);
    }

    @Override
    public NameValuePair[] getSubmitNameValuePairs() {
        return new NameValuePair[]{new NameValuePair(this.getNameAttribute(), this.getValue())};
    }

    public final String getTypeAttribute() {
        String type = this.getAttributeDirect("type");
        if (ATTRIBUTE_NOT_DEFINED == type) {
            return "text";
        }
        return type;
    }

    public final String getNameAttribute() {
        return this.getAttributeDirect("name");
    }

    public final String getValueAttribute() {
        return this.getAttributeDirect("value");
    }

    public String getValue() {
        return this.getRawValue();
    }

    public void setValue(String newValue) {
        this.setRawValue(newValue);
        this.isValueDirty_ = true;
    }

    protected void valueAttributeChanged(String attributeValue, boolean isValueDirty) {
        if (!this.isValueDirty_) {
            this.setRawValue(attributeValue);
        }
    }

    public final String getCheckedAttribute() {
        return this.getAttributeDirect("checked");
    }

    @Override
    public final String getDisabledAttribute() {
        return this.getAttributeDirect("disabled");
    }

    @Override
    public final boolean isDisabled() {
        return this.hasAttribute("disabled");
    }

    public final String getReadOnlyAttribute() {
        return this.getAttributeDirect("readonly");
    }

    public final String getSizeAttribute() {
        return this.getAttributeDirect("size");
    }

    public final String getMaxLengthAttribute() {
        return this.getAttribute("maxLength");
    }

    protected int getMaxLength() {
        String maxLength = this.getMaxLengthAttribute();
        if (maxLength.isEmpty()) {
            return Integer.MAX_VALUE;
        }
        try {
            return Integer.parseInt(maxLength.trim());
        }
        catch (NumberFormatException e) {
            return Integer.MAX_VALUE;
        }
    }

    public final String getMinLengthAttribute() {
        return this.getAttribute("minLength");
    }

    protected int getMinLength() {
        String minLength = this.getMinLengthAttribute();
        if (minLength.isEmpty()) {
            return Integer.MIN_VALUE;
        }
        try {
            return Integer.parseInt(minLength.trim());
        }
        catch (NumberFormatException e) {
            return Integer.MIN_VALUE;
        }
    }

    public String getSrcAttribute() {
        return this.getSrcAttributeNormalized();
    }

    public String getSrc() {
        String src = this.getSrcAttributeNormalized();
        if (ATTRIBUTE_NOT_DEFINED == src) {
            return src;
        }
        HtmlPage page = this.getHtmlPageOrNull();
        if (page != null) {
            try {
                return page.getFullyQualifiedUrl(src).toExternalForm();
            }
            catch (MalformedURLException e) {
                LOG.warn((Object)e.getMessage(), (Throwable)e);
            }
        }
        return src;
    }

    public void setSrcAttribute(String src) {
        this.setAttribute("src", src);
    }

    public final String getAltAttribute() {
        return this.getAttributeDirect("alt");
    }

    public final String getUseMapAttribute() {
        return this.getAttributeDirect("usemap");
    }

    public final String getTabIndexAttribute() {
        return this.getAttributeDirect("tabindex");
    }

    public final String getAccessKeyAttribute() {
        return this.getAttributeDirect("accesskey");
    }

    public final String getOnFocusAttribute() {
        return this.getAttributeDirect("onfocus");
    }

    public final String getOnBlurAttribute() {
        return this.getAttributeDirect("onblur");
    }

    public final String getOnSelectAttribute() {
        return this.getAttributeDirect("onselect");
    }

    public final String getOnChangeAttribute() {
        return this.getAttributeDirect("onchange");
    }

    public final String getAcceptAttribute() {
        return this.getAttribute("accept");
    }

    public final String getAlignAttribute() {
        return this.getAttributeDirect("align");
    }

    @Override
    public void reset() {
        this.setValue(this.getDefaultValue());
        this.isValueDirty_ = true;
    }

    @Override
    public void setDefaultValue(String defaultValue) {
        this.setValueAttribute(defaultValue);
    }

    @Override
    public String getDefaultValue() {
        return this.getValueAttribute();
    }

    public String getRawValue() {
        return this.rawValue_;
    }

    public void setRawValue(String rawValue) {
        this.rawValue_ = rawValue;
    }

    @Override
    public boolean isDefaultChecked() {
        return false;
    }

    public Page setChecked(boolean isChecked) {
        return this.getPage();
    }

    public void setReadOnly(boolean isReadOnly) {
        if (isReadOnly) {
            this.setAttribute("readOnly", "readOnly");
        } else {
            this.removeAttribute("readOnly");
        }
    }

    public boolean isChecked() {
        return this.hasAttribute("checked");
    }

    public boolean isReadOnly() {
        return this.hasAttribute("readOnly");
    }

    @Override
    protected boolean propagateClickStateUpdateToParent() {
        return !this.hasFeature(BrowserVersionFeatures.HTMLINPUT_DOES_NOT_CLICK_SURROUNDING_ANCHOR);
    }

    @Override
    public boolean handles(Event event) {
        if (event instanceof MouseEvent && this.hasFeature(BrowserVersionFeatures.EVENT_MOUSE_ON_DISABLED)) {
            return true;
        }
        return super.handles(event);
    }

    static Page executeOnChangeHandlerIfAppropriate(HtmlElement htmlElement) {
        SgmlPage page = htmlElement.getPage();
        WebClient webClient = page.getWebClient();
        if (!webClient.isJavaScriptEngineEnabled()) {
            return page;
        }
        AbstractJavaScriptEngine<?> engine = webClient.getJavaScriptEngine();
        if (engine.isScriptRunning()) {
            return page;
        }
        ScriptResult scriptResult = htmlElement.fireEvent("change");
        if (webClient.containsWebWindow(page.getEnclosingWindow())) {
            return page.getEnclosingWindow().getEnclosedPage();
        }
        if (scriptResult != null) {
            return webClient.getCurrentWindow().getEnclosedPage();
        }
        return page;
    }

    @Override
    protected void setAttributeNS(String namespaceURI, String qualifiedName, String attributeValue, boolean notifyAttributeChangeListeners, boolean notifyMutationObservers) {
        String qualifiedNameLC = StringUtils.toRootLowerCaseWithCache(qualifiedName);
        if ("name".equals(qualifiedNameLC)) {
            if (this.newNames_.isEmpty()) {
                this.newNames_ = new HashSet<String>();
            }
            this.newNames_.add(attributeValue);
        }
        if ("type".equals(qualifiedNameLC)) {
            this.changeType(attributeValue, true);
            return;
        }
        if ("value".equals(qualifiedNameLC)) {
            super.setAttributeNS(namespaceURI, qualifiedNameLC, attributeValue, notifyAttributeChangeListeners, notifyMutationObservers);
            this.valueAttributeChanged(attributeValue, this.isValueDirty_);
            return;
        }
        super.setAttributeNS(namespaceURI, qualifiedNameLC, attributeValue, notifyAttributeChangeListeners, notifyMutationObservers);
    }

    @Override
    public String getOriginalName() {
        return this.originalName_;
    }

    @Override
    public Collection<String> getNewNames() {
        return this.newNames_;
    }

    public void valueModifiedByJavascript() {
        this.valueModifiedByJavascript_ = true;
    }

    @Override
    public final void focus() {
        super.focus();
        this.valueAtFocus_ = this.getInternalValue();
    }

    @Override
    public final void removeFocus() {
        super.removeFocus();
        if (this.valueAtFocus_ != null && !this.valueAtFocus_.equals(this.getInternalValue())) {
            this.handleFocusLostValueChanged();
        }
        this.valueAtFocus_ = null;
    }

    void handleFocusLostValueChanged() {
        HtmlInput.executeOnChangeHandlerIfAppropriate(this);
    }

    protected Object getInternalValue() {
        return this.getRawValue();
    }

    @Override
    public HtmlElement.DisplayStyle getDefaultStyleDisplay() {
        return HtmlElement.DisplayStyle.INLINE_BLOCK;
    }

    public String getSize() {
        return this.getAttributeDirect("size");
    }

    public void setSize(String size) {
        this.setAttribute("size", size);
    }

    public void setMaxLength(int maxLength) {
        this.setAttribute("maxLength", String.valueOf(maxLength));
    }

    public void setMinLength(int minLength) {
        this.setAttribute("minLength", String.valueOf(minLength));
    }

    public String getAccept() {
        return this.getAttribute("accept");
    }

    public void setAccept(String accept) {
        this.setAttribute("accept", accept);
    }

    public String getAutocomplete() {
        return this.getAttributeDirect("autocomplete");
    }

    public void setAutocomplete(String autocomplete) {
        this.setAttribute("autocomplete", autocomplete);
    }

    public String getPlaceholder() {
        return this.getAttributeDirect("placeholder");
    }

    public void setPlaceholder(String placeholder) {
        this.setAttribute("placeholder", placeholder);
    }

    public String getPattern() {
        return this.getAttributeDirect("pattern");
    }

    public void setPattern(String pattern) {
        this.setAttribute("pattern", pattern);
    }

    public String getMin() {
        return this.getAttributeDirect("min");
    }

    public void setMin(String min) {
        this.setAttribute("min", min);
    }

    public String getMax() {
        return this.getAttributeDirect("max");
    }

    public void setMax(String max) {
        this.setAttribute("max", max);
    }

    public String getStep() {
        return this.getAttributeDirect("step");
    }

    public void setStep(String step) {
        this.setAttribute("step", step);
    }

    @Override
    public boolean isValid() {
        return !this.isValueMissingValidityState() && this.isCustomValidityValid() && this.isMaxLengthValid() && this.isMinLengthValid() && !this.hasPatternMismatchValidityState();
    }

    protected boolean isCustomValidityValid() {
        String type;
        return !this.isCustomErrorValidityState() || "button".equals(type = this.getAttributeDirect("type").toLowerCase(Locale.ROOT)) || "hidden".equals(type) || "reset".equals(type) || "image".equals(type) && this.hasFeature(BrowserVersionFeatures.HTMLINPUT_TYPE_IMAGE_IGNORES_CUSTOM_VALIDITY);
    }

    @Override
    protected boolean isRequiredSupported() {
        return true;
    }

    protected boolean isPatternSupported() {
        return false;
    }

    protected boolean isBlankPatternValidated() {
        return true;
    }

    protected boolean isMinMaxLengthSupported() {
        return false;
    }

    @Override
    public DomNode cloneNode(boolean deep) {
        HtmlInput newnode = (HtmlInput)super.cloneNode(deep);
        newnode.newNames_ = new HashSet<String>(this.newNames_);
        return newnode;
    }

    private boolean isMaxLengthValid() {
        if (!this.isMinMaxLengthSupported() || this.valueModifiedByJavascript_ || !this.hasFeature(BrowserVersionFeatures.HTMLINPUT_ATTRIBUTE_MIN_MAX_LENGTH_SUPPORTED) || this.getMaxLength() == Integer.MAX_VALUE || this.getDefaultValue().equals(this.getValue())) {
            return true;
        }
        return this.getValue().length() <= this.getMaxLength();
    }

    private boolean isMinLengthValid() {
        if (!this.isMinMaxLengthSupported() || this.valueModifiedByJavascript_ || !this.hasFeature(BrowserVersionFeatures.HTMLINPUT_ATTRIBUTE_MIN_MAX_LENGTH_SUPPORTED) || this.getMinLength() == Integer.MIN_VALUE || this.getDefaultValue().equals(this.getValue())) {
            return true;
        }
        return this.getValue().length() >= this.getMinLength();
    }

    private boolean isPatternValid() {
        if (!this.isPatternSupported()) {
            return true;
        }
        String pattern = this.getPattern();
        if (hidden.jth.org.apache.commons.lang3.StringUtils.isEmpty(pattern)) {
            return true;
        }
        String value = this.getValue();
        if (hidden.jth.org.apache.commons.lang3.StringUtils.isEmpty(value)) {
            return true;
        }
        if (!this.isBlankPatternValidated() && hidden.jth.org.apache.commons.lang3.StringUtils.isBlank(value)) {
            return true;
        }
        RegExpJsToJavaConverter converter = new RegExpJsToJavaConverter();
        String javaPattern = converter.convert(pattern);
        try {
            return Pattern.matches(javaPattern, value);
        }
        catch (Exception exception) {
            return true;
        }
    }

    @Override
    public boolean willValidate() {
        return !this.isDisabled() && !this.isReadOnly();
    }

    @Override
    public void setCustomValidity(String message) {
        this.customValidity_ = message;
    }

    public boolean isCheckable() {
        String type = this.getAttributeDirect("type").toLowerCase(Locale.ROOT);
        return "radio".equals(type) || "checkbox".equals(type);
    }

    public boolean isSubmitable() {
        String type = this.getAttributeDirect("type").toLowerCase(Locale.ROOT);
        return !"submit".equals(type) && !"image".equals(type) && !"reset".equals(type) && !"button".equals(type);
    }

    @Override
    public boolean hasBadInputValidityState() {
        return false;
    }

    @Override
    public boolean isCustomErrorValidityState() {
        return !hidden.jth.org.apache.commons.lang3.StringUtils.isEmpty(this.customValidity_);
    }

    @Override
    public boolean hasPatternMismatchValidityState() {
        return !this.isPatternValid();
    }

    @Override
    public boolean isStepMismatchValidityState() {
        return false;
    }

    @Override
    public boolean isTooLongValidityState() {
        return false;
    }

    @Override
    public boolean isTooShortValidityState() {
        if (!this.isMinMaxLengthSupported() || this.valueModifiedByJavascript_ || !this.hasFeature(BrowserVersionFeatures.HTMLINPUT_ATTRIBUTE_MIN_MAX_LENGTH_SUPPORTED) || this.getMinLength() == Integer.MIN_VALUE || this.getDefaultValue().equals(this.getValue())) {
            return false;
        }
        return this.getValue().length() < this.getMinLength();
    }

    @Override
    public boolean hasTypeMismatchValidityState() {
        return false;
    }

    @Override
    public boolean hasRangeOverflowValidityState() {
        return false;
    }

    @Override
    public boolean hasRangeUnderflowValidityState() {
        return false;
    }

    @Override
    public boolean isValidValidityState() {
        return !this.isCustomErrorValidityState() && !this.isValueMissingValidityState() && !this.isTooLongValidityState() && !this.isTooShortValidityState() && !this.hasPatternMismatchValidityState();
    }

    @Override
    public boolean isValueMissingValidityState() {
        return this.isRequiredSupported() && ATTRIBUTE_NOT_DEFINED != this.getAttributeDirect("required") && this.getValue().isEmpty();
    }

    public final boolean isFormNoValidate() {
        return this.hasAttribute("formnovalidate");
    }

    public final void setFormNoValidate(boolean noValidate) {
        if (noValidate) {
            this.setAttribute("formnovalidate", "formnovalidate");
        } else {
            this.removeAttribute("formnovalidate");
        }
    }

    public final String getType() {
        BrowserVersion browserVersion = this.getPage().getWebClient().getBrowserVersion();
        String type = this.getTypeAttribute();
        return HtmlInput.isSupported(type = StringUtils.toRootLowerCaseWithCache(type), browserVersion) ? type : "text";
    }

    public HtmlInput changeType(String newType, boolean setThroughAttribute) {
        String currentType = this.getAttributeDirect("type");
        SgmlPage page = this.getPage();
        WebClient webClient = page.getWebClient();
        BrowserVersion browser = webClient.getBrowserVersion();
        if (!currentType.equalsIgnoreCase(newType)) {
            if (newType != null && browser.hasFeature(BrowserVersionFeatures.JS_INPUT_SET_TYPE_LOWERCASE)) {
                newType = StringUtils.toRootLowerCaseWithCache(newType);
            }
            if (!HtmlInput.isSupported(StringUtils.toRootLowerCaseWithCache(newType), browser)) {
                if (setThroughAttribute) {
                    newType = "text";
                } else if (browser.hasFeature(BrowserVersionFeatures.JS_INPUT_SET_UNSUPORTED_TYPE_EXCEPTION)) {
                    throw Context.reportRuntimeError("Invalid argument '" + newType + "' for setting property type.");
                }
            }
            AttributesImpl attributes = new AttributesImpl();
            boolean typeFound = false;
            for (DomAttr entry : this.getAttributesMap().values()) {
                String name = entry.getName();
                String value = entry.getValue();
                if ("type".equals(name)) {
                    attributes.addAttribute(null, name, name, null, newType);
                    typeFound = true;
                    continue;
                }
                attributes.addAttribute(null, name, name, null, value);
            }
            if (!typeFound) {
                attributes.addAttribute(null, "type", "type", null, newType);
            }
            if (ATTRIBUTE_NOT_DEFINED != currentType || !"text".equalsIgnoreCase(newType)) {
                HtmlInput newInput = (HtmlInput)webClient.getPageCreator().getHtmlParser().getFactory(TAG_NAME).createElement(page, TAG_NAME, attributes);
                if (browser.hasFeature(BrowserVersionFeatures.JS_INPUT_CHANGE_TYPE_DROPS_VALUE)) {
                    if (!(newInput instanceof HtmlSubmitInput || newInput instanceof HtmlResetInput || newInput instanceof HtmlCheckBoxInput || newInput instanceof HtmlRadioButtonInput || newInput instanceof HtmlImageInput)) {
                        newInput.setRawValue(this.getRawValue());
                    }
                } else {
                    newInput.adjustValueAfterTypeChange(this, browser);
                }
                if (this.getParentNode() != null) {
                    this.getParentNode().replaceChild(newInput, this);
                }
                HTMLInputElement scriptable = (HTMLInputElement)this.getScriptableObject();
                this.setScriptableObject(null);
                scriptable.setDomNode(newInput, true);
                return newInput;
            }
            super.setAttributeNS(null, "type", newType, true, true);
        }
        return this;
    }

    protected void adjustValueAfterTypeChange(HtmlInput oldInput, BrowserVersion browserVersion) {
        String originalValue = oldInput.getValue();
        if (ATTRIBUTE_NOT_DEFINED != originalValue) {
            this.setValue(originalValue);
        }
    }

    private static boolean isSupported(String type, BrowserVersion browserVersion) {
        boolean supported = false;
        switch (type) {
            case "date": {
                supported = browserVersion.hasFeature(BrowserVersionFeatures.HTMLINPUT_TYPE_DATETIME_SUPPORTED);
                break;
            }
            case "datetime-local": {
                supported = browserVersion.hasFeature(BrowserVersionFeatures.HTMLINPUT_TYPE_DATETIME_LOCAL_SUPPORTED);
                break;
            }
            case "month": {
                supported = browserVersion.hasFeature(BrowserVersionFeatures.HTMLINPUT_TYPE_MONTH_SUPPORTED);
                break;
            }
            case "time": {
                supported = browserVersion.hasFeature(BrowserVersionFeatures.HTMLINPUT_TYPE_DATETIME_SUPPORTED);
                break;
            }
            case "week": {
                supported = browserVersion.hasFeature(BrowserVersionFeatures.HTMLINPUT_TYPE_WEEK_SUPPORTED);
                break;
            }
            case "color": {
                supported = !browserVersion.hasFeature(BrowserVersionFeatures.HTMLINPUT_TYPE_COLOR_NOT_SUPPORTED);
                break;
            }
            case "email": 
            case "text": 
            case "submit": 
            case "checkbox": 
            case "radio": 
            case "hidden": 
            case "password": 
            case "image": 
            case "reset": 
            case "button": 
            case "file": 
            case "number": 
            case "range": 
            case "search": 
            case "tel": 
            case "url": {
                supported = true;
                break;
            }
        }
        return supported;
    }

    protected void unmarkValueDirty() {
        this.isValueDirty_ = false;
    }

    protected void markValueDirty() {
        this.isValueDirty_ = true;
    }
}

