/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.html;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Map;
import org.htmlunit.SgmlPage;
import org.htmlunit.html.DomAttr;
import org.htmlunit.html.DomCharacterData;
import org.htmlunit.html.DomNode;
import org.htmlunit.html.DomText;
import org.htmlunit.html.HtmlElement;
import org.htmlunit.html.ScriptElement;
import org.htmlunit.html.ScriptElementSupport;
import org.htmlunit.javascript.AbstractJavaScriptEngine;
import org.htmlunit.javascript.PostponedAction;
import org.htmlunit.javascript.host.dom.Document;
import org.htmlunit.util.StringUtils;

public class HtmlScript
extends HtmlElement
implements ScriptElement {
    public static final String TAG_NAME = "script";
    private boolean executed_;
    private boolean createdByDomParser_;

    HtmlScript(String qualifiedName, SgmlPage page, Map<String, DomAttr> attributes) {
        super(qualifiedName, page, attributes);
    }

    @Override
    public final String getCharsetAttribute() {
        return this.getAttributeDirect("charset");
    }

    public final String getTypeAttribute() {
        return this.getAttributeDirect("type");
    }

    public final String getLanguageAttribute() {
        return this.getAttributeDirect("language");
    }

    @Override
    public final String getSrcAttribute() {
        return this.getSrcAttributeNormalized();
    }

    public final String getEventAttribute() {
        return this.getAttributeDirect("event");
    }

    public final String getHtmlForAttribute() {
        return this.getAttributeDirect("for");
    }

    public final String getDeferAttribute() {
        return this.getAttributeDirect("defer");
    }

    @Override
    public boolean isDeferred() {
        return this.getDeferAttribute() != ATTRIBUTE_NOT_DEFINED;
    }

    @Override
    public boolean mayBeDisplayed() {
        return false;
    }

    @Override
    protected void setAttributeNS(String namespaceURI, String qualifiedName, String attributeValue, boolean notifyAttributeChangeListeners, boolean notifyMutationObservers) {
        String qualifiedNameLC = StringUtils.toRootLowerCaseWithCache(qualifiedName);
        if (namespaceURI != null || !"src".equals(qualifiedNameLC)) {
            super.setAttributeNS(namespaceURI, qualifiedNameLC, attributeValue, notifyAttributeChangeListeners, notifyMutationObservers);
            return;
        }
        String oldValue = this.getAttribute(qualifiedNameLC);
        super.setAttributeNS(null, qualifiedNameLC, attributeValue, notifyAttributeChangeListeners, notifyMutationObservers);
        if (this.isAttachedToPage() && oldValue.isEmpty() && this.getFirstChild() == null) {
            PostponedAction action = new PostponedAction(this.getPage(), "HtmlScript.setAttributeNS"){

                @Override
                public void execute() {
                    ScriptElementSupport.executeScriptIfNeeded(HtmlScript.this, false, false);
                }
            };
            AbstractJavaScriptEngine<?> engine = this.getPage().getWebClient().getJavaScriptEngine();
            engine.addPostponedAction(action);
        }
    }

    @Override
    public void onAllChildrenAddedToPage(boolean postponed) {
        ScriptElementSupport.onAllChildrenAddedToPage(this, postponed);
    }

    private String getScriptCode() {
        Iterable<DomNode> textNodes = this.getChildren();
        StringBuilder scriptCode = new StringBuilder();
        for (DomNode node : textNodes) {
            if (!(node instanceof DomText)) continue;
            DomText domText = (DomText)node;
            scriptCode.append(domText.getData());
        }
        return scriptCode.toString();
    }

    @Override
    protected boolean isEmptyXmlTagExpanded() {
        return true;
    }

    @Override
    protected void printChildrenAsXml(String indent, PrintWriter printWriter) {
        DomCharacterData textNode = (DomCharacterData)this.getFirstChild();
        if (textNode == null) {
            return;
        }
        String data = textNode.getData();
        if (data.contains("//<![CDATA[")) {
            printWriter.print(data);
            printWriter.print("\r\n");
        } else {
            printWriter.print("//<![CDATA[");
            printWriter.print("\r\n");
            printWriter.print(data);
            printWriter.print("\r\n");
            printWriter.print("//]]>");
            printWriter.print("\r\n");
        }
    }

    public void resetExecuted() {
        this.executed_ = false;
    }

    @Override
    public void processImportNode(Document doc) {
        super.processImportNode(doc);
        this.executed_ = true;
    }

    @Override
    public String toString() {
        StringWriter writer = new StringWriter();
        PrintWriter printWriter = new PrintWriter(writer);
        printWriter.print(this.getClass().getSimpleName());
        printWriter.print("[<");
        this.printOpeningTagContentAsXml(printWriter);
        printWriter.print(">");
        printWriter.print(this.getScriptCode());
        printWriter.print("]");
        printWriter.flush();
        return writer.toString();
    }

    @Override
    public HtmlElement.DisplayStyle getDefaultStyleDisplay() {
        return HtmlElement.DisplayStyle.NONE;
    }

    @Override
    public void markAsCreatedByDomParser() {
        this.createdByDomParser_ = true;
    }

    @Override
    public boolean wasCreatedByDomParser() {
        return this.createdByDomParser_;
    }

    @Override
    public boolean isExecuted() {
        return this.executed_;
    }

    @Override
    public void setExecuted(boolean executed) {
        this.executed_ = executed;
    }
}

