/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.javascript.host.dom;

import org.htmlunit.corejs.javascript.Context;
import org.htmlunit.corejs.javascript.ScriptRuntime;
import org.htmlunit.corejs.javascript.Undefined;
import org.htmlunit.cssparser.parser.CSSException;
import org.htmlunit.html.DomDocumentFragment;
import org.htmlunit.html.DomNode;
import org.htmlunit.javascript.configuration.JsxClass;
import org.htmlunit.javascript.configuration.JsxConstructor;
import org.htmlunit.javascript.configuration.JsxFunction;
import org.htmlunit.javascript.configuration.JsxGetter;
import org.htmlunit.javascript.configuration.SupportedBrowser;
import org.htmlunit.javascript.host.Element;
import org.htmlunit.javascript.host.dom.Node;
import org.htmlunit.javascript.host.dom.NodeList;
import org.htmlunit.javascript.host.html.HTMLCollection;

@JsxClass(domClass=DomDocumentFragment.class)
public class DocumentFragment
extends Node {
    @JsxConstructor(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public DocumentFragment() {
    }

    @JsxFunction
    public NodeList querySelectorAll(String selectors) {
        try {
            return NodeList.staticNodeList(this, this.getDomNodeOrDie().querySelectorAll(selectors));
        }
        catch (CSSException e) {
            throw Context.reportRuntimeError("An invalid or illegal selector was specified (selector: '" + selectors + "' error: " + e.getMessage() + ").");
        }
    }

    @JsxFunction
    public Node querySelector(String selectors) {
        try {
            Object node = this.getDomNodeOrDie().querySelector(selectors);
            if (node != null) {
                return (Node)((DomNode)node).getScriptableObject();
            }
            return null;
        }
        catch (CSSException e) {
            throw Context.reportRuntimeError("An invalid or illegal selector was specified (selector: '" + selectors + "' error: " + e.getMessage() + ").");
        }
    }

    @Override
    public Object getDefaultValue(Class<?> hint) {
        if (String.class.equals(hint) || hint == null) {
            return "[object " + this.getClassName() + "]";
        }
        return super.getDefaultValue(hint);
    }

    @Override
    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public int getChildElementCount() {
        return super.getChildElementCount();
    }

    @Override
    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public Element getFirstElementChild() {
        return super.getFirstElementChild();
    }

    @Override
    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public Element getLastElementChild() {
        return super.getLastElementChild();
    }

    @Override
    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public HTMLCollection getChildren() {
        return super.getChildren();
    }

    @JsxFunction(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public Object getElementById(Object id) {
        if (id == null || Undefined.isUndefined(id)) {
            return null;
        }
        String idString = ScriptRuntime.toString(id);
        if (idString == null || idString.length() == 0) {
            return null;
        }
        for (DomNode child : this.getDomNodeOrDie().getChildren()) {
            Element elem = (Element)child.getScriptableObject();
            if (!idString.equals(elem.getId())) continue;
            return elem;
        }
        return null;
    }

    @Override
    public Object getRootNode() {
        return this;
    }
}

