/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.javascript.host.event;

import org.htmlunit.BrowserVersionFeatures;
import org.htmlunit.corejs.javascript.ScriptRuntime;
import org.htmlunit.corejs.javascript.Scriptable;
import org.htmlunit.corejs.javascript.ScriptableObject;
import org.htmlunit.corejs.javascript.Undefined;
import org.htmlunit.javascript.configuration.JsxClass;
import org.htmlunit.javascript.configuration.JsxConstructor;
import org.htmlunit.javascript.configuration.JsxGetter;
import org.htmlunit.javascript.configuration.SupportedBrowser;
import org.htmlunit.javascript.host.event.Event;
import org.htmlunit.javascript.host.file.Blob;

@JsxClass(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
public class BlobEvent
extends Event {
    private Blob data_;

    @Override
    @JsxConstructor
    public void jsConstructor(String type, ScriptableObject details) {
        super.jsConstructor(ScriptRuntime.toString(type), details);
        if (details != null && !Undefined.isUndefined(details)) {
            Object dataObj = details.get("data", (Scriptable)details);
            if (NOT_FOUND == dataObj) {
                if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_BLOB_EVENT_REQUIRES_DATA)) {
                    throw ScriptRuntime.typeError("BlobEvent data is required.");
                }
            } else {
                if (!(dataObj instanceof Blob)) {
                    throw ScriptRuntime.typeError("BlobEvent data has to be a Blob.");
                }
                this.data_ = (Blob)dataObj;
            }
        } else if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_BLOB_EVENT_REQUIRES_DATA)) {
            throw ScriptRuntime.typeError("BlobEvent data is required.");
        }
    }

    @JsxGetter
    public Blob getData() {
        return this.data_;
    }

    protected void setDetail(Blob data) {
        this.data_ = data;
    }
}

