/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.javascript.host.html;

import org.htmlunit.corejs.javascript.Function;
import org.htmlunit.html.HtmlBody;
import org.htmlunit.html.HtmlElement;
import org.htmlunit.javascript.configuration.JsxClass;
import org.htmlunit.javascript.configuration.JsxConstructor;
import org.htmlunit.javascript.configuration.JsxFunction;
import org.htmlunit.javascript.configuration.JsxGetter;
import org.htmlunit.javascript.configuration.JsxSetter;
import org.htmlunit.javascript.configuration.SupportedBrowser;
import org.htmlunit.javascript.host.dom.TextRange;
import org.htmlunit.javascript.host.html.HTMLElement;
import org.htmlunit.util.StringUtils;

@JsxClass(domClass=HtmlBody.class)
public class HTMLBodyElement
extends HTMLElement {
    @JsxConstructor(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public HTMLBodyElement() {
    }

    public void createEventHandlerFromAttribute(String attributeName, String value) {
        if (StringUtils.toRootLowerCaseWithCache(attributeName).startsWith("on")) {
            this.createEventHandler(attributeName.substring(2), value);
        }
    }

    @Override
    protected boolean isEventHandlerOnWindow() {
        return true;
    }

    @Override
    public HTMLElement getOffsetParent_js() {
        return null;
    }

    @JsxGetter
    public String getALink() {
        return this.getDomNodeOrDie().getAttribute("aLink");
    }

    @JsxSetter
    public void setALink(String aLink) {
        this.setColorAttribute("aLink", aLink);
    }

    @JsxGetter
    public String getBackground() {
        HtmlElement node = this.getDomNodeOrDie();
        return node.getAttributeDirect("background");
    }

    @JsxSetter
    public void setBackground(String background) {
        this.getDomNodeOrDie().setAttribute("background", background);
    }

    @JsxGetter
    public String getBgColor() {
        return this.getDomNodeOrDie().getAttribute("bgColor");
    }

    @JsxSetter
    public void setBgColor(String bgColor) {
        this.setColorAttribute("bgColor", bgColor);
    }

    @JsxGetter
    public String getLink() {
        return this.getDomNodeOrDie().getAttributeDirect("link");
    }

    @JsxSetter
    public void setLink(String link) {
        this.setColorAttribute("link", link);
    }

    @JsxGetter
    public String getText() {
        return this.getDomNodeOrDie().getAttributeDirect("text");
    }

    @JsxSetter
    public void setText(String text) {
        this.setColorAttribute("text", text);
    }

    @JsxGetter
    public String getVLink() {
        return this.getDomNodeOrDie().getAttribute("vLink");
    }

    @JsxSetter
    public void setVLink(String vLink) {
        this.setColorAttribute("vLink", vLink);
    }

    @Override
    public int getClientWidth() {
        return super.getClientWidth() + 16;
    }

    @Override
    @JsxFunction(value={SupportedBrowser.IE})
    public TextRange createTextRange() {
        return super.createTextRange();
    }

    @Override
    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public Object getOnload() {
        return super.getOnload();
    }

    @Override
    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public void setOnload(Object onload) {
        super.setOnload(onload);
    }

    @Override
    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public void setOnblur(Object handler) {
        super.setOnblur(handler);
    }

    @Override
    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public Object getOnblur() {
        return super.getOnblur();
    }

    @Override
    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public void setOnfocus(Object handler) {
        super.setOnfocus(handler);
    }

    @Override
    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public Object getOnfocus() {
        return super.getOnfocus();
    }

    @Override
    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public void setOnerror(Object handler) {
        super.setOnerror(handler);
    }

    @Override
    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public Object getOnerror() {
        return super.getOnerror();
    }

    @JsxGetter
    public Function getOnbeforeunload() {
        return this.getEventHandler("beforeunload");
    }

    @JsxSetter
    public void setOnbeforeunload(Object onbeforeunload) {
        this.setEventHandler("beforeunload", onbeforeunload);
    }

    @JsxGetter(value={SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public Function getOngamepadconnected() {
        return this.getEventHandler("ongamepadconnected");
    }

    @JsxSetter(value={SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public void setOngamepadconnected(Object gamepadconnected) {
        this.setEventHandler("ongamepadconnected", gamepadconnected);
    }

    @JsxGetter(value={SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public Function getOngamepaddisconnected() {
        return this.getEventHandler("ongamepaddisconnected");
    }

    @JsxSetter(value={SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public void setOngamepaddisconnected(Object gamepaddisconnected) {
        this.setEventHandler("ongamepaddisconnected", gamepaddisconnected);
    }

    @JsxGetter
    public Function getOnhashchange() {
        return this.getEventHandler("hashchange");
    }

    @JsxSetter
    public void setOnhashchange(Object onhashchange) {
        this.setEventHandler("hashchange", onhashchange);
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public Function getOnlanguagechange() {
        return this.getEventHandler("languagechange");
    }

    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public void setOnlanguagechange(Object onlanguagechange) {
        this.setEventHandler("languagechange", onlanguagechange);
    }

    @JsxGetter
    public Function getOnmessage() {
        return this.getEventHandler("message");
    }

    @JsxSetter
    public void setOnmessage(Object onmessage) {
        this.setEventHandler("message", onmessage);
    }

    @JsxGetter
    public Function getOnoffline() {
        return this.getEventHandler("offline");
    }

    @JsxSetter
    public void setOnoffline(Object onoffline) {
        this.setEventHandler("offline", onoffline);
    }

    @JsxGetter
    public Function getOnonline() {
        return this.getEventHandler("online");
    }

    @JsxSetter
    public void setOnonline(Object ononline) {
        this.setEventHandler("online", ononline);
    }

    @JsxGetter
    public Function getOnpagehide() {
        return this.getEventHandler("pagehide");
    }

    @JsxSetter
    public void setOnpagehide(Object onpagehide) {
        this.setEventHandler("pagehide", onpagehide);
    }

    @JsxGetter
    public Function getOnpageshow() {
        return this.getEventHandler("pageshow");
    }

    @JsxSetter
    public void setOnpageshow(Object onpageshow) {
        this.setEventHandler("pageshow", onpageshow);
    }

    @JsxGetter
    public Function getOnpopstate() {
        return this.getEventHandler("popstate");
    }

    @JsxSetter
    public void setOnpopstate(Object onpopstate) {
        this.setEventHandler("popstate", onpopstate);
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public Function getOnrejectionhandled() {
        return this.getEventHandler("rejectionhandled");
    }

    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public void setOnrejectionhandled(Object onrejectionhandled) {
        this.setEventHandler("rejectionhandled", onrejectionhandled);
    }

    @JsxGetter
    public Function getOnstorage() {
        return this.getEventHandler("storage");
    }

    @JsxSetter
    public void setOnstorage(Object onstorage) {
        this.setEventHandler("storage", onstorage);
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public Function getOnunhandledrejection() {
        return this.getEventHandler("unhandledrejection");
    }

    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public void setOnunhandledrejection(Object onunhandledrejection) {
        this.setEventHandler("unhandledrejection", onunhandledrejection);
    }

    @JsxGetter
    public Function getOnunload() {
        return this.getEventHandler("unload");
    }

    @JsxSetter
    public void setOnunload(Object onunload) {
        this.setEventHandler("unload", onunload);
    }

    @JsxGetter
    public Function getOnafterprint() {
        return this.getEventHandler("afterprint");
    }

    @JsxSetter
    public void setOnafterprint(Object onafterprint) {
        this.setEventHandler("afterprint", onafterprint);
    }

    @JsxGetter
    public Function getOnbeforeprint() {
        return this.getEventHandler("beforeprint");
    }

    @JsxSetter
    public void setOnbeforeprint(Object onbeforeprint) {
        this.setEventHandler("beforeprint", onbeforeprint);
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public Function getOnmessageerror() {
        return this.getEventHandler("onmessageerror");
    }

    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public void setOnmessageerror(Object onmessageerror) {
        this.setEventHandler("onmessageerror", onmessageerror);
    }

    @Override
    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.IE})
    public Function getOnresize() {
        return super.getOnresize();
    }

    @Override
    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.IE})
    public void setOnresize(Object onresize) {
        super.setOnresize(onresize);
    }

    @Override
    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public Function getOnscroll() {
        return super.getOnscroll();
    }

    @Override
    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public void setOnscroll(Object onresize) {
        super.setOnscroll(onresize);
    }
}

