/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.javascript.host.html;

import org.htmlunit.corejs.javascript.Context;
import org.htmlunit.corejs.javascript.ScriptRuntime;
import org.htmlunit.corejs.javascript.Undefined;
import org.htmlunit.html.HtmlDialog;
import org.htmlunit.javascript.configuration.JsxClass;
import org.htmlunit.javascript.configuration.JsxConstructor;
import org.htmlunit.javascript.configuration.JsxFunction;
import org.htmlunit.javascript.configuration.JsxGetter;
import org.htmlunit.javascript.configuration.JsxSetter;
import org.htmlunit.javascript.configuration.SupportedBrowser;
import org.htmlunit.javascript.host.html.HTMLElement;

@JsxClass(domClass=HtmlDialog.class, value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
public class HTMLDialogElement
extends HTMLElement {
    @JsxConstructor
    public HTMLDialogElement() {
    }

    @JsxGetter
    public boolean isOpen() {
        return ((HtmlDialog)this.getDomNodeOrDie()).isOpen();
    }

    @JsxSetter
    public void setOpen(Object newValue) {
        boolean bool = ScriptRuntime.toBoolean(newValue);
        ((HtmlDialog)this.getDomNodeOrDie()).setOpen(bool);
    }

    @JsxFunction
    public void show() {
        HtmlDialog dialog = (HtmlDialog)this.getDomNodeOrDie();
        if (dialog.isOpen() && dialog.isModal()) {
            throw Context.reportRuntimeError("InvalidStateError: Dialog is already open.");
        }
        dialog.show();
    }

    @JsxFunction
    public void close(Object returnValue) {
        if (returnValue == null || Undefined.isUndefined(returnValue)) {
            ((HtmlDialog)this.getDomNodeOrDie()).close("");
        }
        ((HtmlDialog)this.getDomNodeOrDie()).close(ScriptRuntime.toString(returnValue));
    }

    @JsxFunction
    public void showModal() {
        HtmlDialog dialog = (HtmlDialog)this.getDomNodeOrDie();
        if (dialog.isOpen() && !dialog.isModal()) {
            throw Context.reportRuntimeError("InvalidStateError: Dialog is already open.");
        }
        dialog.showModal();
    }

    @JsxGetter
    public String getReturnValue() {
        return ((HtmlDialog)this.getDomNodeOrDie()).getReturnValue();
    }

    @JsxSetter
    public void setReturnValue(Object newValue) {
        if (newValue == null || Undefined.isUndefined(newValue)) {
            ((HtmlDialog)this.getDomNodeOrDie()).setReturnValue("");
        }
        ((HtmlDialog)this.getDomNodeOrDie()).setReturnValue(ScriptRuntime.toString(newValue));
    }
}

