/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.javascript.host.html;

import org.htmlunit.BrowserVersionFeatures;
import org.htmlunit.corejs.javascript.Context;
import org.htmlunit.html.BaseFrameElement;
import org.htmlunit.html.FrameWindow;
import org.htmlunit.html.HtmlFrame;
import org.htmlunit.javascript.configuration.JsxClass;
import org.htmlunit.javascript.configuration.JsxConstructor;
import org.htmlunit.javascript.configuration.JsxGetter;
import org.htmlunit.javascript.configuration.JsxSetter;
import org.htmlunit.javascript.configuration.SupportedBrowser;
import org.htmlunit.javascript.host.Window;
import org.htmlunit.javascript.host.WindowProxy;
import org.htmlunit.javascript.host.html.DocumentProxy;
import org.htmlunit.javascript.host.html.HTMLElement;

@JsxClass(domClass=HtmlFrame.class)
public class HTMLFrameElement
extends HTMLElement {
    @JsxConstructor(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public HTMLFrameElement() {
    }

    @JsxGetter
    public String getSrc() {
        return this.getFrame().getSrcAttribute();
    }

    @JsxSetter
    public void setSrc(String src) {
        this.getFrame().setSrcAttribute(src);
    }

    @JsxGetter
    public DocumentProxy getContentDocument() {
        FrameWindow frameWindow = this.getFrame().getEnclosedWindow();
        if (FrameWindow.PageDenied.NONE != frameWindow.getPageDenied()) {
            if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_FRAME_CONTENT_DOCUMENT_ACCESS_DENIED_THROWS)) {
                throw Context.reportRuntimeError("Error access denied");
            }
            return null;
        }
        return ((Window)frameWindow.getScriptableObject()).getDocument_js();
    }

    @JsxGetter
    public WindowProxy getContentWindow() {
        return Window.getProxy(this.getFrame().getEnclosedWindow());
    }

    @Override
    @JsxGetter
    public String getName() {
        return this.getFrame().getNameAttribute();
    }

    @Override
    @JsxSetter
    public void setName(String name) {
        this.getFrame().setNameAttribute(name);
    }

    private BaseFrameElement getFrame() {
        return (BaseFrameElement)this.getDomNodeOrDie();
    }

    @JsxGetter(value={SupportedBrowser.IE})
    public String getBorder() {
        return this.getDomNodeOrDie().getAttributeDirect("border");
    }

    @JsxSetter(value={SupportedBrowser.IE})
    public void setBorder(String border) {
        this.getDomNodeOrDie().setAttribute("border", border);
    }

    @Override
    protected boolean isEndTagForbidden() {
        return true;
    }
}

