/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.javascript.host.html;

import org.htmlunit.html.HtmlForm;
import org.htmlunit.html.HtmlOutput;
import org.htmlunit.javascript.configuration.JsxClass;
import org.htmlunit.javascript.configuration.JsxConstructor;
import org.htmlunit.javascript.configuration.JsxFunction;
import org.htmlunit.javascript.configuration.JsxGetter;
import org.htmlunit.javascript.configuration.JsxSetter;
import org.htmlunit.javascript.configuration.SupportedBrowser;
import org.htmlunit.javascript.host.dom.NodeList;
import org.htmlunit.javascript.host.html.HTMLElement;
import org.htmlunit.javascript.host.html.HTMLFormElement;
import org.htmlunit.javascript.host.html.LabelsNodeList;
import org.htmlunit.javascript.host.html.ValidityState;

@JsxClass(domClass=HtmlOutput.class, value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
public class HTMLOutputElement
extends HTMLElement {
    private NodeList labels_;

    @JsxConstructor
    public HTMLOutputElement() {
    }

    @Override
    @JsxGetter
    public String getName() {
        return this.getDomNodeOrDie().getAttributeDirect("name");
    }

    @Override
    @JsxSetter
    public void setName(String name) {
        this.getDomNodeOrDie().setAttribute("name", name);
    }

    @Override
    @JsxGetter
    public HTMLFormElement getForm() {
        HtmlForm form = this.getDomNodeOrDie().getEnclosingForm();
        if (form == null) {
            return null;
        }
        return (HTMLFormElement)this.getScriptableFor(form);
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public NodeList getLabels() {
        if (this.labels_ == null) {
            this.labels_ = new LabelsNodeList(this.getDomNodeOrDie());
        }
        return this.labels_;
    }

    @JsxFunction
    public boolean checkValidity() {
        return this.getDomNodeOrDie().isValid();
    }

    @JsxGetter
    public ValidityState getValidity() {
        ValidityState validityState = new ValidityState();
        validityState.setPrototype(this.getPrototype(validityState.getClass()));
        validityState.setParentScope(this.getParentScope());
        validityState.setDomNode(this.getDomNodeOrDie());
        return validityState;
    }

    @JsxGetter
    public boolean getWillValidate() {
        return ((HtmlOutput)this.getDomNodeOrDie()).willValidate();
    }

    @JsxFunction
    public void setCustomValidity(String message) {
        ((HtmlOutput)this.getDomNodeOrDie()).setCustomValidity(message);
    }
}

