/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.javascript.host.html;

import java.net.MalformedURLException;
import java.net.URL;
import org.htmlunit.html.DomElement;
import org.htmlunit.html.DomNode;
import org.htmlunit.html.DomText;
import org.htmlunit.html.HtmlElement;
import org.htmlunit.html.HtmlPage;
import org.htmlunit.html.HtmlScript;
import org.htmlunit.html.ScriptElementSupport;
import org.htmlunit.javascript.configuration.JsxClass;
import org.htmlunit.javascript.configuration.JsxConstructor;
import org.htmlunit.javascript.configuration.JsxGetter;
import org.htmlunit.javascript.configuration.JsxSetter;
import org.htmlunit.javascript.configuration.SupportedBrowser;
import org.htmlunit.javascript.host.html.HTMLElement;

@JsxClass(domClass=HtmlScript.class)
public class HTMLScriptElement
extends HTMLElement {
    @JsxConstructor(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public HTMLScriptElement() {
    }

    @JsxGetter
    public String getSrc() {
        HtmlScript tmpScript = (HtmlScript)this.getDomNodeOrDie();
        String src = tmpScript.getSrcAttribute();
        if (DomElement.ATTRIBUTE_NOT_DEFINED == src) {
            return src;
        }
        try {
            URL expandedSrc = ((HtmlPage)tmpScript.getPage()).getFullyQualifiedUrl(src);
            src = expandedSrc.toString();
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return src;
    }

    @JsxSetter
    public void setSrc(String src) {
        this.getDomNodeOrDie().setAttribute("src", src);
    }

    @JsxGetter
    public String getText() {
        StringBuilder scriptCode = new StringBuilder();
        for (DomNode node : this.getDomNodeOrDie().getChildren()) {
            if (!(node instanceof DomText)) continue;
            DomText domText = (DomText)node;
            scriptCode.append(domText.getData());
        }
        return scriptCode.toString();
    }

    @JsxSetter
    public void setText(String text) {
        HtmlElement htmlElement = this.getDomNodeOrDie();
        htmlElement.removeAllChildren();
        DomText textChild = new DomText(htmlElement.getPage(), text);
        htmlElement.appendChild(textChild);
        ScriptElementSupport.executeScriptIfNeeded(htmlElement, false, false);
    }

    @JsxGetter
    public String getType() {
        return this.getDomNodeOrDie().getAttributeDirect("type");
    }

    @JsxSetter
    public void setType(String type) {
        this.getDomNodeOrDie().setAttribute("type", type);
    }

    @Override
    public Object appendChild(Object childObject) {
        HtmlElement tmpScript = this.getDomNodeOrDie();
        boolean wasEmpty = tmpScript.getFirstChild() == null;
        Object result = super.appendChild(childObject);
        if (wasEmpty) {
            ScriptElementSupport.executeScriptIfNeeded(tmpScript, false, false);
        }
        return result;
    }

    @JsxGetter
    public boolean isAsync() {
        return this.getDomNodeOrDie().hasAttribute("async");
    }

    @JsxSetter
    public void setAsync(boolean async) {
        if (async) {
            this.getDomNodeOrDie().setAttribute("async", "");
        } else {
            this.getDomNodeOrDie().removeAttribute("async");
        }
    }
}

