/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.javascript.host.html;

import org.htmlunit.BrowserVersionFeatures;
import org.htmlunit.SgmlPage;
import org.htmlunit.html.HtmlElement;
import org.htmlunit.html.HtmlUnknownElement;
import org.htmlunit.javascript.configuration.JsxClass;
import org.htmlunit.javascript.configuration.JsxConstructor;
import org.htmlunit.javascript.configuration.SupportedBrowser;
import org.htmlunit.javascript.host.html.HTMLElement;
import org.htmlunit.xml.XmlPage;

@JsxClass(domClass=HtmlUnknownElement.class)
public class HTMLUnknownElement
extends HTMLElement {
    @JsxConstructor(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public HTMLUnknownElement() {
    }

    @Override
    public String getNodeName() {
        HtmlElement elem = this.getDomNodeOrDie();
        SgmlPage page = elem.getPage();
        if (page instanceof XmlPage) {
            return elem.getLocalName();
        }
        return super.getNodeName();
    }

    @Override
    public String getClassName() {
        HtmlElement element;
        if (this.getWindow().getWebWindow() != null && (element = this.getDomNodeOrNull()) != null) {
            String name = element.getNodeName();
            if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_HTML_RUBY_ELEMENT_CLASS_NAME) && ("rb".equals(name) || "rp".equals(name) || "rt".equals(name) || "rtc".equals(name) || "ruby".equals(name))) {
                return "HTMLElement";
            }
            if (name.indexOf(45) != -1 && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_HTML_HYPHEN_ELEMENT_CLASS_NAME)) {
                return "HTMLElement";
            }
        }
        return super.getClassName();
    }

    @Override
    protected boolean isLowerCaseInOuterHtml() {
        return true;
    }

    @Override
    protected boolean isEndTagForbidden() {
        if ("BGSOUND".equals(this.getNodeName())) {
            return true;
        }
        return super.isEndTagForbidden();
    }
}

