/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.html.DomAttr;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlImage;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class HtmlMap
extends HtmlElement {
    public static final String TAG_NAME = "map";

    HtmlMap(String qualifiedName, SgmlPage page, Map<String, DomAttr> attributes) {
        super(qualifiedName, page, attributes);
    }

    public final String getNameAttribute() {
        return this.getAttribute("name");
    }

    @Override
    public HtmlElement.DisplayStyle getDefaultStyleDisplay() {
        return HtmlElement.DisplayStyle.INLINE;
    }

    @Override
    public boolean isDisplayed() {
        HtmlImage image = this.findReferencingImage();
        if (null != image) {
            return image.isDisplayed();
        }
        return false;
    }

    private HtmlImage findReferencingImage() {
        HtmlPage page = this.getHtmlPageOrNull();
        String name = this.getNameAttribute();
        if (null != page && StringUtils.isNotBlank((CharSequence)name)) {
            name = "#" + name.trim();
            for (HtmlElement elem : page.getDocumentElement().getHtmlElementsByTagName("img")) {
                HtmlImage image = (HtmlImage)elem;
                if (!name.equals(image.getUseMapAttribute())) continue;
                return image;
            }
        }
        return null;
    }
}

