/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript;

import com.gargoylesoftware.htmlunit.javascript.DebugFrameAdapter;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.host.event.Event;
import net.sourceforge.htmlunit.corejs.javascript.Callable;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.EcmaError;
import net.sourceforge.htmlunit.corejs.javascript.Function;
import net.sourceforge.htmlunit.corejs.javascript.IdFunctionObject;
import net.sourceforge.htmlunit.corejs.javascript.JavaScriptException;
import net.sourceforge.htmlunit.corejs.javascript.NativeFunction;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import net.sourceforge.htmlunit.corejs.javascript.ScriptableObject;
import net.sourceforge.htmlunit.corejs.javascript.debug.DebuggableScript;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DebugFrameImpl
extends DebugFrameAdapter {
    private static final Log LOG = LogFactory.getLog(DebugFrameImpl.class);
    private static final String KEY_LAST_LINE = "DebugFrameImpl#line";
    private static final String KEY_LAST_SOURCE = "DebugFrameImpl#source";
    private final DebuggableScript functionOrScript_;

    public DebugFrameImpl(DebuggableScript functionOrScript) {
        this.functionOrScript_ = functionOrScript;
    }

    @Override
    public void onEnter(Context cx, Scriptable activation, Scriptable thisObj, Object[] args) {
        if (LOG.isTraceEnabled()) {
            StringBuilder sb = new StringBuilder();
            String line = this.getFirstLine(cx);
            String source = this.getSourceName(cx);
            sb.append(source).append(":").append(line).append(" ");
            for (Scriptable parent = activation.getParentScope(); parent != null; parent = parent.getParentScope()) {
                sb.append("   ");
            }
            String functionName = this.getFunctionName(thisObj);
            sb.append(functionName).append("(");
            int nbParams = this.functionOrScript_.getParamCount();
            for (int i = 0; i < nbParams; ++i) {
                String argAsString = i < args.length ? this.stringValue(args[i]) : "undefined";
                sb.append(this.getParamName(i)).append(": ").append(argAsString);
                if (i >= nbParams - 1) continue;
                sb.append(", ");
            }
            sb.append(")");
            LOG.trace((Object)sb);
        }
    }

    private String stringValue(Object arg) {
        if (arg instanceof NativeFunction) {
            String name = (String)StringUtils.defaultIfEmpty((CharSequence)((NativeFunction)arg).getFunctionName(), (CharSequence)"anonymous");
            return "[function " + name + "]";
        }
        if (arg instanceof IdFunctionObject) {
            return "[function " + ((IdFunctionObject)arg).getFunctionName() + "]";
        }
        if (arg instanceof Function) {
            return "[function anonymous]";
        }
        String asString = null;
        try {
            asString = Context.toString(arg);
            if (arg instanceof Event) {
                asString = asString + "<" + ((Event)arg).getType() + ">";
            }
        }
        catch (Throwable e) {
            asString = String.valueOf(arg);
        }
        return asString;
    }

    @Override
    public void onExceptionThrown(Context cx, Throwable t) {
        if (LOG.isTraceEnabled()) {
            if (t instanceof JavaScriptException) {
                JavaScriptException e = (JavaScriptException)t;
                LOG.trace((Object)(this.getSourceName(cx) + ":" + this.getFirstLine(cx) + " Exception thrown: " + Context.toString(e.details())));
            } else if (t instanceof EcmaError) {
                EcmaError e = (EcmaError)t;
                LOG.trace((Object)(this.getSourceName(cx) + ":" + this.getFirstLine(cx) + " Exception thrown: " + Context.toString(e.details())));
            } else {
                LOG.trace((Object)(this.getSourceName(cx) + ":" + this.getFirstLine(cx) + " Exception thrown: " + t.getCause()));
            }
        }
    }

    @Override
    public void onLineChange(Context cx, int lineNumber) {
        cx.putThreadLocal(KEY_LAST_LINE, lineNumber);
        cx.putThreadLocal(KEY_LAST_SOURCE, this.functionOrScript_.getSourceName());
    }

    private String getFunctionName(Scriptable thisObj) {
        if (this.functionOrScript_.isFunction()) {
            String name = this.functionOrScript_.getFunctionName();
            if (name != null && !name.isEmpty()) {
                return name;
            }
            if (thisObj instanceof SimpleScriptable) {
                return "[anonymous]";
            }
            for (Scriptable obj = thisObj; obj != null; obj = obj.getPrototype()) {
                for (Object id : obj.getIds()) {
                    NativeFunction f;
                    Object o;
                    if (!(id instanceof String)) continue;
                    String s = (String)id;
                    if (obj instanceof ScriptableObject) {
                        o = ((ScriptableObject)obj).getGetterOrSetter(s, 0, false);
                        if (o == null) {
                            o = ((ScriptableObject)obj).getGetterOrSetter(s, 0, true);
                            if (o != null && o instanceof Callable) {
                                return "__defineSetter__ " + s;
                            }
                        } else if (o instanceof Callable) {
                            return "__defineGetter__ " + s;
                        }
                    }
                    try {
                        o = obj.get(s, obj);
                    }
                    catch (Exception e) {
                        return "[anonymous]";
                    }
                    if (!(o instanceof NativeFunction) || (f = (NativeFunction)o).getDebuggableView() != this.functionOrScript_) continue;
                    return s;
                }
            }
            return "[anonymous]";
        }
        return "[script]";
    }

    private String getParamName(int index) {
        if (index >= 0 && this.functionOrScript_.getParamCount() > index) {
            return this.functionOrScript_.getParamOrVarName(index);
        }
        return "???";
    }

    private String getSourceName(Context cx) {
        String source = (String)cx.getThreadLocal(KEY_LAST_SOURCE);
        if (source == null) {
            return "unknown";
        }
        source = StringUtils.substringAfterLast((String)source, (String)"/");
        source = StringUtils.substringBefore((String)source, (String)" ");
        return source;
    }

    private String getFirstLine(Context cx) {
        Object line = cx.getThreadLocal(KEY_LAST_LINE);
        String result = line == null ? "??" : String.valueOf(line);
        return StringUtils.leftPad((String)result, (int)5);
    }
}

