/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.configuration;

import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class ClassConfiguration {
    private Map<String, PropertyInfo> propertyMap_ = new HashMap<String, PropertyInfo>();
    private Map<String, Method> functionMap_ = new HashMap<String, Method>();
    private Map<String, PropertyInfo> staticPropertyMap_ = new HashMap<String, PropertyInfo>();
    private Map<String, Method> staticFunctionMap_ = new HashMap<String, Method>();
    private List<String> constants_ = new ArrayList<String>();
    private String extendedClassName_;
    private final Class<? extends SimpleScriptable> hostClass_;
    private Member jsConstructor_;
    private final Class<?>[] domClasses_;
    private final boolean jsObject_;
    private final boolean definedInStandardsMode_;
    private final String className_;

    public ClassConfiguration(Class<? extends SimpleScriptable> hostClass, Class<?>[] domClasses, boolean jsObject, boolean definedInStandardsMode, String className) {
        Class<? extends SimpleScriptable> superClass = hostClass.getSuperclass();
        this.extendedClassName_ = superClass != SimpleScriptable.class ? superClass.getSimpleName() : "";
        this.hostClass_ = hostClass;
        this.jsObject_ = jsObject;
        this.definedInStandardsMode_ = definedInStandardsMode;
        this.domClasses_ = domClasses;
        this.className_ = className;
    }

    void setJSConstructor(Member jsConstructor) {
        if (this.jsConstructor_ != null) {
            throw new IllegalStateException("Can not have two constructors for " + this.jsConstructor_.getDeclaringClass().getName());
        }
        this.jsConstructor_ = jsConstructor;
    }

    public void addProperty(String name, Method getter, Method setter) {
        PropertyInfo info = new PropertyInfo(getter, setter);
        this.propertyMap_.put(name, info);
    }

    public void addStaticProperty(String name, Method getter, Method setter) {
        PropertyInfo info = new PropertyInfo(getter, setter);
        this.staticPropertyMap_.put(name, info);
    }

    public void addConstant(String name) {
        this.constants_.add(name);
    }

    public Set<Map.Entry<String, PropertyInfo>> getPropertyEntries() {
        return this.propertyMap_.entrySet();
    }

    public Set<Map.Entry<String, PropertyInfo>> getStaticPropertyEntries() {
        return this.staticPropertyMap_.entrySet();
    }

    public Set<Map.Entry<String, Method>> getFunctionEntries() {
        return this.functionMap_.entrySet();
    }

    public Set<Map.Entry<String, Method>> getStaticFunctionEntries() {
        return this.staticFunctionMap_.entrySet();
    }

    public Set<String> getFunctionKeys() {
        return this.functionMap_.keySet();
    }

    public List<String> getConstants() {
        return this.constants_;
    }

    public void addFunction(Method method) {
        this.functionMap_.put(method.getName(), method);
    }

    public void addStaticFunction(Method method) {
        this.staticFunctionMap_.put(method.getName(), method);
    }

    public String getExtendedClassName() {
        return this.extendedClassName_;
    }

    public Class<? extends SimpleScriptable> getHostClass() {
        return this.hostClass_;
    }

    public Member getJsConstructor() {
        return this.jsConstructor_;
    }

    public Class<?>[] getDomClasses() {
        return this.domClasses_;
    }

    public boolean isJsObject() {
        return this.jsObject_;
    }

    public boolean isDefinedInStandardsMode() {
        return this.definedInStandardsMode_;
    }

    public String getClassName() {
        if (this.className_ != null) {
            return this.className_;
        }
        return this.getHostClass().getSimpleName();
    }

    public static class PropertyInfo {
        private Method readMethod_;
        private Method writeMethod_;

        public PropertyInfo(Method readMethod, Method writeMethod) {
            this.readMethod_ = readMethod;
            this.writeMethod_ = writeMethod;
        }

        public Method getReadMethod() {
            return this.readMethod_;
        }

        public Method getWriteMethod() {
            return this.writeMethod_;
        }
    }
}

