/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.xml;

import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.WebResponse;
import com.gargoylesoftware.htmlunit.html.DomAttr;
import com.gargoylesoftware.htmlunit.html.DomCDataSection;
import com.gargoylesoftware.htmlunit.html.DomComment;
import com.gargoylesoftware.htmlunit.html.DomDocumentType;
import com.gargoylesoftware.htmlunit.html.DomElement;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.DomProcessingInstruction;
import com.gargoylesoftware.htmlunit.html.DomText;
import com.gargoylesoftware.htmlunit.html.ElementFactory;
import com.gargoylesoftware.htmlunit.html.HTMLParser;
import com.gargoylesoftware.htmlunit.xml.XmlPage;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.AttributesImpl;

public final class XmlUtil {
    public static final String DEFAULT_CHARSET = "UTF-8";
    private static final Log LOG = LogFactory.getLog(XmlUtil.class);
    private static final ErrorHandler DISCARD_MESSAGES_HANDLER = new ErrorHandler(){

        @Override
        public void error(SAXParseException exception) {
        }

        @Override
        public void fatalError(SAXParseException exception) {
        }

        @Override
        public void warning(SAXParseException exception) {
        }
    };

    private XmlUtil() {
    }

    public static Document buildDocument(WebResponse webResponse) throws IOException, SAXException, ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        if (webResponse == null) {
            return factory.newDocumentBuilder().newDocument();
        }
        factory.setNamespaceAware(true);
        InputStreamReader reader = new InputStreamReader(webResponse.getContentAsStream(), webResponse.getContentCharset());
        TrackBlankContentReader tracker = new TrackBlankContentReader(reader);
        InputSource source = new InputSource(tracker);
        DocumentBuilder builder = factory.newDocumentBuilder();
        builder.setErrorHandler(DISCARD_MESSAGES_HANDLER);
        builder.setEntityResolver(new EntityResolver(){

            @Override
            public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                return new InputSource(new StringReader(""));
            }
        });
        try {
            return builder.parse(source);
        }
        catch (SAXException e) {
            if (tracker.wasBlank()) {
                return factory.newDocumentBuilder().newDocument();
            }
            throw e;
        }
    }

    public static void appendChild(SgmlPage page, DomNode parent, Node child, boolean handleXHTMLAsHTML) {
        DocumentType documentType = child.getOwnerDocument().getDoctype();
        if (documentType != null && page instanceof XmlPage) {
            DomDocumentType domDoctype = new DomDocumentType(page, documentType.getName(), documentType.getPublicId(), documentType.getSystemId());
            ((XmlPage)page).setDocumentType(domDoctype);
        }
        DomNode childXml = XmlUtil.createFrom(page, child, handleXHTMLAsHTML);
        parent.appendChild(childXml);
        XmlUtil.copy(page, child, childXml, handleXHTMLAsHTML);
    }

    private static DomNode createFrom(SgmlPage page, Node source, boolean handleXHTMLAsHTML) {
        if (source.getNodeType() == 3) {
            return new DomText(page, source.getNodeValue());
        }
        if (source.getNodeType() == 7) {
            return new DomProcessingInstruction(page, source.getNodeName(), source.getNodeValue());
        }
        if (source.getNodeType() == 8) {
            return new DomComment(page, source.getNodeValue());
        }
        if (source.getNodeType() == 10) {
            DocumentType documentType = (DocumentType)source;
            return new DomDocumentType(page, documentType.getName(), documentType.getPublicId(), documentType.getSystemId());
        }
        String ns = source.getNamespaceURI();
        String localName = source.getLocalName();
        if (handleXHTMLAsHTML && "http://www.w3.org/1999/xhtml".equals(ns)) {
            ElementFactory factory = HTMLParser.getFactory(localName);
            return factory.createElementNS(page, ns, localName, XmlUtil.namedNodeMapToSaxAttributes(source.getAttributes()));
        }
        NamedNodeMap nodeAttributes = source.getAttributes();
        if (page != null && page.isHtmlPage()) {
            localName = localName.toUpperCase(Locale.ENGLISH);
        }
        String qualifiedName = source.getPrefix() == null ? localName : source.getPrefix() + ':' + localName;
        String namespaceURI = source.getNamespaceURI();
        if ("http://www.w3.org/2000/svg".equals(namespaceURI)) {
            return HTMLParser.SVG_FACTORY.createElementNS(page, namespaceURI, qualifiedName, XmlUtil.namedNodeMapToSaxAttributes(nodeAttributes));
        }
        LinkedHashMap<String, DomAttr> attributes = new LinkedHashMap<String, DomAttr>();
        for (int i = 0; i < nodeAttributes.getLength(); ++i) {
            Attr attribute = (Attr)nodeAttributes.item(i);
            String attributeNamespaceURI = attribute.getNamespaceURI();
            String attributeQualifiedName = attribute.getPrefix() != null ? attribute.getPrefix() + ':' + attribute.getLocalName() : attribute.getLocalName();
            String value = attribute.getNodeValue();
            boolean specified = attribute.getSpecified();
            DomAttr xmlAttribute = new DomAttr(page, attributeNamespaceURI, attributeQualifiedName, value, specified);
            attributes.put(attribute.getNodeName(), xmlAttribute);
        }
        return new DomElement(namespaceURI, qualifiedName, page, attributes);
    }

    private static Attributes namedNodeMapToSaxAttributes(NamedNodeMap attributesMap) {
        AttributesImpl attributes = new AttributesImpl();
        int length = attributesMap.getLength();
        for (int i = 0; i < length; ++i) {
            Node attr = attributesMap.item(i);
            attributes.addAttribute(attr.getNamespaceURI(), attr.getLocalName(), attr.getNodeName(), null, attr.getNodeValue());
        }
        return attributes;
    }

    private static void copy(SgmlPage page, Node source, DomNode dest, boolean handleXHTMLAsHTML) {
        NodeList nodeChildren = source.getChildNodes();
        block7: for (int i = 0; i < nodeChildren.getLength(); ++i) {
            Node child = nodeChildren.item(i);
            switch (child.getNodeType()) {
                case 1: {
                    DomNode childXml = XmlUtil.createFrom(page, child, handleXHTMLAsHTML);
                    dest.appendChild(childXml);
                    XmlUtil.copy(page, child, childXml, handleXHTMLAsHTML);
                    continue block7;
                }
                case 3: {
                    dest.appendChild(new DomText(page, child.getNodeValue()));
                    continue block7;
                }
                case 4: {
                    dest.appendChild(new DomCDataSection(page, child.getNodeValue()));
                    continue block7;
                }
                case 8: {
                    dest.appendChild(new DomComment(page, child.getNodeValue()));
                    continue block7;
                }
                case 7: {
                    dest.appendChild(new DomProcessingInstruction(page, child.getNodeName(), child.getNodeValue()));
                    continue block7;
                }
                default: {
                    LOG.warn((Object)("NodeType " + child.getNodeType() + " (" + child.getNodeName() + ") is not yet supported."));
                }
            }
        }
    }

    public static String lookupNamespaceURI(DomElement element, String prefix) {
        DomNode parentNode;
        String uri = DomElement.ATTRIBUTE_NOT_DEFINED;
        uri = prefix.isEmpty() ? element.getAttribute("xmlns") : element.getAttribute("xmlns:" + prefix);
        if (uri == DomElement.ATTRIBUTE_NOT_DEFINED && (parentNode = element.getParentNode()) instanceof DomElement) {
            uri = XmlUtil.lookupNamespaceURI((DomElement)parentNode, prefix);
        }
        return uri;
    }

    public static String lookupPrefix(DomElement element, String namespace) {
        Map<String, DomAttr> attributes = element.getAttributesMap();
        for (Map.Entry<String, DomAttr> entry : attributes.entrySet()) {
            String name = entry.getKey();
            DomAttr value = entry.getValue();
            if (!name.startsWith("xmlns:") || !value.getValue().equals(namespace)) continue;
            return name.substring(6);
        }
        for (DomNode child : element.getChildren()) {
            String prefix;
            if (!(child instanceof DomElement) || (prefix = XmlUtil.lookupPrefix((DomElement)child, namespace)) == null) continue;
            return prefix;
        }
        return null;
    }

    private static final class TrackBlankContentReader
    extends Reader {
        private Reader reader_;
        private boolean wasBlank_ = true;

        public TrackBlankContentReader(Reader characterStream) {
            this.reader_ = characterStream;
        }

        public boolean wasBlank() {
            return this.wasBlank_;
        }

        @Override
        public void close() throws IOException {
            this.reader_.close();
        }

        @Override
        public int read(char[] cbuf, int off, int len) throws IOException {
            int result = this.reader_.read(cbuf, off, len);
            if (this.wasBlank_ && result > -1) {
                for (int i = 0; i < result; ++i) {
                    char ch = cbuf[off + i];
                    if (Character.isWhitespace(ch)) continue;
                    this.wasBlank_ = false;
                    break;
                }
            }
            return result;
        }
    }
}

