/*
 * Decompiled with CFR 0.152.
 */
package hidden.jth.org.apache.http.impl.entity;

import hidden.jth.org.apache.http.HttpException;
import hidden.jth.org.apache.http.HttpMessage;
import hidden.jth.org.apache.http.ProtocolException;
import hidden.jth.org.apache.http.annotation.Immutable;
import hidden.jth.org.apache.http.entity.ContentLengthStrategy;
import hidden.jth.org.apache.http.impl.entity.LaxContentLengthStrategy;

@Immutable
public class DisallowIdentityContentLengthStrategy
implements ContentLengthStrategy {
    public static final DisallowIdentityContentLengthStrategy INSTANCE = new DisallowIdentityContentLengthStrategy(new LaxContentLengthStrategy(0));
    private final ContentLengthStrategy contentLengthStrategy;

    public DisallowIdentityContentLengthStrategy(ContentLengthStrategy contentLengthStrategy) {
        this.contentLengthStrategy = contentLengthStrategy;
    }

    @Override
    public long determineLength(HttpMessage message) throws HttpException {
        long result = this.contentLengthStrategy.determineLength(message);
        if (result == -1L) {
            throw new ProtocolException("Identity transfer encoding cannot be used");
        }
        return result;
    }
}

