/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host;

import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.WebWindow;
import com.gargoylesoftware.htmlunit.javascript.HtmlUnitContextFactory;
import com.gargoylesoftware.htmlunit.javascript.JavaScriptEngine;
import com.gargoylesoftware.htmlunit.javascript.PostponedAction;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxSetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.SupportedBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.Window;
import com.gargoylesoftware.htmlunit.javascript.host.event.EventTarget;
import com.gargoylesoftware.htmlunit.javascript.host.event.MessageEvent;
import java.net.URL;

@JsxClass
public class MessagePort
extends EventTarget {
    private MessagePort port1_;

    @JsxConstructor(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF78})
    public MessagePort() {
    }

    public MessagePort(MessagePort port1) {
        this.port1_ = port1;
    }

    @JsxGetter
    public Object getOnmessage() {
        return this.getHandlerForJavaScript("message");
    }

    @JsxSetter
    public void setOnmessage(Object onmessage) {
        this.setHandlerForJavaScript("message", onmessage);
    }

    private Object getHandlerForJavaScript(String eventName) {
        return this.getEventListenersContainer().getEventHandler(eventName);
    }

    private void setHandlerForJavaScript(String eventName, Object handler) {
        this.getEventListenersContainer().setEventHandler(eventName, handler);
    }

    @JsxFunction
    public void postMessage(String message, Object transfer) {
        if (this.port1_ != null) {
            Window w = this.getWindow();
            WebWindow webWindow = w.getWebWindow();
            Page page = webWindow.getEnclosedPage();
            URL currentURL = page.getUrl();
            final MessageEvent event = new MessageEvent();
            String origin = currentURL.getProtocol() + "://" + currentURL.getHost() + ':' + currentURL.getPort();
            event.initMessageEvent("message", false, false, message, origin, "", w, transfer);
            event.setParentScope(this.port1_);
            event.setPrototype(this.getPrototype(event.getClass()));
            final JavaScriptEngine jsEngine = (JavaScriptEngine)webWindow.getWebClient().getJavaScriptEngine();
            PostponedAction action = new PostponedAction(page, "MessagePort.postMessage"){

                @Override
                public void execute() throws Exception {
                    HtmlUnitContextFactory cf = jsEngine.getContextFactory();
                    cf.call(cx -> MessagePort.this.port1_.dispatchEvent(event));
                }
            };
            jsEngine.addPostponedAction(action);
        }
    }
}

