/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.canvas;

import com.gargoylesoftware.htmlunit.html.HtmlImage;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxSetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.SupportedBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.canvas.CanvasGradient;
import com.gargoylesoftware.htmlunit.javascript.host.canvas.ImageData;
import com.gargoylesoftware.htmlunit.javascript.host.canvas.Path2D;
import com.gargoylesoftware.htmlunit.javascript.host.canvas.TextMetrics;
import com.gargoylesoftware.htmlunit.javascript.host.canvas.rendering.AwtRenderingBackend;
import com.gargoylesoftware.htmlunit.javascript.host.canvas.rendering.RenderingBackend;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLCanvasElement;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLImageElement;
import java.io.IOException;
import javax.imageio.ImageReader;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.Function;
import net.sourceforge.htmlunit.corejs.javascript.ScriptRuntime;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import net.sourceforge.htmlunit.corejs.javascript.Undefined;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@JsxClass
public class CanvasRenderingContext2D
extends SimpleScriptable {
    private static final Log LOG = LogFactory.getLog(CanvasRenderingContext2D.class);
    private final HTMLCanvasElement canvas_;
    private RenderingBackend renderingBackend_;

    @JsxConstructor(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF78})
    public CanvasRenderingContext2D() {
        this.canvas_ = null;
        this.renderingBackend_ = null;
    }

    public CanvasRenderingContext2D(HTMLCanvasElement canvas) {
        this.canvas_ = canvas;
        this.renderingBackend_ = null;
    }

    private RenderingBackend getRenderingBackend() {
        if (this.renderingBackend_ == null) {
            int imageWidth = Math.max(1, this.canvas_.getWidth());
            int imageHeight = Math.max(1, this.canvas_.getHeight());
            this.renderingBackend_ = new AwtRenderingBackend(imageWidth, imageHeight);
        }
        return this.renderingBackend_;
    }

    @JsxGetter
    public double getGlobalAlpha() {
        return this.getRenderingBackend().getGlobalAlpha();
    }

    @JsxSetter
    public void setGlobalAlpha(double globalAlpha) {
        this.getRenderingBackend().setGlobalAlpha(globalAlpha);
    }

    @JsxGetter
    public Object getFillStyle() {
        LOG.info((Object)"CanvasRenderingContext2D.getFillStyle() not yet implemented");
        return null;
    }

    @JsxSetter
    public void setFillStyle(String fillStyle) {
        this.getRenderingBackend().setFillStyle(fillStyle);
    }

    @JsxGetter
    public Object getStrokeStyle() {
        LOG.info((Object)"CanvasRenderingContext2D.getStrokeStyle() not yet implemented");
        return null;
    }

    @JsxSetter
    public void setStrokeStyle(String strokeStyle) {
        this.getRenderingBackend().setStrokeStyle(strokeStyle);
    }

    @JsxGetter
    public double getLineWidth() {
        return this.getRenderingBackend().getLineWidth();
    }

    @JsxSetter
    public void setLineWidth(Object lineWidth) {
        double width;
        if (!Undefined.isUndefined(lineWidth) && !Double.isNaN(width = Context.toNumber(lineWidth))) {
            this.getRenderingBackend().setLineWidth((int)width);
        }
    }

    @JsxFunction
    public void arc(double x, double y, double radius, double startAngle, double endAngle, boolean anticlockwise) {
        this.getRenderingBackend().arc(x, y, radius, startAngle, endAngle, anticlockwise);
    }

    @JsxFunction
    public void arcTo(double x1, double y1, double x2, double y2, double radius) {
        LOG.info((Object)"CanvasRenderingContext2D.arcTo() not yet implemented");
    }

    @JsxFunction
    public void beginPath() {
        this.getRenderingBackend().beginPath();
    }

    @JsxFunction
    public void bezierCurveTo(double cp1x, double cp1y, double cp2x, double cp2y, double x, double y) {
        this.getRenderingBackend().bezierCurveTo(cp1x, cp1y, cp2x, cp2y, x, y);
    }

    @JsxFunction
    public void clearRect(double x, double y, double w, double h) {
        this.getRenderingBackend().clearRect(x, y, w, h);
    }

    @JsxFunction
    public static void clip(Context context, Scriptable thisObj, Object[] args, Function function) {
        String windingRuleParam;
        if (!(thisObj instanceof CanvasRenderingContext2D)) {
            throw Context.reportRuntimeError("CanvasRenderingContext2D.getImageData() failed - this is not a CanvasRenderingContext2D");
        }
        CanvasRenderingContext2D canvas = (CanvasRenderingContext2D)thisObj;
        RenderingBackend.WindingRule windingRule = RenderingBackend.WindingRule.NON_ZERO;
        if (args.length == 1) {
            windingRuleParam = ScriptRuntime.toString(args[0]);
            if ("evenodd".contentEquals(windingRuleParam)) {
                windingRule = RenderingBackend.WindingRule.EVEN_ODD;
            }
            canvas.getRenderingBackend().clip(windingRule, null);
        }
        if (args.length > 1) {
            if (!(args[0] instanceof Path2D)) {
                throw Context.reportRuntimeError("CanvasRenderingContext2D.clip() failed - the first parameter has to be a Path2D");
            }
            windingRuleParam = ScriptRuntime.toString(args[1]);
            if ("evenodd".contentEquals(windingRuleParam)) {
                windingRule = RenderingBackend.WindingRule.EVEN_ODD;
            }
            LOG.info((Object)"CanvasRenderingContext2D.clip(path, fillRule) not yet implemented");
        }
        canvas.getRenderingBackend().clip(RenderingBackend.WindingRule.NON_ZERO, null);
    }

    @JsxFunction
    public void closePath() {
        this.getRenderingBackend().closePath();
    }

    @JsxFunction
    public static ImageData createImageData(Context context, Scriptable thisObj, Object[] args, Function function) {
        if (!(thisObj instanceof CanvasRenderingContext2D)) {
            throw Context.reportRuntimeError("CanvasRenderingContext2D.getImageData() failed - this is not a CanvasRenderingContext2D");
        }
        CanvasRenderingContext2D canvas = (CanvasRenderingContext2D)thisObj;
        if (args.length > 0 && args[0] instanceof ImageData) {
            ImageData imageDataParameter = (ImageData)args[0];
            ImageData imageData = new ImageData(null, 0, 0, imageDataParameter.getWidth(), imageDataParameter.getHeight());
            imageData.setParentScope(canvas.getParentScope());
            imageData.setPrototype(canvas.getPrototype(imageData.getClass()));
            return imageData;
        }
        if (args.length > 1) {
            int width = Math.abs((int)ScriptRuntime.toInteger(args, 0));
            int height = Math.abs((int)ScriptRuntime.toInteger(args, 1));
            ImageData imageData = new ImageData(null, 0, 0, width, height);
            imageData.setParentScope(canvas.getParentScope());
            imageData.setPrototype(canvas.getPrototype(imageData.getClass()));
            return imageData;
        }
        throw Context.reportRuntimeError("CanvasRenderingContext2D.getImageData() failed - wrong parameters given (" + StringUtils.join(args, ", ") + ")");
    }

    @JsxFunction
    public CanvasGradient createLinearGradient(double x0, double y0, double r0, double x1, Object y1, Object r1) {
        CanvasGradient canvasGradient = new CanvasGradient();
        canvasGradient.setParentScope(this.getParentScope());
        canvasGradient.setPrototype(this.getPrototype(canvasGradient.getClass()));
        return canvasGradient;
    }

    @JsxFunction
    public void createPattern() {
        LOG.info((Object)"CanvasRenderingContext2D.createPattern() not yet implemented");
    }

    @JsxFunction
    public CanvasGradient createRadialGradient(double x0, double y0, double r0, double x1, double y1, double r1) {
        CanvasGradient canvasGradient = new CanvasGradient();
        canvasGradient.setParentScope(this.getParentScope());
        canvasGradient.setPrototype(this.getPrototype(canvasGradient.getClass()));
        return canvasGradient;
    }

    @JsxFunction
    public void drawImage(Object image, int sx, int sy, Object sWidth, Object sHeight, Object dx, Object dy, Object dWidth, Object dHeight) {
        if (image instanceof HTMLImageElement) {
            HTMLImageElement imageElem = (HTMLImageElement)image;
            try {
                ImageReader imageReader = ((HtmlImage)imageElem.getDomNodeOrDie()).getImageReader();
                if (Undefined.isUndefined(sWidth)) {
                    this.getRenderingBackend().drawImage(imageReader, 0, 0, null, null, sx, sy, null, null);
                } else if (Undefined.isUndefined(dx)) {
                    int dWidthI = ScriptRuntime.toInt32(sWidth);
                    int dHeightI = ScriptRuntime.toInt32(sHeight);
                    this.getRenderingBackend().drawImage(imageReader, 0, 0, null, null, sx, sy, dWidthI, dHeightI);
                } else {
                    int sWidthI = ScriptRuntime.toInt32(sWidth);
                    int sHeightI = ScriptRuntime.toInt32(sHeight);
                    int dxI = ScriptRuntime.toInt32(dx);
                    int dyI = ScriptRuntime.toInt32(dy);
                    int dWidthI = ScriptRuntime.toInt32(dWidth);
                    int dHeightI = ScriptRuntime.toInt32(dHeight);
                    this.getRenderingBackend().drawImage(imageReader, sx, sy, sWidthI, sHeightI, dxI, dyI, dWidthI, dHeightI);
                }
            }
            catch (IOException ioe) {
                LOG.info((Object)("There is no ImageReader available for you imgage with src '" + imageElem.getSrc() + "'Please have a look at https://htmlunit.sourceforge.io/images-howto.html for a possible solution."));
            }
        }
    }

    public String toDataURL(String type) {
        try {
            if (type == null) {
                type = "image/png";
            }
            return "data:" + type + ";base64," + this.getRenderingBackend().encodeToString(type);
        }
        catch (IOException ioe) {
            throw Context.throwAsScriptRuntimeEx(ioe);
        }
    }

    @JsxFunction(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF78})
    public void ellipse(double x, double y, double radiusX, double radiusY, double rotation, double startAngle, double endAngle, boolean anticlockwise) {
        this.getRenderingBackend().ellipse(x, y, radiusX, radiusY, rotation, startAngle, endAngle, anticlockwise);
    }

    @JsxFunction
    public void fill() {
        this.getRenderingBackend().fill();
    }

    @JsxFunction
    public void fillRect(int x, int y, int w, int h) {
        this.getRenderingBackend().fillRect(x, y, w, h);
    }

    @JsxFunction
    public void fillText(String text, double x, double y) {
        this.getRenderingBackend().fillText(text, x, y);
    }

    @JsxFunction
    public ImageData getImageData(int sx, int sy, int sw, int sh) {
        ImageData imageData = new ImageData(this.getRenderingBackend(), sx, sy, sw, sh);
        imageData.setParentScope(this.getParentScope());
        imageData.setPrototype(this.getPrototype(imageData.getClass()));
        return imageData;
    }

    @JsxFunction
    public void getLineDash() {
        LOG.info((Object)"CanvasRenderingContext2D.getLineDash() not yet implemented");
    }

    @JsxFunction
    public void getLineData() {
        LOG.info((Object)"CanvasRenderingContext2D.getLineData() not yet implemented");
    }

    @JsxFunction
    public void isPointInPath() {
        LOG.info((Object)"CanvasRenderingContext2D.isPointInPath() not yet implemented");
    }

    @JsxFunction
    public void lineTo(double x, double y) {
        this.getRenderingBackend().lineTo(x, y);
    }

    @JsxFunction
    public TextMetrics measureText(Object text) {
        if (text == null || Undefined.isUndefined(text)) {
            throw Context.throwAsScriptRuntimeEx(new RuntimeException("Missing argument for CanvasRenderingContext2D.measureText()."));
        }
        String textValue = Context.toString(text);
        int width = textValue.length() * this.getBrowserVersion().getPixesPerChar();
        TextMetrics metrics = new TextMetrics(width);
        metrics.setParentScope(this.getParentScope());
        metrics.setPrototype(this.getPrototype(metrics.getClass()));
        return metrics;
    }

    @JsxFunction
    public void moveTo(double x, double y) {
        this.getRenderingBackend().moveTo(x, y);
    }

    @JsxFunction
    public void putImageData(ImageData imageData, int dx, int dy, Object dirtyX, Object dirtyY, Object dirtyWidth, Object dirtyHeight) {
        int dirtyXArg = 0;
        int dirtyYArg = 0;
        int dirtyWidthArg = imageData.getWidth();
        int dirtyHeightArg = imageData.getHeight();
        if (!Undefined.isUndefined(dirtyX)) {
            dirtyXArg = (int)ScriptRuntime.toInteger(dirtyX);
            if (Undefined.isUndefined(dirtyY) || Undefined.isUndefined(dirtyWidth) || Undefined.isUndefined(dirtyHeight)) {
                throw Context.reportRuntimeError("CanvasRenderingContext2D.putImageData() failed - seven parameters expected");
            }
            dirtyYArg = (int)ScriptRuntime.toInteger(dirtyY);
            dirtyWidthArg = (int)ScriptRuntime.toInteger(dirtyWidth);
            dirtyHeightArg = (int)ScriptRuntime.toInteger(dirtyHeight);
        }
        this.getRenderingBackend().putImageData(imageData, dx, dy, dirtyXArg, dirtyYArg, dirtyWidthArg, dirtyHeightArg);
    }

    @JsxFunction
    public void quadraticCurveTo(double controlPointX, double controlPointY, double endPointX, double endPointY) {
        this.getRenderingBackend().quadraticCurveTo(controlPointX, controlPointY, endPointX, endPointY);
    }

    @JsxFunction
    public void rect(double x, double y, double w, double h) {
        this.getRenderingBackend().rect(x, y, w, h);
    }

    @JsxFunction
    public void restore() {
        this.getRenderingBackend().restore();
    }

    @JsxFunction
    public void rotate(double angle) {
        this.getRenderingBackend().rotate(angle);
    }

    @JsxFunction
    public void save() {
        this.getRenderingBackend().save();
    }

    @JsxFunction
    public void scale(Object x, Object y) {
        LOG.info((Object)"CanvasRenderingContext2D.scale() not yet implemented");
    }

    @JsxFunction
    public void setLineDash() {
        LOG.info((Object)"CanvasRenderingContext2D.setLineDash() not yet implemented");
    }

    @JsxFunction
    public void setTransform(double m11, double m12, double m21, double m22, double dx, double dy) {
        this.getRenderingBackend().setTransform(m11, m12, m21, m22, dx, dy);
    }

    @JsxFunction
    public void stroke() {
        this.getRenderingBackend().stroke();
    }

    @JsxFunction
    public void strokeRect(int x, int y, int w, int h) {
        this.getRenderingBackend().strokeRect(x, y, w, h);
    }

    @JsxFunction
    public void strokeText() {
        LOG.info((Object)"CanvasRenderingContext2D.strokeText() not yet implemented");
    }

    @JsxFunction
    public void transform(double m11, double m12, double m21, double m22, double dx, double dy) {
        this.getRenderingBackend().transform(m11, m12, m21, m22, dx, dy);
    }

    @JsxFunction
    public void translate(int x, int y) {
        this.getRenderingBackend().translate(x, y);
    }

    @JsxGetter
    public HTMLCanvasElement getCanvas() {
        return this.canvas_;
    }
}

